/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.StringX;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Equal
extends AbstractFunctionEvaluator {
    private IExpr createComparatorResult(IAST lhsAST, IExpr rhs, ISymbol originalHead) {
        IAST lhsClone = lhsAST.clone();
        lhsClone.remove(1);
        return F.binary(originalHead, lhsClone, rhs);
    }

    protected IExpr simplifyCompare(IExpr a1, IExpr a2, ISymbol originalHead) {
        IExpr rhs;
        IExpr lhs;
        if (a2.isNumber()) {
            lhs = a1;
            rhs = a2;
        } else if (a1.isNumber()) {
            lhs = a2;
            rhs = a1;
        } else {
            return null;
        }
        if (lhs.isAST()) {
            IAST lhsAST = (IAST)lhs;
            if (lhsAST.isTimes()) {
                if (lhsAST.arg1().isNumber()) {
                    INumber sn = (INumber)lhsAST.arg1();
                    rhs = F.eval(F.Divide(rhs, sn));
                    return this.createComparatorResult(lhsAST, rhs, originalHead);
                }
            } else if (lhsAST.isPlus() && lhsAST.arg1().isNumber()) {
                INumber sn = (INumber)lhsAST.arg1();
                rhs = F.eval(F.Subtract(rhs, sn));
                return this.createComparatorResult(lhsAST, rhs, originalHead);
            }
        }
        return null;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() > 1) {
            IExpr result;
            if (ast.size() == 3 && (result = this.simplifyCompare(ast.arg1(), ast.arg2(), F.Equal)) != null) {
                return result;
            }
            int b = 0;
            boolean evaled = false;
            IAST result2 = ast.clone();
            int i = 2;
            while (i < result2.size()) {
                b = this.compare((IExpr)result2.get(i - 1), (IExpr)result2.get(i));
                if (b == -1) {
                    return F.False;
                }
                if (b == 1) {
                    evaled = true;
                    result2.remove(i - 1);
                    continue;
                }
                ++i;
            }
            if (evaled) {
                if (result2.size() == 2) {
                    return F.True;
                }
                return result2;
            }
        }
        return null;
    }

    public int compare(IExpr o0, IExpr o1) {
        if (o0.isSame(o1)) {
            return 1;
        }
        if (o0.isConstant() && o1.isConstant()) {
            return -1;
        }
        if (o0.isNumber() && o1.isNumber()) {
            return -1;
        }
        if (o0 instanceof StringX && o1 instanceof StringX) {
            if (o0.isSymbol() || o1.isSymbol()) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(8);
    }
}

