/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.poly.ExpVector;
import edu.jas.poly.ExpVectorLong;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.RingFactory;
import java.util.List;
import org.matheclipse.core.convert.JASIExpr;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ExprRingFactory;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class CoefficientList
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IExpr expr = F.evalExpandAll(ast.arg1());
        IExpr arg2 = ast.arg2();
        if (!arg2.isSymbol()) {
            return null;
        }
        try {
            IAST result = F.List();
            long degree = CoefficientList.univariateCoefficientList(expr, (ISymbol)arg2, result);
            if (degree >= 32767L) {
                throw new WrongArgumentType(ast, ast.arg1(), 1, "Polynomial degree" + degree + " is larger than: " + " - " + Short.MAX_VALUE);
            }
            return result;
        }
        catch (JASConversionException jce) {
            return null;
        }
    }

    public static long univariateCoefficientList(IExpr polynomial, ISymbol variable, List<IExpr> resultList) throws JASConversionException {
        JASIExpr jas = new JASIExpr(variable, (RingFactory<IExpr>)new ExprRingFactory());
        GenPolynomial<IExpr> polyExpr = jas.expr2IExprJAS(polynomial);
        long degree = polyExpr.degree();
        if (degree >= 32767L) {
            return degree;
        }
        int i = 0;
        while ((long)i <= degree) {
            IExpr temp = (IExpr)polyExpr.coefficient((ExpVector)new ExpVectorLong(1, 0, (long)i));
            resultList.add(temp);
            ++i;
        }
        return degree;
    }

    public static long univariateCoefficientList(IExpr polynomial, ISymbol variable, List<IExpr> resultList, List<IExpr> resultListDiff) throws JASConversionException {
        JASIExpr jas = new JASIExpr(variable, (RingFactory<IExpr>)new ExprRingFactory());
        GenPolynomial<IExpr> polyExpr = jas.expr2IExprJAS(polynomial);
        GenPolynomial polyExprDiff = PolyUtil.baseDeriviative(polyExpr);
        long degree = polyExpr.degree();
        if (degree >= 32767L) {
            return degree;
        }
        int i = 0;
        while ((long)i <= degree) {
            IExpr temp = (IExpr)polyExpr.coefficient((ExpVector)new ExpVectorLong(1, 0, (long)i));
            resultList.add(temp);
            ++i;
        }
        long degreeDiff = polyExprDiff.degree();
        int i2 = 0;
        while ((long)i2 <= degreeDiff) {
            IExpr temp = (IExpr)polyExprDiff.coefficient((ExpVector)new ExpVectorLong(1, 0, (long)i2));
            resultListDiff.add(F.eval(temp));
            ++i2;
        }
        return degree;
    }
}

