/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.boole.QuineMcCluskyFormula;
import org.matheclipse.core.eval.exception.BooleanFunctionConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class BooleanMinimize
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        if (ast.arg1().isASTSizeGE(F.Or, 3)) {
            try {
                QuineMcCluskyFormula f = QuineMcCluskyFormula.read((IAST)ast.arg1());
                f.reduceToPrimeImplicants();
                f.reducePrimeImplicantsToSubset();
                return f.toExpr();
            }
            catch (BooleanFunctionConversionException bfc) {
                return null;
            }
        }
        return null;
    }
}

