/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.matheclipse.combinatoric.MultisetPartitionsIterator;
import org.matheclipse.combinatoric.NumberPartitionsIterator;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternObject;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.FlatOrderlessStepVisitor;
import org.matheclipse.core.patternmatching.FlatStepVisitor;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.OrderlessStepVisitor;
import org.matheclipse.core.patternmatching.PatternMap;

public class PatternMatcher
extends IPatternMatcher
implements Serializable {
    private static final long serialVersionUID = -6708462090303928690L;
    protected IExpr fPatternCondition;
    protected PatternMap fPatternMap;

    public PatternMatcher() {
        super(null);
        this.fLhsPatternExpr = null;
        this.fPatternCondition = null;
        this.fPatternMap = new PatternMap();
    }

    public PatternMatcher(IExpr patternExpr) {
        super(patternExpr);
        this.fLhsPatternExpr = patternExpr;
        this.fPatternCondition = null;
        if (patternExpr.isCondition()) {
            this.fLhsPatternExpr = (IExpr)((IAST)patternExpr).get(1);
            this.fPatternCondition = (IExpr)((IAST)patternExpr).get(2);
        }
        this.fPatternMap = new PatternMap();
        this.init(this.fLhsPatternExpr);
    }

    protected final void init(IExpr patternExpr) {
        this.fPatternMap.determinePatterns(patternExpr);
    }

    public boolean checkRHSCondition(EvalEngine engine) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCondition() {
        if (this.fPatternCondition != null) {
            EvalEngine engine = EvalEngine.get();
            boolean traceMode = false;
            try {
                traceMode = engine.isTraceMode();
                engine.setTraceMode(false);
                IExpr substConditon = this.fPatternMap.substitutePatternSymbols(this.fPatternCondition);
                if (engine.evalTrue(substConditon)) {
                    boolean bl = this.checkRHSCondition(engine);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                engine.setTraceMode(traceMode);
            }
        }
        return true;
    }

    public static boolean equivalent(IExpr patternExpr1, IExpr patternExpr2) {
        if (!patternExpr1.isPatternExpr()) {
            if (!patternExpr2.isPatternExpr()) {
                return patternExpr1.equals(patternExpr2);
            }
            return false;
        }
        if (patternExpr1.isAST()) {
            if (patternExpr2.isAST()) {
                int i;
                IAST l1 = (IAST)patternExpr1;
                IAST l2 = (IAST)patternExpr2;
                if (l1.size() != l2.size()) {
                    return false;
                }
                for (i = 0; i < l1.size(); ++i) {
                    if (((IExpr)l1.get(i)).hashCode() == ((IExpr)l2.get(i)).hashCode() || ((IExpr)l1.get(i)).isPatternExpr() && ((IExpr)l2.get(i)).isPatternExpr()) continue;
                    return false;
                }
                for (i = 0; i < l1.size(); ++i) {
                    if (PatternMatcher.equivalent((IExpr)l1.get(i), (IExpr)l2.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (patternExpr1.isPattern()) {
            if (patternExpr2.isPattern()) {
                IPattern p1 = (IPattern)patternExpr1;
                IPattern p2 = (IPattern)patternExpr2;
                if (p1.getIndex() != p2.getIndex()) {
                    return false;
                }
                IExpr o1 = p1.getCondition();
                IExpr o2 = p2.getCondition();
                if (o1 == null || o2 == null) {
                    return o1 == o2;
                }
                return o1.equals(o2);
            }
            return false;
        }
        if (patternExpr1.isPatternSequence()) {
            if (patternExpr2.isPatternSequence()) {
                IPatternSequence p1 = (IPatternSequence)patternExpr1;
                IPatternSequence p2 = (IPatternSequence)patternExpr2;
                if (p1.getIndex() != p2.getIndex()) {
                    return false;
                }
                IExpr o1 = p1.getCondition();
                IExpr o2 = p2.getCondition();
                if (o1 == null || o2 == null) {
                    return o1 == o2;
                }
                return o1.equals(o2);
            }
            return false;
        }
        return patternExpr1.equals(patternExpr2);
    }

    @Override
    public void getPatterns(List<IExpr> resultList, IExpr pExpr) {
        if (pExpr.isAST()) {
            IAST list = (IAST)pExpr;
            this.getPatterns(resultList, list.head());
            for (int i = 1; i < list.size(); ++i) {
                this.getPatterns(resultList, (IExpr)list.get(i));
            }
        } else if (pExpr.isPattern()) {
            resultList.add(this.fPatternMap.getValue((IPattern)pExpr));
        }
    }

    @Override
    public final boolean isRuleWithoutPatterns() {
        return this.fPatternMap.isRuleWithoutPatterns();
    }

    @Override
    public boolean apply(IExpr leftHandSide) {
        if (this.isRuleWithoutPatterns()) {
            return this.fLhsPatternExpr.equals(leftHandSide);
        }
        this.fPatternMap.initPattern();
        return this.matchExpr(this.fLhsPatternExpr, leftHandSide);
    }

    protected boolean matchExpr(IExpr lhsPatternExpr, IExpr lhsEvalExpr) {
        return this.matchExpr(lhsPatternExpr, lhsEvalExpr, new StackMatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean matchExpr(IExpr lhsPatternExpr, IExpr lhsEvalExpr, StackMatcher stackMatcher) {
        matched = false;
        if (lhsPatternExpr.isAST()) {
            if (lhsPatternExpr.isCondition()) {
                if ((lhsPatternExpr = this.fPatternMap.substitutePatternSymbols(lhsPatternExpr)).isAST()) {
                    lhsPatternExpr = PatternMatcher.evalLeftHandSide((IAST)lhsPatternExpr);
                }
                if ((matcher = new PatternMatcher(lhsPatternExpr)).apply(lhsEvalExpr)) {
                    matched = true;
                    this.fPatternMap.copyPatternValuesFromPatternMatcher(matcher.fPatternMap);
                }
            } else {
                lhsPatternAST = (IAST)lhsPatternExpr;
                patternValues = this.fPatternMap.copyPattern();
                try {
                    matched = this.matchAST(lhsPatternAST, lhsEvalExpr, stackMatcher);
                    if ((lhsPatternAST.getEvalFlags() & 4) != 4 || matched) ** GOTO lbl35
                    temp = null;
                    symbol = lhsPatternAST.topHead();
                    attr = symbol.getAttributes();
                    this.fPatternMap.resetPattern(patternValues);
                    temp = this.matchDefaultAST(symbol, attr, lhsPatternAST);
                    if (temp == null) ** GOTO lbl35
                    matched = this.matchExpr(temp, lhsEvalExpr, stackMatcher);
                }
                finally {
                    if (!matched) {
                        this.fPatternMap.resetPattern(patternValues);
                    }
                }
            }
        } else if (lhsPatternExpr instanceof IPatternObject) {
            if (lhsPatternExpr.isPattern()) {
                matched = this.matchPattern((IPattern)lhsPatternExpr, lhsEvalExpr);
            } else if (lhsPatternExpr.isPatternSequence()) {
                matched = this.matchPatternSequence((IPatternSequence)lhsPatternExpr, F.Sequence(lhsEvalExpr));
            }
        } else {
            matched = lhsPatternExpr.equals(lhsEvalExpr);
        }
lbl35:
        // 7 sources

        if (matched) {
            return stackMatcher.matchRest();
        }
        return false;
    }

    private IExpr matchDefaultAST(ISymbol symbol, int attr, IAST ast) {
        IAST cloned = F.ast(ast.head(), ast.size(), false);
        for (int i = 1; i < ast.size(); ++i) {
            if (((IExpr)ast.get(i)).isPattern() && ((IPattern)ast.get(i)).isDefault()) {
                IExpr positionDefaultValue = symbol.getDefaultValue(i);
                if (positionDefaultValue != null) {
                    if (this.matchPattern((IPattern)ast.get(i), positionDefaultValue)) continue;
                    return null;
                }
                IExpr commonDefaultValue = symbol.getDefaultValue();
                if (commonDefaultValue != null) {
                    if (this.matchPattern((IPattern)ast.get(i), commonDefaultValue)) continue;
                    return null;
                }
            }
            cloned.add(ast.get(i));
        }
        if (cloned.size() == 2) {
            return (IExpr)cloned.get(1);
        }
        return null;
    }

    private boolean matchFlatAndFlatOrderlessAST(ISymbol sym, IAST lhsPatternAST, IAST lhsEvalAST, StackMatcher stackMatcher) {
        if ((sym.getAttributes() & 4) == 4) {
            FlatOrderlessStepVisitor visitor = new FlatOrderlessStepVisitor(sym, lhsPatternAST, lhsEvalAST, stackMatcher, this.fPatternMap);
            MultisetPartitionsIterator iter = new MultisetPartitionsIterator(visitor, lhsPatternAST.size() - 1);
            return !iter.execute();
        }
        FlatStepVisitor visitor = new FlatStepVisitor(sym, lhsPatternAST, lhsEvalAST, stackMatcher, this.fPatternMap);
        NumberPartitionsIterator iter = new NumberPartitionsIterator(visitor, lhsEvalAST.size() - 1, lhsPatternAST.size() - 1);
        return !iter.execute();
    }

    protected boolean matchAST(IAST lhsPatternAST, IExpr lhsEvalExpr, StackMatcher stackMatcher) {
        if (lhsEvalExpr instanceof IAST) {
            if (!lhsPatternAST.isPatternExpr() && lhsPatternAST.equals(lhsEvalExpr)) {
                return stackMatcher.matchRest();
            }
            IAST lhsEvalAST = (IAST)lhsEvalExpr;
            ISymbol sym = lhsPatternAST.topHead();
            if (lhsPatternAST.size() <= lhsEvalAST.size()) {
                if (lhsPatternAST.isFlatAST() && sym.equals(lhsEvalAST.topHead()) && (!lhsPatternAST.isOrderlessAST() || lhsPatternAST.size() != lhsEvalAST.size())) {
                    if (!this.matchExpr(lhsPatternAST.head(), lhsEvalAST.head())) {
                        return false;
                    }
                    return this.matchFlatAndFlatOrderlessAST(sym, lhsPatternAST, lhsEvalAST, stackMatcher);
                }
                if (lhsPatternAST.size() < lhsEvalAST.size()) {
                    if (lhsPatternAST.isEvalFlagOn(2)) {
                        if (!this.matchExpr(lhsPatternAST.head(), lhsEvalAST.head())) {
                            return false;
                        }
                        int lastPosition = lhsPatternAST.size() - 1;
                        if (((IExpr)lhsPatternAST.get(lastPosition)).isPatternSequence()) {
                            IAST seq = F.Sequence();
                            seq.addAll(lhsEvalAST, lastPosition, lhsEvalAST.size());
                            if (this.matchPatternSequence((IPatternSequence)lhsPatternAST.get(lastPosition), seq)) {
                                return this.matchAST(lhsPatternAST.copyUntil(lastPosition), lhsEvalAST.copyUntil(lastPosition), stackMatcher);
                            }
                        }
                    }
                    return false;
                }
            }
            if (lhsPatternAST.size() != lhsEvalAST.size()) {
                return false;
            }
            IExpr e1 = lhsPatternAST.head();
            IExpr e2 = lhsEvalAST.head();
            if (e1.isSymbol() && e2.isSymbol() ? !e1.equals(e2) : !this.matchExpr(lhsPatternAST.head(), lhsEvalAST.head())) {
                return false;
            }
            if (lhsPatternAST.isOrderlessAST()) {
                OrderlessStepVisitor visitor = new OrderlessStepVisitor(sym, lhsPatternAST, lhsEvalAST, stackMatcher, this.fPatternMap);
                MultisetPartitionsIterator iter = new MultisetPartitionsIterator(visitor, lhsPatternAST.size() - 1);
                return !iter.execute();
            }
            return this.matchASTSequence(lhsPatternAST, lhsEvalAST, 0, stackMatcher);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchASTSequence(IAST lhsPatternAST, IAST lhsEvalAST, int lhsEvalOffset, StackMatcher stackMatcher) {
        IExpr[] patternValues = this.fPatternMap.copyPattern();
        int lastStackSize = stackMatcher.size();
        boolean matched = true;
        try {
            boolean bl;
            for (int i = lhsPatternAST.size() - 1; i > 0; --i) {
                if (stackMatcher.push((IExpr)lhsPatternAST.get(i), (IExpr)lhsEvalAST.get(lhsEvalOffset + i))) continue;
                matched = false;
                boolean bl2 = false;
                return bl2;
            }
            if (!stackMatcher.matchRest()) {
                matched = false;
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            if (!matched) {
                stackMatcher.removeFrom(lastStackSize);
                this.fPatternMap.resetPattern(patternValues);
            }
        }
    }

    protected IExpr evalAST(IAST lhsPatternAST, IAST lhsEvalAST, IExpr rhsExpr, StackMatcher stackMatcher) {
        if (lhsPatternAST.size() < lhsEvalAST.size()) {
            if (lhsPatternAST.isOrderlessAST()) {
                if (!this.matchExpr(lhsPatternAST.head(), lhsEvalAST.head(), new StackMatcher())) {
                    return null;
                }
                OrderlessMatcher foMatcher = new OrderlessMatcher(lhsPatternAST, lhsEvalAST);
                boolean matched = foMatcher.matchOrderlessAST(1, stackMatcher);
                if (matched) {
                    IAST lhsResultAST = lhsEvalAST.clone();
                    foMatcher.filterResult(lhsResultAST);
                    try {
                        IExpr result = this.fPatternMap.substitutePatternSymbols(rhsExpr);
                        result = F.eval(result);
                        lhsResultAST.add(result);
                        return lhsResultAST;
                    }
                    catch (ConditionException e) {
                    }
                    catch (ReturnException e) {
                        lhsResultAST.add(e.getValue());
                        return lhsResultAST;
                    }
                    return null;
                }
            }
            if (lhsPatternAST.isFlatAST()) {
                if (!this.matchExpr(lhsPatternAST.head(), lhsEvalAST.head(), new StackMatcher())) {
                    return null;
                }
                int len = lhsEvalAST.size() - lhsPatternAST.size();
                for (int i = 0; i < len; ++i) {
                    if (!this.matchASTSequence(lhsPatternAST, lhsEvalAST, i, stackMatcher)) continue;
                    IAST lhsResultAST = lhsEvalAST.clone();
                    for (int j = 1; j < lhsPatternAST.size(); ++j) {
                        lhsResultAST.remove(i + 1);
                    }
                    try {
                        IExpr result = this.fPatternMap.substitutePatternSymbols(rhsExpr);
                        result = F.eval(result);
                        lhsResultAST.add(i + 1, result);
                        return lhsResultAST;
                    }
                    catch (ConditionException e) {
                    }
                    catch (ReturnException e) {
                        lhsResultAST.add(i + 1, e.getValue());
                        return lhsResultAST;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private boolean matchPattern(IPattern pattern, IExpr expr) {
        if (!pattern.isConditionMatched(expr)) {
            return false;
        }
        IExpr value = this.fPatternMap.getValue(pattern);
        if (value != null) {
            return expr.equals(value);
        }
        this.fPatternMap.setValue(pattern, expr);
        return true;
    }

    private boolean matchPatternSequence(IPatternSequence pattern, IAST sequence) {
        if (!pattern.isConditionMatchedSequence(sequence)) {
            return false;
        }
        IExpr value = this.fPatternMap.getValue(pattern);
        if (value != null) {
            return sequence.equals(value);
        }
        this.fPatternMap.setValue(pattern, sequence);
        return true;
    }

    @Override
    public IExpr eval(IExpr leftHandSide) {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternMatcher) {
            PatternMatcher pm = (PatternMatcher)obj;
            if (this.fPatternMap.size() != pm.fPatternMap.size()) {
                return false;
            }
            if (this.isRuleWithoutPatterns()) {
                return this.fLhsPatternExpr.equals(pm.fLhsPatternExpr);
            }
            if (PatternMatcher.equivalent(this.fLhsPatternExpr, pm.fLhsPatternExpr)) {
                if (this.fPatternCondition != null && pm.fPatternCondition != null) {
                    return this.fPatternCondition.equals(pm.fPatternCondition);
                }
                return this.fPatternCondition == null && pm.fPatternCondition == null;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fLhsPatternExpr.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PatternMatcher v = (PatternMatcher)super.clone();
        v.fPatternCondition = this.fPatternCondition;
        v.fPatternMap = this.fPatternMap.clone();
        return v;
    }

    public IExpr getCondition() {
        return this.fPatternCondition;
    }

    public void setCondition(IExpr condition) {
        this.fPatternCondition = condition;
    }

    public static IExpr evalLeftHandSide(IAST leftHandSide, EvalEngine engine) {
        return engine.evalSetAttributes(leftHandSide);
    }

    public static IExpr evalLeftHandSide(IAST leftHandSide) {
        return PatternMatcher.evalLeftHandSide(leftHandSide, EvalEngine.get());
    }

    public class OrderlessMatcher {
        private IAST fLHSPatternAST;
        private IAST fLHSEvalAST;
        private int[] fUsedIndex;

        public OrderlessMatcher(IAST lhsPatternAST, IAST lhsEvalAST) {
            this.fLHSPatternAST = lhsPatternAST;
            this.fLHSEvalAST = lhsEvalAST;
            this.fUsedIndex = new int[this.fLHSPatternAST.size() - 1];
            for (int l = 0; l < this.fUsedIndex.length; ++l) {
                this.fUsedIndex[l] = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matchOrderlessAST(int lhsPosition, StackMatcher stackMatcher) {
            if (lhsPosition >= this.fLHSPatternAST.size()) {
                return stackMatcher.matchRest();
            }
            IExpr subPattern = (IExpr)this.fLHSPatternAST.get(lhsPosition);
            IExpr[] patternValues = PatternMatcher.this.fPatternMap.copyPattern();
            for (int j = 1; j < this.fLHSEvalAST.size(); ++j) {
                boolean isNotInUse = true;
                for (int k = 0; k < this.fLHSPatternAST.size() - 1; ++k) {
                    if (this.fUsedIndex[k] != j) continue;
                    isNotInUse = false;
                    break;
                }
                if (!isNotInUse) continue;
                boolean matched = false;
                int lastStackSize = stackMatcher.size();
                try {
                    if (!stackMatcher.push(subPattern, (IExpr)this.fLHSEvalAST.get(j))) continue;
                    this.fUsedIndex[lhsPosition - 1] = j;
                    if (!this.matchOrderlessAST(lhsPosition + 1, stackMatcher)) continue;
                    matched = true;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (!matched) {
                        PatternMatcher.this.fPatternMap.resetPattern(patternValues);
                        stackMatcher.removeFrom(lastStackSize);
                        this.fUsedIndex[lhsPosition - 1] = -1;
                    }
                }
            }
            return false;
        }

        public void filterResult(IAST result) {
            for (int i = 0; i < this.fUsedIndex.length; ++i) {
                result.set(this.fUsedIndex[i], null);
            }
            int indx = 1;
            while (indx < result.size()) {
                if (result.get(indx) == null) {
                    result.remove(indx);
                    continue;
                }
                ++indx;
            }
        }
    }

    protected class StackMatcher {
        private ArrayList<Entry> fStack = new ArrayList();

        public Entry peek() {
            return this.fStack.get(this.fStack.size() - 1);
        }

        public Entry pop() {
            return this.fStack.remove(this.fStack.size() - 1);
        }

        public void removeFrom(int fromPosition) {
            for (int len = this.fStack.size(); len > fromPosition; --len) {
                this.fStack.remove(len - 1);
            }
        }

        public boolean push(IExpr patternExpr, IExpr evalExpr) {
            if (patternExpr.isPatternExpr()) {
                if (patternExpr.isAST()) {
                    this.fStack.add(new Entry(patternExpr, evalExpr));
                    return true;
                }
                if (patternExpr.isPattern()) {
                    return PatternMatcher.this.matchPattern((IPattern)patternExpr, evalExpr);
                }
                if (patternExpr.isPatternSequence()) {
                    return PatternMatcher.this.matchPatternSequence((IPatternSequence)patternExpr, F.Sequence(evalExpr));
                }
                throw new UnsupportedOperationException("Object doesn't support pattern-matching");
            }
            return patternExpr.equals(evalExpr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean matchRest() {
            if (this.isEmpty()) {
                return PatternMatcher.this.checkCondition();
            }
            boolean matched = true;
            Entry entry = this.pop();
            try {
                boolean bl = matched = PatternMatcher.this.matchExpr(entry.fPatternExpr, entry.fEvalExpr, this);
                return bl;
            }
            finally {
                if (!matched) {
                    this.fStack.add(entry);
                }
            }
        }

        public boolean isEmpty() {
            return this.fStack.isEmpty();
        }

        public int size() {
            return this.fStack.size();
        }
    }

    private static class Entry {
        IExpr fPatternExpr;
        IExpr fEvalExpr;

        public Entry(IExpr patternExpr, IExpr evalExpr) {
            this.fPatternExpr = patternExpr;
            this.fEvalExpr = evalExpr;
        }
    }
}

