/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class Pattern
extends ExprImpl
implements IPattern {
    private static final long serialVersionUID = 7617138748475243L;
    private static Pattern NULL_PATTERN = new Pattern(null);
    final IExpr fCondition;
    int fIndex = -1;
    final int fHashValue;
    final ISymbol fSymbol;
    final boolean fDefault;

    public static IPattern valueOf(ISymbol symbol, IExpr check, boolean def) {
        return new Pattern(symbol, check, def);
    }

    public static IPattern valueOf(ISymbol symbol, IExpr check) {
        return new Pattern(symbol, check);
    }

    public static IPattern valueOf(ISymbol symbol) {
        if (symbol == null) {
            return NULL_PATTERN;
        }
        return new Pattern(symbol);
    }

    private Pattern() {
        this(null, null, false);
    }

    Pattern(ISymbol symbol) {
        this(symbol, null, false);
    }

    Pattern(ISymbol symbol, IExpr condition) {
        this(symbol, condition, false);
    }

    Pattern(ISymbol symbol, IExpr condition, boolean def) {
        this.fHashValue = symbol == null ? 199 : 19 + symbol.hashCode();
        this.fSymbol = symbol;
        this.fCondition = condition;
        this.fDefault = def;
    }

    public boolean equals(Object obj) {
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (obj instanceof Pattern) {
            if (this == obj) {
                return true;
            }
            Pattern pattern = (Pattern)obj;
            if (this.fSymbol == pattern.fSymbol) {
                if (this.fCondition != null && pattern.fCondition != null) {
                    return this.fCondition.equals(pattern.fCondition);
                }
                return this.fCondition == pattern.fCondition;
            }
        }
        return false;
    }

    @Override
    public IExpr getCondition() {
        return this.fCondition;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }

    @Override
    public ISymbol getSymbol() {
        return this.fSymbol;
    }

    public int hashCode() {
        return this.fHashValue;
    }

    @Override
    public int hierarchy() {
        return 512;
    }

    @Override
    public void setIndex(int i) {
        this.fIndex = i;
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        if (symbolsAsFactoryMethod) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("$p(");
            if (this.fSymbol == null) {
                buffer.append("(ISymbol)null");
                if (this.fCondition != null) {
                    buffer.append("," + this.fCondition.internalFormString(symbolsAsFactoryMethod, 0));
                }
                if (this.fDefault) {
                    if (this.fCondition == null) {
                        buffer.append(",null");
                    }
                    buffer.append(",true");
                }
            } else {
                String symbolStr = this.fSymbol.toString();
                char ch = symbolStr.charAt(0);
                if (symbolStr.length() == 1 && this.fCondition == null && !this.fDefault && 'a' <= ch && ch <= 'z') {
                    return "$p(" + symbolStr + ")";
                }
                if (symbolStr.length() == 1 && 'a' <= ch && ch <= 'z') {
                    buffer.append(symbolStr);
                } else {
                    buffer.append("\"" + symbolStr + "\"");
                }
                if (this.fCondition != null) {
                    buffer.append("," + this.fCondition.internalFormString(symbolsAsFactoryMethod, 0));
                }
                if (this.fDefault) {
                    buffer.append(",true");
                }
            }
            buffer.append(')');
            return buffer.toString();
        }
        return this.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fSymbol == null) {
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
            if (this.fCondition != null) {
                buffer.append(this.fCondition.toString());
            }
        } else if (this.fCondition == null) {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
        } else {
            buffer.append(this.fSymbol.toString());
            buffer.append('_');
            if (this.fDefault) {
                buffer.append('.');
            }
            buffer.append(this.fCondition.toString());
        }
        return buffer.toString();
    }

    @Override
    public String fullFormString() {
        StringBuffer buf = new StringBuffer();
        if (this.fSymbol == null) {
            buf.append("Blank");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append(')');
            } else {
                buf.append(']');
            }
        } else {
            buf.append("Pattern");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            buf.append(this.fSymbol.toString());
            buf.append(", ");
            buf.append("Blank");
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append('(');
            } else {
                buf.append('[');
            }
            if (this.fCondition != null) {
                buf.append(this.fCondition.fullFormString());
            }
            if (Config.PARSER_USE_LOWERCASE_SYMBOLS) {
                buf.append("))");
            } else {
                buf.append("]]");
            }
        }
        return buf.toString();
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof Pattern) {
            int cp = this.fSymbol == null ? (((Pattern)obj).fSymbol == null ? -1 : 0) : (((Pattern)obj).fSymbol == null ? 1 : this.fSymbol.compareTo(((Pattern)obj).fSymbol));
            if (cp != 0) {
                return cp;
            }
            if (this.fCondition == null) {
                if (((Pattern)obj).fCondition != null) {
                    return -1;
                }
                return 0;
            }
            if (((Pattern)obj).fCondition == null) {
                return 1;
            }
            return this.fCondition.compareTo(((Pattern)obj).fCondition);
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public ISymbol head() {
        return F.PatternHead;
    }

    @Override
    public boolean isBlank() {
        return this.fSymbol == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConditionMatched(IExpr expr) {
        if (this.fCondition == null) {
            return true;
        }
        if (expr.head().equals(this.fCondition)) {
            return true;
        }
        EvalEngine engine = EvalEngine.get();
        boolean traceMode = false;
        try {
            traceMode = engine.isTraceMode();
            engine.setTraceMode(false);
            Predicate<IExpr> matcher = Predicates.isTrue(engine, this.fCondition);
            boolean bl = matcher.apply((Object)expr);
            return bl;
        }
        finally {
            if (traceMode) {
                engine.setTraceMode(true);
            }
        }
    }

    @Override
    public IExpr variables2Slots(Map<IExpr, IExpr> map, List<IExpr> variableList) {
        return null;
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isDefault() {
        return this.fDefault;
    }

    @Override
    public final boolean isPattern() {
        return true;
    }

    @Override
    public final boolean isPatternExpr() {
        return true;
    }

    public boolean isCase(IExpr that) {
        PatternMatcher matcher = new PatternMatcher(this);
        return ((IPatternMatcher)matcher).apply(that);
    }
}

