/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.lang.reflect.Method;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class MethodSymbol
extends Symbol {
    private static final long serialVersionUID = -4637484703674565623L;
    private static final int DEFAULT_VALUE_INDEX = Integer.MIN_VALUE;
    private Method fMethod;

    public MethodSymbol(String symbolName, String packagename, String classname, String methodname) {
        super(symbolName);
        try {
            Class<?> c = Class.forName(packagename + '.' + classname);
            this.fMethod = c.getDeclaredMethod(methodname, IAST.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MethodSymbol(String symbolName, String classname, String methodname) {
        this(symbolName, "org.matheclipse.core.reflection.system", classname, methodname);
    }

    public IExpr invoke(IAST args) {
        try {
            return (IExpr)this.fMethod.invoke(null, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.fMethod.equals(((MethodSymbol)obj).fMethod);
    }

    @Override
    public int hashCode() {
        return this.fMethod.hashCode();
    }

    @Override
    public int hierarchy() {
        return 1024;
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof MethodSymbol) {
            return this.fMethod.toString().compareTo(((MethodSymbol)obj).fMethod.toString());
        }
        return super.compareTo(obj);
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public ISymbol head() {
        return F.MethodHead;
    }

    @Override
    public String toString() {
        return this.fMethod.toString();
    }
}

