/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.util;

import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.util.ListSizeSequence;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class Sequence
extends ListSizeSequence {
    public Sequence(IInteger i) {
        super(i.toInt(), Integer.MIN_VALUE, 1, 1);
    }

    public Sequence(IAST lst) {
        super(Sequence.getASTFrom(lst), Sequence.getASTTo(lst), Sequence.getASTStep(lst), 1);
    }

    public static Sequence createSequence(IExpr expr) {
        Sequence sequ = null;
        if (expr.isList()) {
            sequ = new Sequence((IAST)expr);
        } else if (expr instanceof IInteger) {
            sequ = new Sequence((IInteger)expr);
        }
        return sequ;
    }

    public static Sequence[] createSequences(IAST ast, int offset) {
        Sequence[] sequArray = new Sequence[ast.size() - offset];
        Sequence sequ = null;
        int j = 0;
        for (int i = offset; i < ast.size(); ++i) {
            if (((IExpr)ast.get(i)).isList()) {
                sequ = new Sequence((IAST)ast.get(i));
            } else if (ast.get(i) instanceof IInteger) {
                sequ = new Sequence((IInteger)ast.get(i));
            }
            sequArray[j++] = sequ;
        }
        return sequArray;
    }

    private static int getASTFrom(IAST lst) {
        if (lst.size() > 1 && !(lst.get(1) instanceof IInteger)) {
            throw new WrongArgumentType(lst, (IExpr)lst.get(1), 1);
        }
        if (lst.size() > 1) {
            return ((IInteger)lst.get(1)).toInt();
        }
        return 0;
    }

    private static int getASTTo(IAST lst) {
        if (lst.size() == 2 && lst.get(1) instanceof IInteger) {
            return ((IInteger)lst.get(1)).toInt();
        }
        if (lst.size() > 2 && !(lst.get(2) instanceof IInteger)) {
            throw new WrongArgumentType(lst, (IExpr)lst.get(2), 2);
        }
        if (lst.size() > 2) {
            return ((IInteger)lst.get(2)).toInt();
        }
        return Integer.MIN_VALUE;
    }

    private static int getASTStep(IAST lst) {
        if (lst.size() > 3 && !(lst.get(3) instanceof IInteger)) {
            throw new WrongArgumentType(lst, (IExpr)lst.get(3), 3);
        }
        if (lst.size() > 3) {
            return ((IInteger)lst.get(3)).toInt();
        }
        return 1;
    }
}

