/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.math.MathException;

public class SymjaInterpreter
extends EvalUtilities {
    String codeString;
    PrintStream outStream;

    public SymjaInterpreter(String codeString, OutputStream out) {
        super(new EvalEngine(), false, true);
        this.codeString = codeString;
        this.outStream = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        this.fEvalEngine.setOutPrintStream(this.outStream);
    }

    public String interpreter(String function) {
        ASTNode node;
        String evalStr = this.codeString;
        try {
            Parser p = new Parser(true);
            if (function != null) {
                evalStr = function + "(" + this.codeString + ")";
            }
            node = p.parse(evalStr);
        }
        catch (SyntaxError e1) {
            try {
                Parser p = new Parser();
                if (function != null) {
                    evalStr = function + "[" + this.codeString + "]";
                }
                node = p.parse(evalStr);
            }
            catch (Exception e2) {
                this.outStream.println(e2.getMessage());
                return "";
            }
        }
        StringBuilder buf = new StringBuilder();
        try {
            IExpr expr = AST2Expr.CONST_LC.convert(node);
            IExpr result = this.evaluate(expr);
            OutputFormFactory.get(true).convert(buf, result);
            return buf.toString();
        }
        catch (RuntimeException re) {
            Throwable me = re.getCause();
            if (me instanceof MathException) {
                this.printException(buf, me);
            } else {
                this.printException(buf, re);
            }
        }
        catch (Exception e) {
            this.printException(buf, e);
        }
        return buf.toString();
    }

    public String interpreter(IAST function) {
        ASTNode node;
        String evalStr = this.codeString;
        try {
            Parser p = new Parser(true);
            node = p.parse(evalStr);
        }
        catch (SyntaxError e1) {
            try {
                Parser p = new Parser();
                node = p.parse(evalStr);
            }
            catch (Exception e2) {
                this.outStream.println(e2.getMessage());
                return "";
            }
        }
        StringBuilder buf = new StringBuilder();
        try {
            IExpr expr = AST2Expr.CONST_LC.convert(node);
            if (function != null) {
                expr = function.replaceAll(F.Rule(F.Slot1, expr));
            }
            IExpr result = this.evaluate(expr);
            OutputFormFactory.get(true).convert(buf, result);
            return buf.toString();
        }
        catch (RuntimeException re) {
            Throwable me = re.getCause();
            if (me instanceof MathException) {
                this.printException(buf, me);
            } else {
                this.printException(buf, re);
            }
        }
        catch (Exception e) {
            this.printException(buf, e);
        }
        return buf.toString();
    }

    private void printException(Appendable buf, Throwable e) {
        String msg = e.getMessage();
        try {
            if (msg != null) {
                buf.append("\nError: " + msg);
            } else {
                buf.append("\nError: " + e.getClass().getSimpleName());
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    public void eval(String function) {
        String result = this.interpreter(function);
        this.outStream.print(result);
    }

    public void eval(IAST function) {
        String result = this.interpreter(function);
        this.outStream.print(result);
    }
}

