/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.matheclipse.core.generic.ExprComparator;
import org.matheclipse.core.generic.interfaces.BiFunction;
import org.matheclipse.core.generic.interfaces.BiPredicate;
import org.matheclipse.core.generic.interfaces.IUnaryIndexFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Range
implements Iterable<IExpr> {
    final IAST fList;
    final int fStart;
    final int fEnd;

    public Range(IAST list) {
        this(list, 0, list.size());
    }

    public Range(IAST list, int start) {
        this(list, start, list.size());
    }

    public Range(IAST list, int start, int end) {
        this.fList = list;
        this.fStart = start;
        this.fEnd = end;
        if (this.fStart < 0 || this.fStart > this.fList.size()) {
            throw new IndexOutOfBoundsException("Start index not allowed for the given list");
        }
        if (this.fEnd < 0 || this.fEnd > this.fList.size()) {
            throw new IndexOutOfBoundsException("End index not allowed for the given list");
        }
        if (this.fStart > this.fEnd) {
            throw new IndexOutOfBoundsException("Start index greater than end index");
        }
    }

    public boolean all(Predicate<IExpr> predicate) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (predicate.apply(this.fList.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean all(Predicate<IExpr>[] predicates) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            for (int j = 0; j < predicates.length; ++j) {
                if (predicates[i].apply(this.fList.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean any(Predicate<IExpr> predicate) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (!predicate.apply(this.fList.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean any(Predicate<IExpr>[] predicates) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            for (int j = 0; j < predicates.length; ++j) {
                if (!predicates[i].apply(this.fList.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean compareAdjacent(BiPredicate<IExpr> predicate) {
        if (this.fStart >= this.fEnd - 1) {
            return false;
        }
        IExpr elem = (IExpr)this.fList.get(this.fStart);
        for (int i = this.fStart + 1; i < this.fEnd; ++i) {
            if (!predicate.apply(elem, (IExpr)this.fList.get(i))) {
                return false;
            }
            elem = (IExpr)this.fList.get(i);
        }
        return true;
    }

    public Collection<IExpr> complement(Collection<IExpr> result, Range secondRange) {
        if (this.size() == 0 && secondRange.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet((Iterable)secondRange);
        Sets.SetView set3 = Sets.difference((Set)set1, (Set)set2);
        for (IExpr IExpr2 : set3) {
            result.add(IExpr2);
        }
        return result;
    }

    public boolean contains(IExpr o) {
        return this.indexOf(o) >= 0;
    }

    public boolean containsAll(Collection<? extends IExpr> c) {
        Iterator<? extends IExpr> IExpr2 = c.iterator();
        while (IExpr2.hasNext()) {
            if (this.contains(IExpr2.next())) continue;
            return false;
        }
        return true;
    }

    public int count(Object value) {
        int counter = 0;
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (!value.equals(this.fList.get(i))) continue;
            ++counter;
        }
        return counter;
    }

    public int countIf(Predicate<IExpr> predicate) {
        int counter = 0;
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (!predicate.apply(this.fList.get(i))) continue;
            ++counter;
        }
        return counter;
    }

    public Collection<IExpr> difference(Collection<IExpr> result, Range secondList) {
        if (this.size() == 0 && secondList.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet((Iterable)secondList);
        Sets.SetView set3 = Sets.difference((Set)set1, (Set)set2);
        for (IExpr IExpr2 : set3) {
            result.add(IExpr2);
        }
        return result;
    }

    public IAST filter(IAST filterList, Collection<IExpr> restList, Predicate<IExpr> predicate) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (predicate.apply(this.fList.get(i))) {
                filterList.add(this.fList.get(i));
                continue;
            }
            restList.add((IExpr)this.fList.get(i));
        }
        return filterList;
    }

    public Collection<IExpr> filter(Collection<IExpr> filterList, Collection<IExpr> restList, Function<IExpr, IExpr> function) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            IExpr expr = (IExpr)function.apply(this.fList.get(i));
            if (expr != null) {
                filterList.add(expr);
                continue;
            }
            restList.add((IExpr)this.fList.get(i));
        }
        return filterList;
    }

    public IAST filter(IAST list, Predicate<IExpr> predicate) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (!predicate.apply(this.fList.get(i))) continue;
            list.add(this.fList.get(i));
        }
        return list;
    }

    public IAST filter(IAST list, Predicate<IExpr> predicate, int maxMatches) {
        int count = 0;
        if (count == maxMatches) {
            return list;
        }
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (!predicate.apply(this.fList.get(i))) continue;
            if (++count == maxMatches) {
                list.add(this.fList.get(i));
                break;
            }
            list.add(this.fList.get(i));
        }
        return list;
    }

    public int findAdjacent(Object match) {
        return this.findAdjacent(match, this.fStart);
    }

    public int findAdjacent(Object match, int start) {
        if (match == null) {
            for (int i = this.fStart; i < this.fEnd - 1; ++i) {
                if (this.fList.get(i) != null || this.fList.get(i + 1) != null) continue;
                return i;
            }
        } else {
            for (int i = this.fStart; i < this.fEnd - 1; ++i) {
                if (!match.equals(this.fList.get(i)) || !match.equals(this.fList.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public int findAdjacent(Predicate<IExpr> predicate) {
        return this.findAdjacent(predicate, this.fStart);
    }

    private int findAdjacent(Predicate<IExpr> predicate, int start) {
        for (int i = start; i < this.fEnd - 1; ++i) {
            if (!predicate.apply(this.fList.get(i)) || !predicate.apply(this.fList.get(i + 1))) continue;
            return i;
        }
        return -1;
    }

    public IExpr foldLeft(BiFunction<IExpr, IExpr, ? extends IExpr> function, IExpr startValue) {
        IExpr value = startValue;
        for (int i = this.fStart; i < this.fEnd; ++i) {
            value = function.apply(value, (IExpr)this.fList.get(i));
        }
        return value;
    }

    public IExpr foldRight(BiFunction<IExpr, IExpr, ? extends IExpr> function, IExpr startValue) {
        IExpr value = startValue;
        for (int i = this.fEnd - 1; i >= this.fStart; --i) {
            value = function.apply(value, (IExpr)this.fList.get(i));
        }
        return value;
    }

    public IExpr forEach(Function<IExpr, ? extends IExpr> function) {
        IExpr value = null;
        for (int i = this.fStart; i < this.fEnd; ++i) {
            value = (IExpr)function.apply(this.fList.get(i));
        }
        return value;
    }

    public final IExpr get(int index) {
        return (IExpr)this.fList.get(index);
    }

    public final int getEnd() {
        return this.fEnd;
    }

    public final IAST getList() {
        return this.fList;
    }

    public final int getStart() {
        return this.fStart;
    }

    public int indexOf(IExpr match) {
        return this.indexOf(match, this.fStart);
    }

    public int indexOf(IExpr match, int start) {
        if (match == null) {
            for (int i = start; i < this.fEnd; ++i) {
                if (this.fList.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < this.fEnd; ++i) {
                if (!match.equals(this.fList.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(Predicate<IExpr> predicate) {
        return this.indexOf(predicate, this.fStart);
    }

    public int indexOf(Predicate<IExpr> predicate, int start) {
        for (int i = start; i < this.fEnd; ++i) {
            if (!predicate.apply(this.fList.get(i))) continue;
            return i;
        }
        return -1;
    }

    public Collection<IExpr> intersection(Collection<IExpr> result, Range secondList) {
        if (this.size() == 0 && secondList.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet((Iterable)secondList);
        Sets.SetView set3 = Sets.intersection((Set)set1, (Set)set2);
        for (IExpr IExpr2 : set3) {
            result.add(IExpr2);
        }
        return result;
    }

    @Override
    public Iterator<IExpr> iterator() {
        return new RangeIterator(this);
    }

    public int lastIndexOf(Object match) {
        if (match == null) {
            for (int i = this.fEnd - 1; i >= this.fStart; --i) {
                if (this.fList.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.fEnd - 1; i >= this.fStart; --i) {
                if (!match.equals(this.fList.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Predicate<IExpr> predicate) {
        for (int i = this.fEnd - 1; i >= this.fStart; --i) {
            if (!predicate.apply(this.fList.get(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean map(Collection<IExpr> list, BiFunction<IExpr, IExpr, IExpr> function) {
        if (this.fStart >= this.fEnd) {
            return false;
        }
        boolean evaled = false;
        IExpr element = (IExpr)this.fList.get(this.fStart);
        for (int i = this.fStart + 1; i < this.fEnd; ++i) {
            IExpr result = function.apply(element, (IExpr)this.fList.get(i));
            if (result == null) {
                list.add(element);
                element = (IExpr)this.fList.get(i);
                continue;
            }
            evaled = true;
            element = result;
        }
        list.add(element);
        return evaled;
    }

    public IAST map(IAST list, Function<IExpr, IExpr> function) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            list.add(function.apply(this.fList.get(i)));
        }
        return list;
    }

    public IAST map(IAST list, IUnaryIndexFunction<IExpr, IExpr> function) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            list.add(function.apply(i, (IExpr)this.fList.get(i)));
        }
        return list;
    }

    public IAST mapLeft(IAST list, BiFunction<IExpr, IExpr, IExpr> binaryFunction, IExpr leftArg) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            list.add(binaryFunction.apply(leftArg, (IExpr)this.fList.get(i)));
        }
        return list;
    }

    public Collection<IExpr> mapRight(Collection<IExpr> list, BiFunction<IExpr, IExpr, IExpr> binaryFunction, IExpr rightArg) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            list.add(binaryFunction.apply((IExpr)this.fList.get(i), rightArg));
        }
        return list;
    }

    public IExpr max(Comparator<? super IExpr> comp) {
        IExpr value = (IExpr)this.fList.get(this.fStart);
        for (int i = this.fStart + 1; i < this.fEnd; ++i) {
            if (comp.compare((IExpr)this.fList.get(i), value) <= 0) continue;
            value = (IExpr)this.fList.get(i);
        }
        return value;
    }

    public IExpr min(Comparator<? super IExpr> comp) {
        IExpr value = (IExpr)this.fList.get(this.fStart);
        for (int i = this.fStart + 1; i < this.fEnd; ++i) {
            if (comp.compare((IExpr)this.fList.get(i), value) >= 0) continue;
            value = (IExpr)this.fList.get(i);
        }
        return value;
    }

    public Collection<IExpr> removeAll(Collection<IExpr> list, Predicate<IExpr> predicate) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            if (predicate.apply(this.fList.get(i))) continue;
            list.add((IExpr)this.fList.get(i));
        }
        return list;
    }

    public Collection<IExpr> replaceAll(Collection<IExpr> list, Function<IExpr, ? extends IExpr> function) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            list.add((IExpr)function.apply(this.fList.get(i)));
        }
        return list;
    }

    public Collection<IExpr> reverse(Collection<IExpr> list) {
        for (int i = this.fEnd - 1; i >= this.fStart; --i) {
            list.add((IExpr)this.fList.get(i));
        }
        return list;
    }

    public Collection<IExpr> rotateLeft(Collection<IExpr> list, int n) {
        int i;
        for (i = this.fStart + n; i < this.fEnd; ++i) {
            list.add((IExpr)this.fList.get(i));
        }
        if (n <= this.size()) {
            for (i = this.fStart; i < this.fStart + n; ++i) {
                list.add((IExpr)this.fList.get(i));
            }
        }
        return list;
    }

    public Collection<IExpr> rotateRight(Collection<IExpr> list, int n) {
        if (n <= this.size()) {
            int i;
            for (i = this.fEnd - n; i < this.fEnd; ++i) {
                list.add((IExpr)this.fList.get(i));
            }
            for (i = this.fStart; i < this.fEnd - n; ++i) {
                list.add((IExpr)this.fList.get(i));
            }
        }
        return list;
    }

    public int size() {
        return this.fEnd - this.fStart;
    }

    public IAST sort(ExprComparator comparator) {
        IExpr[] a = (IExpr[])this.fList.toArray(new IExpr[this.fList.size()]);
        Arrays.sort(a, this.fStart, this.fEnd, comparator);
        for (int j = this.fStart; j < this.fEnd; ++j) {
            this.fList.set(j, a[j]);
        }
        return this.fList;
    }

    public IExpr[] toArray(IExpr[] array) {
        int j = this.fStart;
        for (int i = 0; i < array.length; ++i) {
            array[i] = (IExpr)this.fList.get(j++);
            if (j >= array.length) break;
        }
        return array;
    }

    public List<IExpr> toList(List<IExpr> list) {
        for (int i = this.fStart; i < this.fEnd; ++i) {
            list.add((IExpr)this.fList.get(i));
        }
        return list;
    }

    public Collection<IExpr> union(Collection<IExpr> result, Range secondList) {
        if (this.size() == 0 && secondList.size() == 0) {
            return result;
        }
        HashSet set1 = Sets.newHashSet((Iterable)this);
        HashSet set2 = Sets.newHashSet((Iterable)secondList);
        Sets.SetView set3 = Sets.union((Set)set1, (Set)set2);
        for (IExpr IExpr2 : set3) {
            result.add(IExpr2);
        }
        return result;
    }

    class RangeIterator
    implements Iterator<IExpr> {
        private int fCurrrent;
        private Range fRange;

        public RangeIterator(Range range2) {
            this.fRange = range2;
            this.fCurrrent = this.fRange.fStart;
        }

        @Override
        public boolean hasNext() {
            return this.fCurrrent < this.fRange.fEnd;
        }

        @Override
        public IExpr next() {
            return this.fRange.get(this.fCurrrent++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

