/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import org.matheclipse.core.basic.Alloc;
import org.matheclipse.core.eval.CoreCallbackFunction;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.eval.interfaces.ISignedNumberConstant;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.eval.DoubleEvaluator;

public class EvalDouble
extends DoubleEvaluator {
    public EvalDouble() {
        this(null, false);
    }

    public EvalDouble(boolean relaxedSyntax) {
        this(null, relaxedSyntax);
    }

    public EvalDouble(ASTNode node, boolean relaxedSyntax) {
        super(node, relaxedSyntax);
        this.setCallbackFunction(CoreCallbackFunction.CONST);
    }

    public static double eval(double[] stack, int top, IExpr expr) {
        if (expr instanceof IAST) {
            return EvalDouble.evalAST(stack, top, (IAST)expr);
        }
        if (expr instanceof ISignedNumber) {
            return ((ISignedNumber)expr).doubleValue();
        }
        if (expr instanceof ISymbol) {
            return EvalDouble.evalSymbol((ISymbol)expr);
        }
        throw new UnsupportedOperationException("EvalDouble#eval(): " + expr);
    }

    public static double evalAST(double[] stack, int top, IAST ast) {
        ISymbol symbol = (ISymbol)ast.get(0);
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof INumeric) {
            int newTop = top;
            if (top + ast.size() >= stack.length) {
                stack = Alloc.vector(ast.size() + 50);
            }
            for (int i = 1; i < ast.size(); ++i) {
                stack[++newTop] = EvalDouble.eval(stack, newTop, (IExpr)ast.get(i));
            }
            return ((INumeric)((Object)module)).evalReal(stack, newTop, ast.size() - 1);
        }
        IExpr result = F.evaln(ast);
        if (result instanceof Num) {
            return ((Num)result).doubleValue();
        }
        throw new UnsupportedOperationException("EvalDouble#evalAST(): " + ast);
    }

    public static double evalSymbol(ISymbol symbol) {
        if (symbol.hasLocalVariableStack()) {
            return ((ISignedNumber)symbol.get()).doubleValue();
        }
        IEvaluator module = symbol.getEvaluator();
        if (module instanceof ISignedNumberConstant) {
            return ((ISignedNumberConstant)((Object)module)).evalReal();
        }
        IExpr result = F.evaln(symbol);
        if (result instanceof Num) {
            return ((Num)result).doubleValue();
        }
        throw new UnsupportedOperationException("EvalDouble#evalSymbol() - no value assigned for symbol: " + symbol);
    }

    static {
        F.initSymbols();
    }
}

