/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.math3.complex.Complex;
import org.matheclipse.core.convert.ConversionException;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Object2Expr {
    public static final Object2Expr CONST = new Object2Expr(Object.class, IExpr.class);

    public Object2Expr(Class sType, Class tType) {
    }

    public IExpr convert(Object obj) throws ConversionException {
        if (obj == null) {
            return F.Null;
        }
        if (obj instanceof IExpr) {
            return (IExpr)obj;
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                return F.True;
            }
            return F.False;
        }
        if (obj instanceof BigInteger) {
            return F.integer((BigInteger)obj);
        }
        if (obj instanceof BigInteger) {
            return F.integer((BigInteger)obj);
        }
        if (obj instanceof Number) {
            if (obj instanceof BigDecimal) {
                return F.num(((BigDecimal)obj).doubleValue());
            }
            if (obj instanceof Double) {
                return F.num((Double)obj);
            }
            if (obj instanceof Float) {
                return F.num(((Float)obj).doubleValue());
            }
            return F.integer(((Number)obj).longValue());
        }
        if (obj instanceof List) {
            List lst = (List)obj;
            IAST list = null;
            if (lst.size() == 0) {
                list = F.List();
            } else {
                ISymbol head = F.$s(lst.get(0).toString());
                list = F.ast(head);
                for (int i = 1; i < lst.size(); ++i) {
                    list.add(this.convert(lst.get(i)));
                }
            }
            return list;
        }
        if (obj instanceof Object[]) {
            IAST list = F.List();
            Object[] array = (Object[])obj;
            for (int i = 0; i < array.length; ++i) {
                list.add(this.convert(array[i]));
            }
            return list;
        }
        if (obj instanceof int[]) {
            return AST.newInstance(F.List, (int[])obj);
        }
        if (obj instanceof double[]) {
            return AST.newInstance(F.List, (double[])obj);
        }
        if (obj instanceof double[][]) {
            double[][] dd = (double[][])obj;
            IAST list = F.List();
            for (int i = 0; i < dd.length; ++i) {
                IAST row = F.List();
                for (int j = 0; j < dd[i].length; ++j) {
                    row.add(F.num(dd[i][j]));
                }
                list.add(row);
            }
            return list;
        }
        if (obj instanceof Complex[]) {
            return AST.newInstance(F.List, (Complex[])obj);
        }
        if (obj instanceof boolean[]) {
            IAST list = F.List();
            boolean[] array = (boolean[])obj;
            for (int i = 0; i < array.length; ++i) {
                if (array[i]) {
                    list.add(F.True);
                    continue;
                }
                list.add(F.False);
            }
            return list;
        }
        return F.stringx(obj.toString());
    }

    public static IExpr convertComplex(Complex[] array) throws ConversionException {
        return AST.newInstance(F.List, array);
    }
}

