/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.convert;

import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Expr2Object {
    public static int MAX_POLYNOMIAL = 4;

    public static double[] toDoubleVector(IAST ast) throws WrongArgumentType {
        double[] result = new double[ast.size() - 1];
        for (int i = 1; i < ast.size(); ++i) {
            if (!((IExpr)ast.get(i)).isSignedNumber()) {
                throw new WrongArgumentType(ast, (IExpr)ast.get(i), i, "Conversion into a vector of double values not possible!");
            }
            result[i - 1] = ((ISignedNumber)ast.get(i)).doubleValue();
        }
        return result;
    }

    public static double[][] toDoubleMatrix(IAST ast) throws WrongArgumentType {
        int[] dim = ast.isMatrix();
        double[][] result = new double[dim[0]][dim[1]];
        for (int i = 1; i <= dim[0]; ++i) {
            IAST row = (IAST)ast.get(i);
            int j = 1;
            while (i <= dim[1]) {
                if (!((IExpr)row.get(j)).isSignedNumber()) {
                    throw new WrongArgumentType(ast, (IExpr)ast.get(i), i, "Conversion into a matrix of double values not possible!");
                }
                result[i - 1][j - 1] = ((ISignedNumber)row.get(j)).doubleValue();
                ++j;
            }
        }
        return result;
    }

    public static double[] toPolynomial(IExpr expr, ISymbol sym) {
        double[] array = new double[MAX_POLYNOMIAL];
        Map<Integer, Double> map = Expr2Object.toPolynomialMap(expr, sym);
        if (map == null) {
            return null;
        }
        for (Map.Entry<Integer, Double> entry : map.entrySet()) {
            int k = entry.getKey();
            if (k <= 4) {
                array[k] = entry.getValue();
                continue;
            }
            return null;
        }
        return array;
    }

    public static Map<Integer, Double> toPolynomialMap(IExpr expr, ISymbol sym) {
        try {
            HashMap<Integer, Double> map = new HashMap<Integer, Double>();
            if (expr.isPlus()) {
                IAST plus = (IAST)expr;
                for (int i = 1; i < plus.size(); ++i) {
                    if (((IExpr)plus.get(i)).isTimes()) {
                        IAST times = (IAST)plus.get(i);
                        double coeff = 0.0;
                        int exp = -1;
                        for (int j = 1; j < times.size(); ++j) {
                            if (((IExpr)times.get(j)).isPower()) {
                                IAST power = (IAST)times.get(j);
                                if (((IExpr)power.get(1)).equals(sym)) {
                                    if (exp != -1) {
                                        return null;
                                    }
                                    IExpr res = F.evaln((IExpr)power.get(2));
                                    if (!(res instanceof INum)) {
                                        return null;
                                    }
                                    exp = DoubleMath.roundToInt((double)((INum)res).doubleValue(), (RoundingMode)RoundingMode.UNNECESSARY);
                                    if (exp >= 0) continue;
                                    return null;
                                }
                            } else if (((IExpr)times.get(j)).isSymbol() && ((IExpr)times.get(j)).equals(sym)) {
                                if (exp != -1) {
                                    return null;
                                }
                                exp = 1;
                                continue;
                            }
                            if (times.get(j) instanceof INum) {
                                coeff += ((INum)times.get(j)).doubleValue();
                                continue;
                            }
                            IExpr res = F.evaln((IExpr)times.get(j));
                            if (!(res instanceof INum)) {
                                return null;
                            }
                            coeff += ((INum)res).doubleValue();
                        }
                        if (exp == -1) {
                            exp = 0;
                        }
                        Expr2Object.addCoefficient(map, coeff, exp);
                        continue;
                    }
                    if (((IExpr)plus.get(i)).isPower()) {
                        IAST power = (IAST)plus.get(i);
                        if (((IExpr)power.get(1)).equals(sym)) {
                            IExpr res = F.evaln((IExpr)power.get(2));
                            if (!(res instanceof INum)) {
                                return null;
                            }
                            int exp = DoubleMath.roundToInt((double)((INum)res).doubleValue(), (RoundingMode)RoundingMode.UNNECESSARY);
                            if (exp < 0) {
                                return null;
                            }
                            Expr2Object.addCoefficient(map, 1.0, exp);
                            continue;
                        }
                        return null;
                    }
                    if (((IExpr)plus.get(i)).isSymbol()) {
                        if (((IExpr)plus.get(i)).equals(sym)) {
                            Expr2Object.addCoefficient(map, 1.0, 1);
                            continue;
                        }
                        return null;
                    }
                    if (plus.get(i) instanceof INum) {
                        Expr2Object.addCoefficient(map, ((INum)plus.get(i)).doubleValue(), 0);
                        continue;
                    }
                    IExpr res = F.evaln((IExpr)plus.get(i));
                    if (!(res instanceof INum)) {
                        return null;
                    }
                    Expr2Object.addCoefficient(map, ((INum)res).doubleValue(), 0);
                }
                return map;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void addCoefficient(Map<Integer, Double> map, double v, int k) {
        Integer key = k;
        Double value = map.get(key);
        if (value == null) {
            map.put(k, v);
        } else {
            map.put(k, value + v);
        }
    }
}

