/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class NumberQ
extends AbstractCoreFunctionEvaluator
implements Predicate<IExpr> {
    public static final NumberQ CONST = new NumberQ();

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = F.eval(ast.arg1());
        if (arg1.isDirectedInfinity()) {
            return F.False;
        }
        return F.bool(arg1.isNumber());
    }

    public boolean apply(IExpr expr) {
        return expr.isNumber();
    }
}

