/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.BinaryMap;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Fold
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 4);
        return Fold.evaluateNestList(ast);
    }

    public static IExpr evaluateNestList(IAST ast) {
        try {
            IExpr temp = F.eval(ast.arg3());
            if (temp.isAST()) {
                IAST list = (IAST)temp;
                IExpr arg1 = F.eval(ast.arg1());
                IExpr arg2 = F.eval(ast.arg2());
                return list.args().foldLeft(new BinaryMap(F.ast(arg1)), arg2);
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

