/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.commons.math.linear;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.linear.FieldMatrix;

public class FieldReducedRowEchelonForm<T extends FieldElement<T>> {
    private final FieldMatrix<T> rowReducedMatrix;
    private FieldMatrix<T> nullSpaceCache;
    private int matrixRankCache;
    private final T zero;
    private final T one;
    private final int numRows;
    private final int numCols;

    public FieldReducedRowEchelonForm(FieldMatrix<T> matrix) {
        this.rowReducedMatrix = matrix.copy();
        this.numRows = matrix.getRowDimension();
        this.numCols = matrix.getColumnDimension();
        Field field = matrix.getField();
        this.zero = (FieldElement)field.getZero();
        this.one = (FieldElement)field.getOne();
        this.matrixRankCache = -1;
        this.nullSpaceCache = null;
        this.rowReduce();
    }

    private RowColIndex findPivot(RowColIndex a) {
        int i;
        int first_row = a.row;
        RowColIndex pivot = new RowColIndex(a.row, a.col);
        RowColIndex current = new RowColIndex(a.row, a.col);
        for (i = a.row + 1; i < this.numRows - first_row; ++i) {
            current.row = i;
            if (!this.rowReducedMatrix.getEntry(current.row, current.col).equals(this.one)) continue;
            this.swapRow(current, a);
        }
        i = current.row = a.row;
        while (i < this.numRows - first_row) {
            current.row = i++;
            if (this.rowReducedMatrix.getEntry(current.row, current.col).equals(this.zero)) continue;
            pivot.row = i;
            break;
        }
        return pivot;
    }

    private T getCoordinate(RowColIndex a) {
        return (T)this.rowReducedMatrix.getEntry(a.row, a.col);
    }

    public FieldMatrix<T> getRowReducedMatrix() {
        return this.rowReducedMatrix;
    }

    private void swapRow(RowColIndex a, RowColIndex b) {
        FieldElement[] temp = this.rowReducedMatrix.getRow(a.row);
        this.rowReducedMatrix.setRow(a.row, this.rowReducedMatrix.getRow(b.row));
        this.rowReducedMatrix.setRow(b.row, temp);
        int t = a.row;
        a.row = b.row;
        b.row = t;
    }

    private boolean isColumnZeroFromRow(RowColIndex a) {
        for (int i = a.row; i < this.numRows; ++i) {
            if (this.rowReducedMatrix.getEntry(i, a.col).equals(this.zero)) continue;
            return false;
        }
        return true;
    }

    private boolean isRowZeroes(int row) {
        FieldElement[] temp = this.rowReducedMatrix.getRow(row);
        for (int i = 0; i < this.numCols; ++i) {
            if (temp[i].equals(this.zero)) continue;
            return false;
        }
        return true;
    }

    private void multiplyAdd(RowColIndex to, RowColIndex from, T factor) {
        FieldElement[] row = this.rowReducedMatrix.getRow(to.row);
        FieldElement[] rowMultiplied = this.rowReducedMatrix.getRow(from.row);
        for (int i = 0; i < this.numCols; ++i) {
            this.rowReducedMatrix.setEntry(to.row, i, (FieldElement)row[i].add(rowMultiplied[i].multiply(factor)));
        }
    }

    public FieldMatrix<T> getNullSpace(T minusOneFactor) {
        int rank = this.getMatrixRank();
        int newRowDimension = this.rowReducedMatrix.getColumnDimension() - rank;
        int newColumnDimension = this.rowReducedMatrix.getColumnDimension();
        if (this.nullSpaceCache != null) {
            return this.nullSpaceCache;
        }
        this.nullSpaceCache = this.rowReducedMatrix.createMatrix(newRowDimension, newColumnDimension);
        this.getResultOfNullspace(minusOneFactor, rank);
        return this.nullSpaceCache;
    }

    private void getResultOfNullspace(T minusOneFactor, int rank) {
        int i;
        boolean[] columns = new boolean[this.nullSpaceCache.getColumnDimension()];
        int numberOfFreeColumns = 0;
        for (int i2 = 0; i2 < rank; ++i2) {
            if (columns[i2]) continue;
            for (int k = i2; k < this.rowReducedMatrix.getColumnDimension() && this.rowReducedMatrix.getEntry(i2, k).equals(this.zero); ++k) {
                columns[k] = true;
                int offset = 0;
                for (int j = 0; j < rank; ++j) {
                    if (columns[j]) {
                        ++offset;
                    }
                    this.nullSpaceCache.setEntry(numberOfFreeColumns, j + offset, this.rowReducedMatrix.getEntry(j, i2));
                }
                ++numberOfFreeColumns;
            }
        }
        int start = rank + numberOfFreeColumns;
        int row = numberOfFreeColumns;
        for (i = start; i < this.nullSpaceCache.getColumnDimension(); ++i) {
            int offset = 0;
            for (int j = 0; j < rank; ++j) {
                if (columns[j]) {
                    ++offset;
                }
                this.nullSpaceCache.setEntry(row, j + offset, this.rowReducedMatrix.getEntry(j, i));
            }
            ++row;
        }
        for (i = start; i < this.nullSpaceCache.getColumnDimension(); ++i) {
            columns[i] = true;
        }
        this.nullSpaceCache = this.nullSpaceCache.scalarMultiply(minusOneFactor);
        row = 0;
        for (i = 0; i < columns.length; ++i) {
            if (!columns[i]) continue;
            this.nullSpaceCache.setEntry(row++, i, this.one);
        }
    }

    private FieldMatrix<T> rowReduce() {
        int maxRows = this.numRows;
        RowColIndex pivot = new RowColIndex(0, 0);
        int submatrix = 0;
        for (int x = 0; x < this.numCols; ++x) {
            FieldElement complement;
            pivot = new RowColIndex(pivot.row, x);
            int i = x;
            while (i < this.numCols && this.isColumnZeroFromRow(pivot)) {
                pivot.col = i++;
            }
            if (this.getCoordinate(pivot = this.findPivot(pivot)).equals(this.zero)) {
                ++pivot.row;
                if (pivot.row < maxRows) continue;
                break;
            }
            if (pivot.row != submatrix) {
                this.swapRow(new RowColIndex(submatrix, pivot.col), pivot);
            }
            if (!this.getCoordinate(pivot).equals(this.one)) {
                FieldElement scalar = (FieldElement)this.getCoordinate(pivot).reciprocal();
                this.scaleRow(pivot, scalar);
            }
            for (i = pivot.row; i < this.numRows; ++i) {
                if (i == pivot.row) continue;
                RowColIndex belowPivot = new RowColIndex(i, pivot.col);
                complement = (FieldElement)((FieldElement)this.getCoordinate(belowPivot).negate()).divide(this.getCoordinate(pivot));
                this.multiplyAdd(belowPivot, pivot, complement);
            }
            for (i = pivot.row; i >= 0; --i) {
                if (i == pivot.row) {
                    if (this.getCoordinate(pivot).equals(this.one)) continue;
                    this.scaleRow(pivot, (FieldElement)this.getCoordinate(pivot).reciprocal());
                    continue;
                }
                if (i == pivot.row) continue;
                RowColIndex abovePivot = new RowColIndex(i, pivot.col);
                complement = (FieldElement)((FieldElement)this.getCoordinate(abovePivot).negate()).divide(this.getCoordinate(pivot));
                this.multiplyAdd(abovePivot, pivot, complement);
            }
            if (pivot.row + 1 >= maxRows) break;
            ++submatrix;
            ++pivot.row;
        }
        return this.rowReducedMatrix;
    }

    public int getMatrixRank() {
        if (this.rowReducedMatrix.getRowDimension() == 0 || this.rowReducedMatrix.getColumnDimension() == 0) {
            return 0;
        }
        if (this.matrixRankCache < 0) {
            int rows;
            this.matrixRankCache = 0;
            for (int i = rows = this.rowReducedMatrix.getRowDimension() - 1; i >= 0; --i) {
                if (this.isRowZeroes(i)) continue;
                this.matrixRankCache = i + 1;
                return this.matrixRankCache;
            }
        }
        return this.matrixRankCache;
    }

    private void scaleRow(RowColIndex x, T factor) {
        for (int i = 0; i < this.numCols; ++i) {
            this.rowReducedMatrix.multiplyEntry(x.row, i, factor);
        }
    }

    private static class RowColIndex {
        int row;
        int col;

        RowColIndex(int r, int c) {
            this.row = r;
            this.col = c;
        }

        public String toString() {
            return "(" + this.row + ", " + this.col + ")";
        }
    }
}

