/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.math.frobenius;

import cc.redberry.core.math.frobenius.FrobeniusSolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class FbUtils {
    public static final Comparator<int[]> SOLUTION_COMPARATOR = new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            if (o1.length != o2.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < o1.length; ++i) {
                if (o1[i] > o2[i]) {
                    return 1;
                }
                if (o1[i] >= o2[i]) continue;
                return -1;
            }
            return 0;
        }
    };

    public static List<int[]> getAllSolutions(int[] ... equations) {
        int[] solution;
        ArrayList<int[]> solutions = new ArrayList<int[]>();
        FrobeniusSolver fbSolver = new FrobeniusSolver(equations);
        while ((solution = fbSolver.take()) != null) {
            solutions.add(solution);
        }
        return solutions;
    }

    public static Iterator<int[]> iterator(int[][] equations) {
        return new SolutionsIterator(equations);
    }

    public static Iterable<int[]> iterable(int[][] equations) {
        return new SolutionsIterator(equations);
    }

    private static class SolutionsIterator
    implements Iterator<int[]>,
    Iterable<int[]> {
        private final FrobeniusSolver fbSolver;
        private int[] solution;

        SolutionsIterator(int[][] equations) {
            this.fbSolver = new FrobeniusSolver(equations);
        }

        @Override
        public boolean hasNext() {
            this.solution = this.fbSolver.take();
            return this.solution != null;
        }

        @Override
        public int[] next() {
            return this.solution;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<int[]> iterator() {
            return this;
        }
    }
}

