/*
 * Decompiled with CFR 0.152.
 */
package medusa.stringconnection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import medusa.graph.Graph;
import medusa.stringconnection.AnimPanel;
import medusa.stringconnection.Annotator;
import medusa.stringconnection.CallString;
import medusa.stringconnection.GetCogGraph;
import medusa.stringconnection.GetGraph;

public class DataConnection
extends JDialog
implements ItemListener,
ActionListener {
    String intialSelection = "";
    private static DataConnection dataConnection;
    final int preferredHeight = 20;
    final int preferredWidth = 50;
    final Color stringColor = new Color(161, 173, 236);
    private ArrayList queryList = new ArrayList();
    private boolean cogMode = false;
    private static Graph graph;
    AnimPanel ap;
    private String organism = "All";
    private float cutoff = 0.3f;
    private ButtonGroup buttonGroup1;
    private JButton cancelFinalButton;
    private JButton cancelFirstButton;
    private JCheckBox currentNodesCheckBox;
    private JTabbedPane dataConnectionTabbedPane;
    private JComboBox depthComboBox;
    private JLabel geneLabel;
    private JComboBox organismBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel queryPanel;
    private JPanel dataPanel;
    private JPanel selectPanel;
    private JPanel subDataPanel;
    private JRadioButton exampleNodeRadioButton1;
    private JRadioButton exampleNodeRadioButton2;
    private JRadioButton jRadioButton3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea nodeTextArea;
    private JButton submitFinalButton;
    private JButton submitFirstButton;
    private JPanel acceptPanel;
    private JLabel acceptLabel;
    private JButton colorButton;
    private JButton shapeButton;
    private JButton acceptAndCloseButton;
    private JButton cancelAndCloseButton;
    private JPanel subAcceptPanel;
    private JButton clearTextButton;
    private JCheckBox cogBox;
    private final int port = 4444;
    private final String url = "string.embl.de";
    private ProgressMonitor progressBar;
    private JProgressBar progressBar2;
    private ActionListener updateEnergyBar;
    private Timer timer;
    private Timer timer2;
    private CallString cs;
    private GetGraph gg;
    GetCogGraph gcg;
    private ActionListener callStringActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (DataConnection.this.progressBar.isCanceled() || DataConnection.this.cs.isDone()) {
                DataConnection.this.timer.stop();
                DataConnection.this.cs.stop();
                DataConnection.this.setCursor(null);
                DataConnection.this.selectPanel = DataConnection.this.cs.getPanel();
                DataConnection.this.jScrollPane2.setViewportView(DataConnection.this.selectPanel);
                int dataIndex = DataConnection.this.dataConnectionTabbedPane.indexOfTab("Data");
                DataConnection.this.dataConnectionTabbedPane.setEnabledAt(dataIndex, true);
                DataConnection.this.dataConnectionTabbedPane.setSelectedIndex(dataIndex);
            }
        }
    };
    private ActionListener getGraphActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            DataConnection.this.progressBar2.setString(DataConnection.this.gg.getProgress() + " entries");
            if (DataConnection.this.gg.isDone()) {
                DataConnection.this.timer2.stop();
                DataConnection.this.gg.stop();
                DataConnection.this.progressBar2.setString("creating graph");
                graph = DataConnection.this.gg.getGraph();
                graph.autoFixOrientation();
                DataConnection.this.annotateGraph();
            }
        }
    };
    private ActionListener getCogGraphActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            DataConnection.this.progressBar2.setString(DataConnection.this.gcg.getProgress() + " entries");
            if (DataConnection.this.gcg.isDone()) {
                DataConnection.this.timer2.stop();
                DataConnection.this.gcg.stop();
                graph = DataConnection.this.gcg.getGraph();
                graph.autoFixOrientation();
                DataConnection.this.updateAccept();
                DataConnection.this.progressBar2.setIndeterminate(false);
                DataConnection.this.progressBar2.setString(DataConnection.this.gcg.getProgress() + " entries");
                DataConnection.this.setCursor(null);
                if (DataConnection.this.gcg.getStatus().compareTo("ok") == 0) {
                    int acceptIndex = DataConnection.this.dataConnectionTabbedPane.indexOfTab("Accept");
                    DataConnection.this.dataConnectionTabbedPane.setEnabledAt(acceptIndex, true);
                    DataConnection.this.dataConnectionTabbedPane.setSelectedIndex(acceptIndex);
                } else {
                    DataConnection.this.selectPanel.add(new JLabel("Sorry, no matches could be found."));
                    DataConnection.this.jScrollPane2.setViewportView(DataConnection.this.selectPanel);
                    int dataIndex = DataConnection.this.dataConnectionTabbedPane.indexOfTab("Data");
                    DataConnection.this.dataConnectionTabbedPane.setEnabledAt(dataIndex, true);
                    DataConnection.this.dataConnectionTabbedPane.setSelectedIndex(dataIndex);
                }
            }
        }
    };
    private Annotator ag;
    private ActionListener annotateGraphActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            DataConnection.this.progressBar2.setValue(DataConnection.this.ag.getProgress());
            if (DataConnection.this.ag.isDone()) {
                DataConnection.this.timer2.stop();
                DataConnection.this.ag.stop();
                DataConnection.this.updateAccept();
                DataConnection.this.progressBar2.setIndeterminate(false);
                DataConnection.this.progressBar2.setString(DataConnection.this.gg.getProgress() + " entries");
                DataConnection.this.setCursor(null);
                int acceptIndex = DataConnection.this.dataConnectionTabbedPane.indexOfTab("Accept");
                DataConnection.this.dataConnectionTabbedPane.setEnabledAt(acceptIndex, true);
                DataConnection.this.dataConnectionTabbedPane.setSelectedIndex(acceptIndex);
            }
        }
    };

    public DataConnection(Frame frame, Component locationComp) {
        super(frame, "String", true);
        DataConnection.setDefaultLookAndFeelDecorated(true);
        this.initComponents();
        this.setLocationRelativeTo(locationComp);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButton3 = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.dataConnectionTabbedPane = new JTabbedPane();
        this.queryPanel = new JPanel();
        this.geneLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.nodeTextArea = new JTextArea();
        this.cancelFirstButton = new JButton();
        this.jLabel3 = new JLabel();
        this.organismBox = new JComboBox();
        this.submitFirstButton = new JButton();
        this.currentNodesCheckBox = new JCheckBox();
        this.dataPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.selectPanel = new JPanel();
        this.exampleNodeRadioButton2 = new JRadioButton();
        this.exampleNodeRadioButton1 = new JRadioButton();
        this.subDataPanel = new JPanel();
        this.jLabel4 = new JLabel("label 4");
        this.depthComboBox = new JComboBox();
        this.submitFinalButton = new JButton();
        this.cancelFinalButton = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel2 = new JLabel();
        this.clearTextButton = new JButton("Clear");
        this.cogBox = new JCheckBox("Cog mode");
        this.jRadioButton3.setText("jRadioButton3");
        this.jLabel1.setBackground(new Color(161, 173, 236));
        this.jLabel1.setFont(new Font("Times New Roman", 1, 24));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("STRING Data Connection");
        this.jLabel1.setOpaque(true);
        this.getContentPane().add((Component)this.jLabel1, "North");
        this.dataConnectionTabbedPane.setBackground(new Color(161, 173, 236));
        this.dataConnectionTabbedPane.setOpaque(true);
        this.queryPanel.setLayout(new GridBagLayout());
        this.queryPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.queryPanel.setPreferredSize(new Dimension(300, 200));
        this.geneLabel.setText("Gene name");
        this.geneLabel.setToolTipText("Enter gene names here");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.queryPanel.add((Component)this.geneLabel, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 80));
        this.jScrollPane1.setViewportView(this.nodeTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 176;
        gridBagConstraints.ipady = 56;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.queryPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.cancelFirstButton.setText("Cancel");
        this.cancelFirstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.cancelFirstButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.queryPanel.add((Component)this.cancelFirstButton, gridBagConstraints);
        this.jLabel3.setText("Minimum score cutoff");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(3, 29, 3, 29);
        this.queryPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.buildOrganismBox();
        this.organismBox.setPreferredSize(new Dimension(40, 20));
        this.organismBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DataConnection.this.organismBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.ipadx = 74;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.queryPanel.add((Component)this.organismBox, gridBagConstraints);
        this.submitFirstButton.setText("Submit");
        this.submitFirstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.submitFirstButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.queryPanel.add((Component)this.submitFirstButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.queryPanel.add(this.cogBox);
        this.cogBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DataConnection.this.cogBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.queryPanel.add((Component)this.clearTextButton, gridBagConstraints);
        this.clearTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.clearTextButtonActionPerformed(evt);
            }
        });
        this.dataConnectionTabbedPane.addTab("Query", this.queryPanel);
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.jScrollPane2.setPreferredSize(new Dimension(300, 300));
        this.selectPanel.setLayout(new BoxLayout(this.selectPanel, 1));
        this.selectPanel.setBackground(new Color(255, 255, 255));
        this.jScrollPane2.setViewportView(this.selectPanel);
        this.dataPanel.add((Component)this.jScrollPane2, "Center");
        this.jLabel4.setText("Depth");
        this.progressBar2 = new JProgressBar(0, 500);
        this.progressBar2.setStringPainted(true);
        this.progressBar2.setValue(0);
        this.progressBar2.setString("Getting data");
        this.progressBar2.setIndeterminate(false);
        this.subDataPanel.add(this.progressBar2);
        this.depthComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DataConnection.this.depthComboBoxItemStateChanged(evt);
            }
        });
        this.submitFinalButton.setText("Submit");
        this.submitFinalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.submitDataButtonActionPerformed(evt);
            }
        });
        this.subDataPanel.add(this.submitFinalButton);
        this.cancelFinalButton.setText("Cancel");
        this.cancelFinalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.cancelFinalButtonActionPerformed(evt);
            }
        });
        this.subDataPanel.add(this.cancelFinalButton);
        this.dataPanel.add((Component)this.subDataPanel, "South");
        this.jLabel5.setText("Select genes");
        this.dataPanel.add((Component)this.jLabel5, "North");
        this.dataConnectionTabbedPane.addTab("Data", this.dataPanel);
        int dataIndex = this.dataConnectionTabbedPane.indexOfTab("Data");
        this.dataConnectionTabbedPane.setEnabledAt(dataIndex, false);
        this.getContentPane().add((Component)this.dataConnectionTabbedPane, "Center");
        this.ap = new AnimPanel();
        this.getContentPane().add((Component)this.ap, "West");
        this.acceptPanel = new JPanel();
        this.subAcceptPanel = new JPanel();
        this.acceptLabel = new JLabel();
        this.acceptLabel.setHorizontalAlignment(0);
        this.colorButton = new JButton("Color");
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.colorButtonActionPerformed(evt);
            }
        });
        this.shapeButton = new JButton("Shape");
        this.shapeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.shapeButtonActionPerformed(evt);
            }
        });
        this.acceptAndCloseButton = new JButton("Accept");
        this.acceptAndCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.submitFinalButtonActionPerformed(evt);
            }
        });
        this.cancelAndCloseButton = new JButton("Cancel");
        this.cancelAndCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataConnection.this.cancelFinalButtonActionPerformed(evt);
            }
        });
        this.acceptPanel.setLayout(new BorderLayout());
        this.subAcceptPanel.setLayout(new FlowLayout());
        this.acceptPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.subAcceptPanel.add(this.acceptAndCloseButton);
        this.subAcceptPanel.add(this.cancelAndCloseButton);
        this.subAcceptPanel.add(this.colorButton);
        this.subAcceptPanel.add(this.shapeButton);
        this.acceptPanel.add("Center", this.acceptLabel);
        this.acceptPanel.add("South", this.subAcceptPanel);
        this.dataConnectionTabbedPane.addTab("Accept", this.acceptPanel);
        int acceptIndex = this.dataConnectionTabbedPane.indexOfTab("Accept");
        this.dataConnectionTabbedPane.setEnabledAt(acceptIndex, false);
        this.pack();
    }

    public void exampleNodes() {
        this.nodeTextArea.append("TRPB_SYNY3");
    }

    private void setInitialSelection(String inLine) {
        this.nodeTextArea.append(inLine);
    }

    private void updateAccept() {
        String text = "<html>Data to import:<p><center>nodes: <b>" + graph.getNodeSize() + "</b><p>edges: <b>" + graph.getEdgeSize() + "</b><p></center><p>Accept this?";
        this.acceptLabel.setText(text);
    }

    private void submitFinalButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void colorButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this.getRootPane(), "Choose node color", Color.red);
        if (newColor != null) {
            graph.setNodeColor(newColor);
        }
    }

    private void shapeButtonActionPerformed(ActionEvent evt) {
        Object[] shapes = new Object[]{"circle", "rectangle", "triangle", "diamond"};
        int s = JOptionPane.showOptionDialog(this, "Choose a node shape", "Shape", 1, 3, null, shapes, "circle");
        graph.setNodeShape(s);
    }

    private void submitDataButtonActionPerformed(ActionEvent evt) {
        this.getGraph();
    }

    private void depthComboBoxItemStateChanged(ItemEvent evt) {
    }

    private void organismBoxItemStateChanged(ItemEvent evt) {
        Float temp = (Float)this.organismBox.getSelectedItem();
        this.cutoff = temp.floatValue();
    }

    private void cancelFirstButtonActionPerformed(ActionEvent evt) {
        this.cancelAction();
    }

    private void clearTextButtonActionPerformed(ActionEvent evt) {
        this.nodeTextArea.setText("");
    }

    private void submitFirstButtonActionPerformed(ActionEvent evt) {
        if (!this.cogMode) {
            this.connect();
        }
        if (this.cogMode) {
            this.getCogGraph();
        }
    }

    private void cogBoxItemStateChanged(ItemEvent evt) {
        this.cogMode = this.cogBox.isSelected();
    }

    private void currentNodesCheckBoxItemStateChanged(ItemEvent evt) {
    }

    private void cancelFinalButtonActionPerformed(ActionEvent evt) {
        this.cancelAction();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void cancelAction() {
        this.ap.stop();
        graph = null;
        this.setVisible(false);
    }

    private void buildQuery() {
        this.queryList.clear();
        String[] queries = this.nodeTextArea.getText().split("\\n");
        String suffix = "";
        if (this.organism.compareTo("All") != 0) {
            suffix = "_" + this.organism;
        }
        for (int i = 0; i < queries.length; ++i) {
            this.queryList.add("GN:" + queries[i] + suffix);
        }
    }

    public void testingThreads() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("1076.CAE25513");
        al.add("1148.TRPB_SYNY3");
        al.add("117.TRPB_RHOBA");
        al.add("118099.TRPB_BUCAI");
        this.gg = new GetGraph("string.embl.de", 4444, al, 0.0f);
        this.timer2 = new Timer(200, this.getGraphActionListener);
        this.timer2.start();
        this.gg.start();
    }

    public void connect() {
        String[] queries = this.nodeTextArea.getText().split("\\n");
        this.progressBar = new ProgressMonitor(this, "Sending query", "", 0, queries.length);
        this.cs = new CallString("string.embl.de", 4444, queries);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.timer = new Timer(200, this.callStringActionListener);
        this.cs.start();
        this.timer.start();
    }

    public void getGraph() {
        ArrayList selection = this.buildSelectionList();
        this.gg = new GetGraph("string.embl.de", 4444, selection, this.cutoff);
        this.progressBar2.setIndeterminate(true);
        this.progressBar2.repaint();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.timer2 = new Timer(200, this.getGraphActionListener);
        this.timer2.start();
        this.gg.start();
    }

    private void annotateGraph() {
        this.ag = new Annotator("string.embl.de", 4444, graph);
        this.progressBar2.setIndeterminate(false);
        this.progressBar2.setMaximum(this.ag.getMax());
        this.progressBar2.setString("Annotating");
        this.progressBar2.setValue(0);
        this.progressBar2.repaint();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.timer2 = new Timer(200, this.annotateGraphActionListener);
        this.timer2.start();
        this.ag.start();
    }

    private void getCogGraph() {
        String[] queries = this.nodeTextArea.getText().split("\\n");
        int dataIndex = this.dataConnectionTabbedPane.indexOfTab("Data");
        this.dataConnectionTabbedPane.setEnabledAt(dataIndex, true);
        this.dataConnectionTabbedPane.setSelectedIndex(dataIndex);
        this.gcg = new GetCogGraph("string.embl.de", 4444, queries, this.cutoff);
        this.progressBar2.setIndeterminate(true);
        this.progressBar2.repaint();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.timer2 = new Timer(200, this.getCogGraphActionListener);
        this.timer2.start();
        this.gcg.start();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    public ArrayList buildSelectionList() {
        int n = this.selectPanel.getComponentCount();
        ArrayList<String> selection = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            JRadioButton jr = (JRadioButton)this.selectPanel.getComponent(i);
            if (!jr.isSelected()) continue;
            selection.add(jr.getText());
        }
        return selection;
    }

    private void buildOrganismBox() {
        for (int i = 1; i < 10; ++i) {
            this.organismBox.addItem(new Float((float)i / 10.0f));
        }
        this.organismBox.setSelectedIndex(3);
        this.cutoff = 0.3f;
    }

    public Graph returnGraph() {
        return graph;
    }

    public static Graph showDialog(Component frameComp, Component locationComp) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        dataConnection = new DataConnection(frame, locationComp);
        dataConnection.setSize(450, 300);
        dataConnection.setVisible(true);
        return graph;
    }

    public static Graph showDialog(String initial, Component frameComp, Component locationComp) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        dataConnection = new DataConnection(frame, locationComp);
        dataConnection.setSize(450, 300);
        dataConnection.setInitialSelection(initial);
        dataConnection.setVisible(true);
        return graph;
    }

    static {
        graph = new Graph();
    }
}

