/*
 * Decompiled with CFR 0.152.
 */
package medusa.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import medusa.graph.BasicGraph;
import medusa.graph.Edge;
import medusa.graph.Node;

public class GraphMatrix {
    double[][] distanceMatrix;
    Map<String, Integer> nodeIndexMap;
    Map<Integer, String> indexNodeMap;
    BasicGraph g;

    public double[][] getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public GraphMatrix(BasicGraph g) {
        this.g = g;
        this.createLabelIndex();
        this.createDistanceMatrix();
    }

    private void createLabelIndex() {
        this.nodeIndexMap = new HashMap<String, Integer>();
        Iterator<Node> nodes = this.g.nodesIterator();
        while (nodes.hasNext()) {
            this.nodeIndexMap.put(nodes.next().getLabel(), new Integer(this.nodeIndexMap.size()));
        }
        this.indexNodeMap = new HashMap<Integer, String>();
        for (String label : this.nodeIndexMap.keySet()) {
            this.indexNodeMap.put(this.nodeIndexMap.get(label), label);
        }
    }

    private void createDistanceMatrix() {
        this.distanceMatrix = new double[this.g.getNodeSize()][this.g.getNodeSize()];
        Iterator<Edge> edges = this.g.edgesIterator();
        while (edges.hasNext()) {
            Edge e = edges.next();
            String n1 = e.getFromName();
            String n2 = e.getToName();
            int i1 = this.nodeIndexMap.get(n1);
            int i2 = this.nodeIndexMap.get(n2);
            this.distanceMatrix[i1][i2] = 1.0 - (double)e.getConf();
            this.distanceMatrix[i2][i1] = 1.0 - (double)e.getConf();
        }
    }

    public String getLabelForIndex(int i) {
        return this.indexNodeMap.get(i);
    }

    public double[] getRowForIndex(int i) {
        return this.distanceMatrix[i];
    }
}

