/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.enhanced_mcl;

import java.util.Iterator;
import medusa.georgios.enhanced_mcl.List2Graph;
import medusa.georgios.enhanced_mcl.SparseMatrix;
import medusa.georgios.enhanced_mcl.SparseVector;

public class MarkovClustering {
    public static List2Graph g;
    int clusters = 0;
    String report;

    public String getReport() {
        return this.report;
    }

    public void setReport(String str) {
        this.report = str;
    }

    public SparseMatrix run(SparseMatrix a, double maxResidual, double pGamma, double loopGain, double maxZero) {
        this.addLoops(a, loopGain);
        a.normaliseRows();
        double residual = 1.0;
        int i = 0;
        while (residual > maxResidual) {
            ++i;
            a = this.expand(a);
            residual = this.inflate(a, pGamma, maxZero);
        }
        return a;
    }

    public double inflate(SparseMatrix m, double p, double zeromax) {
        double res = 0.0;
        m.hadamardPower(p);
        m.prune(zeromax);
        SparseVector rowsums = m.normalise(1.0);
        Iterator iterator = rowsums.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            SparseVector row = (SparseVector)m.get(i);
            double max = row.max();
            double sumsq = row.sum(2.0);
            res = Math.max(res, max - sumsq);
        }
        return res;
    }

    public SparseMatrix expand(SparseMatrix m) {
        m = m.times(m);
        return m;
    }

    private void addLoops(SparseMatrix a, double loopGain) {
        if (loopGain <= 0.0) {
            return;
        }
        for (int i = 0; i < a.size(); ++i) {
            a.add(i, i, loopGain);
        }
    }
}

