/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.enhanced_mcl;

import java.util.Arrays;
import medusa.georgios.enhanced_mcl.ExpDouble;

public class DoubleFormat {
    public static double format(double x, int ndigits) {
        int magnitude = ExpDouble.orderOfMagnitude(x);
        double factor = Math.pow(10.0, ndigits - 1 - magnitude);
        double y = (double)Math.round(x * factor) / factor;
        return y;
    }

    static String format(double x, int ndigits, int strlen) {
        String s = null;
        boolean leftalign = false;
        if (strlen < 0) {
            strlen = -strlen;
            leftalign = true;
        }
        if (strlen < 5) {
            throw new IllegalArgumentException("Cannot use yet abs(strlen) < 5");
        }
        int pad = 0;
        ExpDouble d = new ExpDouble(x, ndigits);
        int len = d.strlen();
        pad = strlen - len;
        if (pad >= 0) {
            s = d.toString();
        } else {
            if (d.exponent < 0) {
                int newdigits = d.digits - -pad;
                if (newdigits > 0) {
                    boolean plusone = d.round(newdigits);
                    if (plusone && newdigits > 1) {
                        d.round(newdigits - 1);
                    } else {
                        s = DoubleFormat.exponentialNotation(d, strlen);
                    }
                    s = d.toString();
                } else {
                    s = DoubleFormat.exponentialNotation(d, strlen);
                }
            } else {
                s = DoubleFormat.exponentialNotation(d, strlen);
            }
            pad = strlen - s.length();
        }
        String spc = DoubleFormat.space(pad);
        if (leftalign) {
            return s + spc;
        }
        return spc + s;
    }

    private static String exponentialNotation(ExpDouble d, int strlen) {
        int diff;
        int len = d.strlenexp();
        int minlen = d.minstrlenexp();
        if (minlen > strlen) {
            char[] cc = new char[strlen];
            if (d.exponent >= 0) {
                Arrays.fill(cc, '>');
            } else {
                Arrays.fill(cc, '<');
            }
            String string = new String(cc);
        }
        if ((diff = strlen - len) == -1) {
            d.round(d.digits + diff);
        } else {
            d.round(1);
        }
        String s = d.toExpString();
        return s;
    }

    private static String space(int pad) {
        char[] ch = new char[pad];
        Arrays.fill(ch, ' ');
        String spc = new String(ch);
        return spc;
    }
}

