/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.color_factory;

import medusa.georgios.vecmathpackage.Point3f;
import medusa.georgios.vecmathpackage.Tuple3f;
import medusa.georgios.vecmathpackage.Vector3f;

public final class CubicBezierSegment3f {
    private Point3f[] nodes = new Point3f[4];

    public CubicBezierSegment3f() {
        this.nodes[0] = new Point3f();
        this.nodes[1] = new Point3f();
        this.nodes[2] = new Point3f();
        this.nodes[3] = new Point3f();
    }

    public final void setNode(Tuple3f point, int index) {
        this.nodes[index].set(point);
    }

    public final void setInitialTangent(Tuple3f tangent) {
        Vector3f connect = new Vector3f(tangent);
        connect.scaleAdd(3.0f, this.nodes[0]);
        this.nodes[1].set(connect);
    }

    public final void setFinalTangent(Tuple3f tangent) {
        Vector3f connect = new Vector3f(tangent);
        connect.scaleAdd(-3.0f, this.nodes[3]);
        this.nodes[2].set(connect);
    }

    public final void computeInterpolation(Tuple3f prePoint, Tuple3f postPoint, float tangentScale) {
        Vector3f tangent0 = null;
        Vector3f tangent1 = null;
        Vector3f dummy = new Vector3f();
        if (prePoint != null) {
            tangent0 = new Vector3f(this.nodes[3]);
            tangent0.sub(prePoint);
            tangent0.scale(tangentScale);
        }
        if (postPoint != null) {
            tangent1 = new Vector3f(postPoint);
            tangent1.sub(this.nodes[0]);
            tangent1.scale(tangentScale);
        }
        if (tangent0 != null) {
            this.nodes[1].set(tangent0);
            this.nodes[1].add(this.nodes[0]);
        }
        if (tangent1 != null) {
            this.nodes[2].set(tangent1);
            this.nodes[2].negate();
            this.nodes[2].add(this.nodes[3]);
        }
        if (tangent0 == null || tangent1 == null) {
            if (tangent0 == null && tangent1 == null) {
                Vector3f axis = new Vector3f(this.nodes[3]);
                axis.sub(this.nodes[0]);
                axis.normalize();
                this.nodes[1].set(axis);
                this.nodes[1].scale(0.25f);
                this.nodes[1].add(this.nodes[0]);
                this.nodes[2].set(axis);
                this.nodes[2].scale(0.75f);
                this.nodes[2].add(this.nodes[0]);
            } else {
                if (tangent0 == null) {
                    this.nodes[1].set(this.nodes[2]);
                    this.nodes[1].add(this.nodes[0]);
                    this.nodes[1].scale(0.5f);
                }
                if (tangent1 == null) {
                    this.nodes[2].set(this.nodes[1]);
                    this.nodes[2].add(this.nodes[3]);
                    this.nodes[2].scale(0.5f);
                }
            }
        }
    }

    public final Point3f computePoint(float t) {
        float minusT = 1.0f - t;
        float blend0 = minusT * minusT;
        float blend3 = t * t;
        float blend1 = 3.0f * t * blend0;
        float blend2 = 3.0f * minusT * blend3;
        Point3f point = new Point3f();
        point.x = this.nodes[0].x * (blend0 *= minusT);
        point.x += this.nodes[1].x * blend1;
        point.x += this.nodes[2].x * blend2;
        point.x += this.nodes[3].x * (blend3 *= t);
        point.y = this.nodes[0].y * blend0;
        point.y += this.nodes[1].y * blend1;
        point.y += this.nodes[2].y * blend2;
        point.y += this.nodes[3].y * blend3;
        point.z = this.nodes[0].z * blend0;
        point.z += this.nodes[1].z * blend1;
        point.z += this.nodes[2].z * blend2;
        point.z += this.nodes[3].z * blend3;
        return point;
    }

    public final Vector3f computeTangent(float t) {
        float oneMinusT = 1.0f - t;
        Point3f point0 = new Point3f(this.nodes[0]);
        Point3f point1 = new Point3f(this.nodes[1]);
        Vector3f point2 = new Vector3f(this.nodes[2]);
        point0.scale(oneMinusT);
        point1.scale(oneMinusT);
        point2.scale(oneMinusT);
        point0.x += t * this.nodes[1].x;
        point0.y += t * this.nodes[1].y;
        point0.z += t * this.nodes[1].z;
        point1.x += t * this.nodes[2].x;
        point1.y += t * this.nodes[2].y;
        point1.z += t * this.nodes[2].z;
        point2.x += t * this.nodes[3].x;
        point2.y += t * this.nodes[3].y;
        point2.z += t * this.nodes[3].z;
        point0.scale(oneMinusT);
        point2.scale(t);
        point0.x += t * point1.x;
        point0.y += t * point1.y;
        point0.z += t * point1.z;
        point2.x += oneMinusT * point1.x;
        point2.y += oneMinusT * point1.y;
        point2.z += oneMinusT * point1.z;
        point2.sub(point0);
        return point2;
    }

    public final Point3f computeHalfwayPoint() {
        Point3f point = new Point3f(this.nodes[0]);
        point.scale(0.125f);
        Point3f immediate = new Point3f(this.nodes[1]);
        immediate.scale(0.375f);
        point.add(immediate);
        immediate.set(this.nodes[2]);
        immediate.scale(0.375f);
        point.add(immediate);
        immediate.set(this.nodes[3]);
        immediate.scale(0.125f);
        point.add(immediate);
        return point;
    }
}

