/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.color_factory;

import java.util.ArrayList;
import medusa.georgios.color_factory.AbstractCurve3f;
import medusa.georgios.color_factory.CubicBezierSegment3f;
import medusa.georgios.vecmathpackage.Point3f;
import medusa.georgios.vecmathpackage.Tuple3f;
import medusa.georgios.vecmathpackage.Vector3f;

public final class CubicBezierCurve3f
extends AbstractCurve3f {
    public Tuple3f prePoint = null;
    public Tuple3f postPoint = null;
    public Tuple3f initialTangent = null;
    public Tuple3f finalTangent = null;
    public float tangentScale = 0.33333334f;
    private ArrayList tangents = null;
    private CubicBezierSegment3f cachedSegment = null;
    private int cachedSegmentIndex = -1;

    public void setTangents(ArrayList tangents) {
        this.tangents = tangents;
    }

    @Override
    public final Vector3f computeTangent(float parameter) {
        Vector3f tangent = null;
        parameter = this.updateCachedSegment(parameter);
        tangent = this.cachedSegment != null ? this.cachedSegment.computeTangent(parameter) : new Vector3f(1.0f, 0.0f, 0.0f);
        return tangent;
    }

    @Override
    public final Point3f computePoint(float parameter) {
        Point3f point = null;
        parameter = this.updateCachedSegment(parameter);
        point = this.cachedSegment != null ? this.cachedSegment.computePoint(parameter) : new Point3f();
        return point;
    }

    private final float updateCachedSegment(float parameter) {
        ArrayList coordinates = this.getCoordinates();
        int size = coordinates.size();
        if (size > 1) {
            int index = this.mapCurveParameterToSegmentIndex(parameter);
            parameter = this.mapCurveParameterToSegmentParamter(index, parameter);
            if (this.cachedSegment == null) {
                this.cachedSegment = new CubicBezierSegment3f();
                this.cachedSegmentIndex = -1;
            }
            if (index != this.cachedSegmentIndex) {
                this.cachedSegment.setNode((Tuple3f)coordinates.get(index), 0);
                this.cachedSegment.setNode((Tuple3f)coordinates.get(index + 1), 3);
                Tuple3f prePoint = index > 0 ? (Tuple3f)coordinates.get(index - 1) : this.prePoint;
                Tuple3f postPoint = index + 2 < size ? (Tuple3f)coordinates.get(index + 2) : this.postPoint;
                this.cachedSegment.computeInterpolation(prePoint, postPoint, this.tangentScale);
                if (this.tangents != null) {
                    this.cachedSegment.setInitialTangent((Tuple3f)this.tangents.get(index));
                    this.cachedSegment.setFinalTangent((Tuple3f)this.tangents.get(index + 1));
                } else {
                    if (this.initialTangent != null && index == 0) {
                        this.cachedSegment.setInitialTangent(this.initialTangent);
                    }
                    if (this.finalTangent != null && index == size - 2) {
                        this.cachedSegment.setFinalTangent(this.finalTangent);
                    }
                }
                this.cachedSegmentIndex = index;
            }
        } else {
            this.cachedSegment = null;
        }
        return parameter;
    }
}

