/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.color_factory;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import medusa.georgios.color_factory.CubicBezierCurve3f;
import medusa.georgios.vecmathpackage.Color3f;

public class ColorFactory {
    private CubicBezierCurve3f colorCurve = null;
    private Hashtable indexMap = new Hashtable();

    public ColorFactory() {
        if (this.colorCurve == null) {
            this.colorCurve = new CubicBezierCurve3f();
            ArrayList<Color3f> colors = new ArrayList<Color3f>();
            float max = 0.9f;
            float max2 = 0.9f;
            float min = 0.2f;
            float min2 = 0.2f;
            colors.add(new Color3f(0.3f, 0.3f, 1.0f));
            colors.add(new Color3f(min, max2, max2));
            colors.add(new Color3f(min2, max, min2));
            colors.add(new Color3f(max2, max2, min));
            colors.add(new Color3f(max, min2, min2));
            this.colorCurve.setCoordinates(colors);
        }
    }

    public Color3f computeColor(Object object, float brightnessFactor) {
        Float objectFloat = (Float)this.indexMap.get(object);
        if (objectFloat == null) {
            objectFloat = this.register(object);
        }
        float parameter = objectFloat.floatValue();
        Color3f color = new Color3f();
        color.set(this.colorCurve.computePoint(parameter));
        color.scale(brightnessFactor);
        return color;
    }

    public Float register(Object object) {
        if (!this.indexMap.containsKey(object)) {
            float parameter = 0.0f;
            int numerator = this.indexMap.size();
            if (numerator != 0) {
                int exp = (int)(Math.log(numerator) / Math.log(2.0));
                int denominator = (int)Math.pow(2.0, exp);
                if (numerator != denominator) {
                    ++exp;
                    denominator *= 2;
                }
                numerator -= denominator / 2;
                numerator = 2 * numerator - 1;
                parameter = numerator;
                parameter /= (float)denominator;
            }
            Float value = new Float(parameter);
            this.indexMap.put(object, value);
            return value;
        }
        return (Float)this.indexMap.get(object);
    }

    public Iterator getIndexIterator() {
        return this.indexMap.keySet().iterator();
    }
}

