/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

public class KMeansPoint {
    private String label;
    private double[] coordinates;
    private double x;
    private double y;
    private int clusterNumber;

    public KMeansPoint(String label, double _x, double _y) {
        this.label = label;
        this.coordinates = new double[2];
        this.coordinates[0] = _x;
        this.coordinates[1] = _y;
        this.clusterNumber = 0;
    }

    public KMeansPoint(String label, double[] coordinates) {
        this.label = label;
        this.coordinates = coordinates;
        this.clusterNumber = 0;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    public double getCoordinate(int i) {
        return this.coordinates[i];
    }

    public int size() {
        return this.coordinates.length;
    }

    public void setCoordinates(double[] coordinates) {
        this.coordinates = coordinates;
    }

    public void assignToCluster(int _clusterNumber) {
        this.clusterNumber = _clusterNumber;
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public static double distance(KMeansPoint dp1, KMeansPoint dp2) {
        double result = 0.0;
        for (int i = 0; i < dp1.getCoordinates().length; ++i) {
            result += (dp1.getCoordinate(i) - dp2.getCoordinate(i)) * (dp1.getCoordinate(i) - dp2.getCoordinate(i));
        }
        return Math.sqrt(result);
    }

    public String toString() {
        return this.getLabel() + "\t" + Integer.toString(this.clusterNumber);
    }

    public String toDataString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getCoordinates().length; ++i) {
            sb.append(this.getCoordinate(i));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        KMeansPoint dp1 = new KMeansPoint("weng", -0.3f, -0.4f);
        KMeansPoint dp2 = new KMeansPoint("foo", 0.2f, 0.4f);
        System.out.println(KMeansPoint.distance(dp1, dp2));
        System.out.println(dp1.getX());
        System.out.println(dp2.getY());
        dp1.assignToCluster(7);
        System.out.println(dp1.getClusterNumber());
        dp1.assignToCluster(17);
        System.out.println(dp1.getClusterNumber());
        System.out.println(dp2.getClusterNumber());
        System.out.println(dp1);
    }

    public String getLabel() {
        return this.label;
    }
}

