/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import medusa.georgios.ClusteringAlgorithms.Affinity_Propagation_Cluster;
import medusa.georgios.ClusteringAlgorithms.List2Graph;
import medusa.georgios.ClusteringAlgorithms.My_Matrix;

public class Affinity_Propagation {
    double RAND_MAX = 2.147483647E9;
    private float lamda = 0.5f;
    private int number_iterations = 50;
    public int number_of_exemplars = 0;
    private float infinite = 1.0E9f;
    private Hashtable<String, Integer> GiveNameGetIndex = new Hashtable();
    private Hashtable<Integer, String> GiveIndexGetName = new Hashtable();
    private ArrayList<Integer> IndexesOfExamplars = new ArrayList();
    public ArrayList<String> NamesOfExamplars = new ArrayList();
    public ArrayList<Affinity_Propagation_Cluster> ClusterList = new ArrayList();
    public Hashtable<Integer, Affinity_Propagation_Cluster> GiveNodeIndex_getClusterThatThis_node_belongs_to = new Hashtable();
    public Hashtable<String, Affinity_Propagation_Cluster> GiveNodeName_getClusterThatThis_node_belongs_to = new Hashtable();
    private List2Graph g;

    public int getNumberOfClusters() {
        return this.number_of_exemplars;
    }

    public ArrayList getIndexesOfExamplars() {
        return this.IndexesOfExamplars;
    }

    public ArrayList getNamesOfExamplars() {
        return this.NamesOfExamplars;
    }

    public ArrayList getClusterList() {
        return this.ClusterList;
    }

    public Affinity_Propagation(String filename) {
        StringBuffer input = new StringBuffer();
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(filename);
            BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
            while ((thisLine = myInput.readLine()) != null) {
                input.append(thisLine + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.g = new List2Graph(filename);
        this.g.print_matrix_f();
        this.run_Affinity_Propagation(input);
    }

    public Affinity_Propagation(ArrayList<String> list) {
        StringBuffer input = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            input.append(list.get(i) + "\n");
        }
        this.g = new List2Graph(list);
        this.run_Affinity_Propagation(input);
    }

    public Affinity_Propagation(StringBuffer input) {
        this.run_Affinity_Propagation(input);
    }

    public void run_Affinity_Propagation(StringBuffer input) {
        int i;
        int i2;
        int i3;
        double RAND_MAX = 2.147483647E9;
        String input_string = input.toString();
        String[] str = input_string.split("\n");
        int counter = 0;
        ArrayList<String> unique_nodes = new ArrayList<String>();
        for (int i4 = 0; i4 < str.length; ++i4) {
            String[] str1 = str[i4].split("\t");
            if (!unique_nodes.contains(str1[0])) {
                unique_nodes.add(str1[0]);
                this.GiveNameGetIndex.put(str1[0], counter);
                this.GiveIndexGetName.put(counter, str1[0]);
                ++counter;
            }
            if (unique_nodes.contains(str1[1])) continue;
            unique_nodes.add(str1[1]);
            this.GiveNameGetIndex.put(str1[1], counter);
            this.GiveIndexGetName.put(counter, str1[1]);
            ++counter;
        }
        int number_of_nodes = unique_nodes.size();
        double[][] S = new double[number_of_nodes][number_of_nodes];
        double[][] A = new double[number_of_nodes][number_of_nodes];
        double[][] R = new double[number_of_nodes][number_of_nodes];
        for (i3 = 0; i3 < A.length; ++i3) {
            for (int j = 0; j < A.length; ++j) {
                A[i3][j] = 0.0;
                R[i3][j] = 0.0;
                S[i3][j] = 0.0;
            }
        }
        for (i3 = 0; i3 < str.length; ++i3) {
            String[] str1 = str[i3].split("\t");
            int x = this.GiveNameGetIndex.get(str1[0]);
            int y = this.GiveNameGetIndex.get(str1[1]);
            double d = Double.parseDouble(str1[2]);
            S[y][x] = d;
            S[x][y] = d;
        }
        for (i3 = 0; i3 < S.length; ++i3) {
            for (int j = 0; j < S.length; ++j) {
                S[i3][j] = S[i3][j] + (double)((float)((1.0E-16 * S[i3][j] + (double)1.4E-43f) * (Math.random() / (RAND_MAX + 1.0))));
            }
        }
        My_Matrix Availabilities = new My_Matrix(A);
        My_Matrix Similarities = new My_Matrix(S);
        My_Matrix Responsibilities = new My_Matrix(R);
        for (int iteration = 1; iteration < this.number_iterations; ++iteration) {
            int i5;
            int i6;
            int i7;
            int i8;
            int i9;
            if (iteration % 100 == 0) {
                System.out.println("iteration:" + iteration + "/" + this.number_iterations);
            }
            My_Matrix AS = Similarities.plus(Availabilities);
            My_Matrix ROld = My_Matrix.copyMatrix(Responsibilities);
            double[] max_values = new double[number_of_nodes];
            int[] index_of_max_values = new int[number_of_nodes];
            for (i9 = 0; i9 < number_of_nodes; ++i9) {
                index_of_max_values[i9] = 0;
                max_values[i9] = 0;
            }
            for (i9 = 0; i9 < number_of_nodes; ++i9) {
                double maximum = -1000000.0;
                int position = -1;
                for (int j = 0; j < number_of_nodes; ++j) {
                    if (!(AS.get_element(i9, j) > maximum)) continue;
                    maximum = AS.get_element(i9, j);
                    position = j;
                }
                max_values[i9] = maximum;
                index_of_max_values[i9] = position;
            }
            for (i9 = 0; i9 < number_of_nodes; ++i9) {
                AS.set_element(-1.0f * this.infinite, i9, index_of_max_values[i9]);
            }
            double[] max_values2 = new double[number_of_nodes];
            int[] index_of_max_values2 = new int[number_of_nodes];
            for (i8 = 0; i8 < number_of_nodes; ++i8) {
                index_of_max_values2[i8] = 0;
                max_values2[i8] = 0;
            }
            for (i8 = 0; i8 < number_of_nodes; ++i8) {
                double maximum = -1000000.0;
                int position = -1;
                for (int j = 0; j < number_of_nodes; ++j) {
                    if (!(AS.get_element(i8, j) > maximum)) continue;
                    maximum = AS.get_element(i8, j);
                    position = j;
                }
                max_values2[i8] = maximum;
                index_of_max_values2[i8] = position;
            }
            for (i8 = 0; i8 < number_of_nodes; ++i8) {
                for (int j = 0; j < number_of_nodes; ++j) {
                    double value = Similarities.get_element(i8, j) - max_values[i8];
                    Responsibilities.set_element(value, i8, j);
                }
            }
            for (i8 = 0; i8 < number_of_nodes; ++i8) {
                double val = Similarities.get_element(i8, index_of_max_values[i8]) - max_values2[i8];
                Responsibilities.set_element(val, i8, index_of_max_values[i8]);
            }
            for (i8 = 0; i8 < number_of_nodes; ++i8) {
                for (int j = 0; j < number_of_nodes; ++j) {
                    double val = (double)(1.0f - this.lamda) * Responsibilities.get_element(i8, j) + (double)this.lamda * ROld.get_element(i8, j);
                    Responsibilities.set_element(val, i8, j);
                }
            }
            My_Matrix AOld = My_Matrix.copyMatrix(Availabilities);
            double[][] R_positive_values = new double[number_of_nodes][number_of_nodes];
            for (i7 = 0; i7 < number_of_nodes; ++i7) {
                for (int j = 0; j < number_of_nodes; ++j) {
                    R_positive_values[i7][j] = Responsibilities.get_element(i7, j) >= 0.0 ? Responsibilities.get_element(i7, j) : 0.0;
                }
            }
            for (i7 = 0; i7 < number_of_nodes; ++i7) {
                R_positive_values[i7][i7] = Responsibilities.get_element(i7, i7);
            }
            double[] sum_matrix = new double[number_of_nodes];
            for (i6 = 0; i6 < number_of_nodes; ++i6) {
                double sum = 0.0;
                for (int j = 0; j < number_of_nodes; ++j) {
                    sum += R_positive_values[j][i6];
                }
                sum_matrix[i6] = sum;
            }
            for (i6 = 0; i6 < number_of_nodes; ++i6) {
                for (int j = 0; j < number_of_nodes; ++j) {
                    double value = sum_matrix[i6] - R_positive_values[j][i6];
                    Availabilities.set_element(value, j, i6);
                }
            }
            double[] diag_matrix = new double[number_of_nodes];
            for (i5 = 0; i5 < number_of_nodes; ++i5) {
                diag_matrix[i5] = Availabilities.get_element(i5, i5);
            }
            for (i5 = 0; i5 < number_of_nodes; ++i5) {
                for (int j = 0; j < number_of_nodes; ++j) {
                    if (!(Availabilities.get_element(i5, j) >= 0.0)) continue;
                    Availabilities.set_element(0.0, i5, j);
                }
            }
            for (i5 = 0; i5 < number_of_nodes; ++i5) {
                Availabilities.set_element(diag_matrix[i5], i5, i5);
            }
            for (i5 = 0; i5 < number_of_nodes; ++i5) {
                for (int j = 0; j < number_of_nodes; ++j) {
                    double val = (double)(1.0f - this.lamda) * Availabilities.get_element(i5, j) + (double)this.lamda * AOld.get_element(i5, j);
                    Availabilities.set_element(val, i5, j);
                }
            }
        }
        My_Matrix E = new My_Matrix(number_of_nodes, number_of_nodes);
        for (int i10 = 0; i10 < number_of_nodes; ++i10) {
            for (int j = 0; j < number_of_nodes; ++j) {
                E.set_element(Responsibilities.get_element(i10, j) + Availabilities.get_element(i10, j), i10, j);
            }
        }
        Vector<Integer> pos_diag_idx = new Vector<Integer>();
        for (int i11 = 0; i11 < number_of_nodes; ++i11) {
            if (!(E.get_element(i11, i11) > 0.0)) continue;
            pos_diag_idx.add(i11);
        }
        this.number_of_exemplars = pos_diag_idx.size();
        if (this.number_of_exemplars == 0) {
            this.number_of_exemplars = 1;
            pos_diag_idx.add(0);
        }
        int cluster_counter = 0;
        for (int i12 = 0; i12 < this.number_of_exemplars; ++i12) {
            this.IndexesOfExamplars.add((Integer)pos_diag_idx.get(i12));
            this.NamesOfExamplars.add(this.GiveIndexGetName.get(pos_diag_idx.get(i12)));
            Affinity_Propagation_Cluster cluster2 = new Affinity_Propagation_Cluster();
            cluster2.index_of_the_exemplar_of_this_cluster = (Integer)pos_diag_idx.get(i12);
            cluster2.name_of_the_exemplar_of_this_cluster = this.GiveIndexGetName.get(pos_diag_idx.get(i12));
            this.ClusterList.add(cluster2);
            ++cluster_counter;
        }
        My_Matrix exemplar_cols = new My_Matrix(number_of_nodes, this.number_of_exemplars);
        for (int i13 = 0; i13 < number_of_nodes; ++i13) {
            for (int j = 0; j < this.number_of_exemplars; ++j) {
                exemplar_cols.set_element(Similarities.get_element(i13, (Integer)pos_diag_idx.get(j)), i13, j);
            }
        }
        double[] tmp = new double[number_of_nodes];
        int[] c = new int[number_of_nodes];
        for (i2 = 0; i2 < number_of_nodes; ++i2) {
            double maximum = -1000000.0;
            int position = -1;
            for (int j = 0; j < this.number_of_exemplars; ++j) {
                if (!(exemplar_cols.get_element(i2, j) > maximum)) continue;
                maximum = exemplar_cols.get_element(i2, j);
                position = j;
            }
            tmp[i2] = maximum;
            c[i2] = position;
        }
        for (i2 = 0; i2 < pos_diag_idx.size(); ++i2) {
            c[((Integer)pos_diag_idx.get((int)i2)).intValue()] = i2;
        }
        int[] idx = new int[number_of_nodes];
        for (int i14 = 0; i14 < number_of_nodes; ++i14) {
            idx[i14] = (Integer)pos_diag_idx.get(c[i14]);
        }
        ArrayList<Integer> unique = new ArrayList<Integer>();
        for (int i15 = 0; i15 < number_of_nodes; ++i15) {
            if (unique.contains(idx[i15])) continue;
            unique.add(idx[i15]);
        }
        Hashtable indices = new Hashtable();
        for (i = 0; i < unique.size(); ++i) {
            indices.put(unique.get(i), i);
        }
        for (i = 0; i < number_of_nodes; ++i) {
            int cluster_id;
            this.ClusterList.get((int)cluster_id).cluster_id = cluster_id = ((Integer)indices.get(idx[i])).intValue();
            this.ClusterList.get((int)cluster_id).Indexes_Of_Nodes_In_the_cluster.add(i);
            this.ClusterList.get((int)cluster_id).Names_Of_Nodes_In_the_cluster.add(this.GiveIndexGetName.get(i));
            this.GiveNodeIndex_getClusterThatThis_node_belongs_to.put(i, this.ClusterList.get(cluster_id));
            this.GiveNodeName_getClusterThatThis_node_belongs_to.put(this.GiveIndexGetName.get(i), this.ClusterList.get(cluster_id));
        }
        for (i = 0; i < this.getNumberOfClusters(); ++i) {
            this.ClusterList.get((int)i).number_of_elements = this.ClusterList.get((int)i).Indexes_Of_Nodes_In_the_cluster.size();
        }
    }

    public static void main(String[] args) {
        Affinity_Propagation clustering = new Affinity_Propagation("C:\\Documents and Settings\\Georgios\\Desktop\\test5.txt");
        System.out.println("Number of clusters=" + clustering.getNumberOfClusters());
        clustering.Save_To_File("Affinity_Propagation.txt");
    }

    public String getReport() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.getNumberOfClusters(); ++i) {
            str.append("\n" + this.ClusterList.get(i).showInformation_about_cluster());
        }
        return str.toString();
    }

    public String Save_To_File(String filename) {
        try {
            StringBuffer str = new StringBuffer();
            System.out.println("General Information");
            for (int i = 0; i < this.getNumberOfClusters(); ++i) {
                str.append("\n" + this.ClusterList.get(i).showInformation_about_cluster());
            }
            BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
            outp.append(str.toString());
            outp.close();
            return str.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

