/*
 * Decompiled with CFR 0.152.
 */
package medusa.example;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import medusa.display.EditableGraphPanel;
import medusa.display.PaintTools;
import medusa.example.Animation;
import medusa.graph.Node;

public class AnimatedGraphPanel
extends EditableGraphPanel {
    private Animation animation = new Animation();
    private static final long DEMO_TIME = 10000L;

    public AnimatedGraphPanel() {
        this.animation.initDefault();
    }

    @Override
    public void paintNode(Graphics2D g, Node n) {
        g.setStroke(new BasicStroke(1.0f));
        g.setPaint(n.getColor());
        int x = (int)n.getX() - this.correct;
        int y = (int)n.getY() - this.correct;
        Shape shape = this.animation.getShape();
        if (shape == null) {
            shape = PaintTools.getShape(n.getShape(), x, y, this.nodeSize);
            this.drawShape(shape, y, x, n, g);
        } else {
            AffineTransform at = new AffineTransform();
            at.translate(x, y);
            g.transform(at);
            this.drawShape(shape, y, x, n, g);
            at.setToIdentity();
            g.transform(at);
        }
    }

    private void drawShape(Shape shape, int y, int x, Node n, Graphics2D g) {
        g.fill(shape);
        g.setPaint(Color.black);
        if (n.isFixed()) {
            g.setPaint(Color.yellow);
        }
        g.draw(shape);
        g.setPaint(this.fontColor);
        g.setFont(this.nodeFont);
        if (this.label) {
            if (this.showAnnotation) {
                g.drawString(n.getAnnotation(), x - 2, y - 2);
            } else {
                g.drawString(n.getLabel(), x - 2, y - 2);
            }
        }
    }

    public void animationLoop() {
        long startTime;
        long currentTime = startTime = System.currentTimeMillis();
        while (currentTime - startTime < 10000L) {
            long elapsedTime = System.currentTimeMillis() - currentTime;
            currentTime += elapsedTime;
            this.animation.update(elapsedTime);
        }
    }
}

