/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import medusa.MedusaSettings;
import medusa.MedusaSimplerFrame;
import medusa.graph.Edge;
import medusa.graph.Node;

public class EdgeDialog
extends JDialog
implements ActionListener {
    private static EdgeDialog edgeDialog;
    MedusaSettings ss;
    final Color stringColor = MedusaSimplerFrame.STRINGCOLOR;
    final int preferredHeight = 20;
    final int preferredWidth = 50;
    final Dimension textAreaSize = new Dimension(50, 20);
    private JButton submitButton = new JButton("Submit");
    private JButton cancelButton = new JButton("Cancel");
    private JLabel node1Label = new JLabel("Node 1");
    private JTextArea node1Area = new JTextArea();
    private JLabel node2Label = new JLabel("Node 2");
    private JTextArea node2Area = new JTextArea();
    private JPanel mainPanel = new JPanel();
    private JLabel titleLabel = new JLabel();
    private JLabel sideLabel = new JLabel();
    private JPanel bottomPanel = new JPanel();
    private JLabel interactionLabel = new JLabel("Type");
    private JComboBox interactionCB;
    private JLabel confidenceLabel = new JLabel("Conf");
    private JTextArea confidenceArea = new JTextArea("1.0");
    private JLabel orientationLabel = new JLabel("Ori");
    private JTextArea orientationArea = new JTextArea("0.0");
    private static Edge e;

    private EdgeDialog(Frame frame, Component locationComp) {
        this(frame, locationComp, new MedusaSettings());
    }

    private EdgeDialog(Frame frame, Component locationComp, MedusaSettings ss) {
        super(frame, "", true);
        EdgeDialog.setDefaultLookAndFeelDecorated(true);
        this.ss = ss;
        this.init();
        this.setLocationRelativeTo(locationComp);
    }

    private String[] getInteractions() {
        int i = this.ss.getSize();
        String[] numbers = new String[i];
        for (int j = 0; j < i; ++j) {
            numbers[j] = this.ss.getName(new Integer(j + 1));
        }
        return numbers;
    }

    private void init() {
        this.interactionCB = new JComboBox<String>(this.getInteractions());
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.titleLabel.setBackground(this.stringColor);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("Edit edge");
        this.titleLabel.setOpaque(true);
        content.add((Component)this.titleLabel, "North");
        this.sideLabel.setBackground(this.stringColor);
        this.sideLabel.setIcon(new ImageIcon("logo_still_p.gif"));
        this.sideLabel.setVerticalAlignment(1);
        this.sideLabel.setOpaque(true);
        content.add((Component)this.sideLabel, "West");
        this.submitButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.mainPanel.setLayout(new GridLayout(0, 2, 5, 5));
        this.node1Area.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.node2Area.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.confidenceArea.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.mainPanel.add(this.node1Label);
        this.mainPanel.add(this.node1Area);
        this.mainPanel.add(this.node2Label);
        this.mainPanel.add(this.node2Area);
        this.mainPanel.add(this.interactionLabel);
        this.mainPanel.add(this.interactionCB);
        this.mainPanel.add(this.confidenceLabel);
        this.mainPanel.add(this.confidenceArea);
        this.mainPanel.add(this.orientationLabel);
        this.mainPanel.add(this.orientationArea);
        this.mainPanel.add(this.submitButton);
        this.mainPanel.add(this.cancelButton);
        content.add((Component)this.mainPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object obj = ae.getSource();
        if (obj.equals(this.submitButton)) {
            this.submitButtonActionPerformed();
        }
        if (obj.equals(this.cancelButton)) {
            this.cancelButtonActionPerformed();
        }
    }

    private void setNodes(String n1, String n2) {
        this.node1Area.setText(n1);
        this.node2Area.setText(n2);
    }

    private void setText1(String lbl) {
        this.node1Area.setText(lbl);
        this.node1Area.setEnabled(false);
    }

    private void setText2(String lbl) {
        this.node2Area.setText(lbl);
        this.node2Area.setEnabled(false);
    }

    public static Edge showDialog(Component frameComp, Component locationComp, Node node1, Node node2, MedusaSettings ss) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        edgeDialog = new EdgeDialog(frame, locationComp, ss);
        if (node1.getLabel().compareTo("unnamed") != 0) {
            edgeDialog.setText1(node1.getLabel());
        }
        if (node2.getLabel().compareTo("unnamed") != 0) {
            edgeDialog.setText2(node2.getLabel());
        }
        edgeDialog.pack();
        edgeDialog.setVisible(true);
        return e;
    }

    public static Edge showDialog(Component frameComp, Component locationComp, Node node1, Node node2) {
        return EdgeDialog.showDialog(frameComp, locationComp, node1, node2, new MedusaSettings());
    }

    public static String showDialog(Component frameComp, Component locationComp) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        edgeDialog = new EdgeDialog(frame, locationComp);
        edgeDialog.pack();
        edgeDialog.setVisible(true);
        return "ok";
    }

    private void cancelButtonActionPerformed() {
        e = null;
        this.setVisible(false);
    }

    private void submitButtonActionPerformed() {
        e = this.getEdge();
        this.setVisible(false);
    }

    private float getConf() {
        float conf = 1.0f;
        try {
            conf = Float.parseFloat(this.confidenceArea.getText());
        }
        catch (NumberFormatException ne) {
            conf = 1.0f;
        }
        return conf;
    }

    private double getOrientation() {
        double orientation = 0.0;
        try {
            orientation = Double.parseDouble(this.orientationArea.getText());
        }
        catch (NumberFormatException ne) {
            orientation = 0.0;
        }
        return orientation;
    }

    private Edge getEdge() {
        String n1 = this.node1Area.getText();
        String n2 = this.node2Area.getText();
        int type = this.interactionCB.getSelectedIndex() + 1;
        return new Edge(n1, n2, this.getConf(), type, this.getOrientation());
    }

    static {
        e = null;
    }
}

