/*
 * Decompiled with CFR 0.152.
 */
package medusa.dataio;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import medusa.DataFormatException;
import medusa.MedusaSettings;
import medusa.display.PaintTools;
import medusa.graph.BasicGraph;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.Node;

public class DataLoader
implements Runnable {
    private int width;
    private int height;
    private String fileName;
    private int nodeSize = 10;
    public static final int LOAD_MEDUSA = 0;
    public static final int LOAD_TABBED = 1;
    private int loadType;
    Thread me = null;
    private Graph g;
    private boolean done;
    private boolean success;
    private String status = "idle";
    private int progress;
    private boolean busy = false;
    private String separator = "[\\t\\s]+";
    Pattern structurePattern = Pattern.compile("\\*nodes");
    Pattern startPattern = Pattern.compile("\\*edges");
    Pattern basicEdgePattern = Pattern.compile("^([^\\t]+)\\t([^\\t]+)");
    Pattern confEdgePattern = Pattern.compile("\\tc +([\\.\\d]+)");
    Pattern orientationEdgePattern = Pattern.compile("\\to +([\\-\\.\\d]+)");
    Pattern visibleEdgePattern = Pattern.compile("\\tf +(\\w+)");
    Pattern interactionEdgePattern = Pattern.compile("\\ti +(\\d+)");
    Pattern basicNodePattern = Pattern.compile("^([^\\t]+)");
    Pattern xyNodePattern = Pattern.compile("\\t([\\.\\d]+)\\t([\\.\\d]+)");
    Pattern colorNodePattern = Pattern.compile("\\tc *\\D*(\\d+)\\D*(\\d+)\\D*(\\d+)\\D*");
    Pattern color2NodePattern = Pattern.compile("\\tc2 *\\D*(\\d+)\\D*(\\d+)\\D*(\\d+)\\D*");
    Pattern color3NodePattern = Pattern.compile("\\tc3 *\\D*(\\d+)\\D*(\\d+)\\D*(\\d+)\\D*");
    Pattern color4NodePattern = Pattern.compile("\\tc4 *\\D*(\\d+)\\D*(\\d+)\\D*(\\d+)\\D*");
    Pattern fixedNodePattern = Pattern.compile("\\tf +(\\w+)");
    Pattern shapeNodePattern = Pattern.compile("\\ts +(\\d)");
    Pattern dataspace1Pattern = Pattern.compile("\\td1 +(\\d+)");
    Pattern annotationPattern = Pattern.compile("\\ta \\\"(.+)\\\"");
    Pattern URLPattern = Pattern.compile("\\turl \\\"(.+)\\\"");
    Pattern ClusterPattern = Pattern.compile("\\tcluster \\\"(.+)\\\"");
    Pattern edgeParaPattern = Pattern.compile("\\s*(\\w[^:^\\s]+):([^:]+):(\\d+):([\\d\\.]+):([\\-\\d\\.]+)");
    Pattern testEdgeParaPattern = Pattern.compile("\\s*(\\w[^:]+):");
    Pattern nodeParaPattern = Pattern.compile("\\s*(\\w[^:]+):([\\d\\.]+):([\\d\\.]+):(\\d+),(\\d+),(\\d+):(\\d)");
    String currentFileName = null;
    final double normalSize = 600.0;
    double max;
    private int fontSize = 10;
    final int docWidth = 500;
    final int docHeight = 500;

    public void setLoadType(int loadType) {
        this.loadType = loadType;
    }

    public DataLoader(int x, int y) {
        this.width = x;
        this.height = y;
    }

    public DataLoader(int x, int y, String fileName) {
        this.width = x;
        this.height = y;
        this.fileName = fileName;
    }

    public DataLoader() {
        this.width = 600;
        this.height = 600;
    }

    public void start() {
        if (this.me == null) {
            this.me = new Thread(this);
        }
        this.me.start();
    }

    public void stop() {
        if (this.me != null) {
            this.me = null;
        }
    }

    public Graph getGraph() {
        return this.g;
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        if (this.me == myThread) {
            this.g = new Graph();
            this.busy = true;
            this.done = false;
            try {
                switch (this.loadType) {
                    case 0: {
                        this.g = this.load(this.fileName);
                        break;
                    }
                    case 1: {
                        this.g = this.loadSimplest(this.fileName);
                    }
                }
                this.success = true;
            }
            catch (IOException ie) {
                this.success = false;
            }
            catch (DataFormatException ie) {
                this.success = false;
            }
            this.busy = false;
        }
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getStatus() {
        return this.status;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void save(BasicGraph graph, String fileName) throws IOException {
        File saveFile = new File(fileName);
        FileWriter out = new FileWriter(saveFile);
        out.write(graph.report());
        out.close();
    }

    public void save(Graph graph, String fileName, double scale) throws IOException {
        double scaler = scale * 600.0;
        graph.rescaleNodes(1.0 / scaler);
        File saveFile = new File(fileName);
        FileWriter out = new FileWriter(saveFile);
        out.write(graph.report());
        graph.rescaleNodes(scaler);
        out.close();
    }

    public Graph load(String fileName) throws IOException, DataFormatException {
        Matcher matcher;
        String inLine;
        this.busy = true;
        this.max = 600.0;
        this.progress = 0;
        this.currentFileName = fileName;
        Graph graph = new Graph();
        String comment = "";
        File loadFile = new File(fileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(loadFile)));
        while ((inLine = in.readLine()) != null && !(matcher = this.startPattern.matcher(inLine)).find()) {
            comment = comment + inLine;
            comment = comment + "\n";
            graph.addComment(comment);
        }
        this.status = "Reading edges";
        while ((inLine = in.readLine()) != null) {
            matcher = this.structurePattern.matcher(inLine);
            if (matcher.find()) {
                this.status = "Reading nodes";
                break;
            }
            Edge temp = this.readEdge(inLine);
            if (temp == null) continue;
            graph.addEdge(temp);
            ++this.progress;
        }
        this.status = "Reading nodes";
        while ((inLine = in.readLine()) != null) {
            this.readNode(graph, inLine);
        }
        in.close();
        this.busy = false;
        this.status = "idle";
        return graph;
    }

    public Graph loadSimplest(String fileName) throws IOException, DataFormatException {
        String inLine;
        Graph graph = new Graph();
        this.progress = 0;
        File loadFile = new File(fileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(loadFile)));
        while ((inLine = in.readLine()) != null) {
            String[] result = inLine.split("\t");
            if (result.length > 2) {
                graph.addEdge(new Node(result[0]), new Node(result[1]), Float.parseFloat(result[2]), 1);
                ++this.progress;
                continue;
            }
            throw new DataFormatException("File does not have three columns");
        }
        in.close();
        graph.rescaleNodePercentage();
        if (graph.getEdgeSize() == 0) {
            throw new DataFormatException("No edges found");
        }
        return graph;
    }

    private void readNode(Graph g, String inLine) {
        String pattern;
        int i;
        Matcher matcher = this.basicNodePattern.matcher(inLine);
        if (!matcher.find()) {
            return;
        }
        Node n = g.getNode(matcher.group(1));
        if (n == null) {
            return;
        }
        matcher = this.xyNodePattern.matcher(inLine);
        if (matcher.find()) {
            double nodeX = Double.parseDouble(matcher.group(1));
            double nodeY = Double.parseDouble(matcher.group(2));
            if (nodeX <= 1.0) {
                nodeX *= (double)this.width;
            }
            if (nodeY <= 1.0) {
                nodeY *= (double)this.height;
            }
            n.setXY(nodeX, nodeY);
        }
        if ((matcher = this.colorNodePattern.matcher(inLine)).find()) {
            Color color = new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            n.setColor(color);
        }
        if ((matcher = this.color2NodePattern.matcher(inLine)).find()) {
            Color color = new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            n.setColor2(color);
        }
        if ((matcher = this.color3NodePattern.matcher(inLine)).find()) {
            Color color = new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            n.setColor3(color);
        }
        if ((matcher = this.color4NodePattern.matcher(inLine)).find()) {
            Color color = new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            n.setClusteringColor(color);
        }
        if ((matcher = this.shapeNodePattern.matcher(inLine)).find()) {
            int shape = Integer.parseInt(matcher.group(1));
            n.setShape(shape);
        }
        if ((matcher = this.dataspace1Pattern.matcher(inLine)).find()) {
            int ds1 = Integer.parseInt(matcher.group(1));
            n.setDataSpace1(ds1);
        }
        if ((matcher = this.annotationPattern.matcher(inLine)).find()) {
            String[] str = inLine.split("\t");
            for (i = 0; i < str.length; ++i) {
                String string = str[i];
                pattern = "a \"";
                if (!string.startsWith(pattern)) continue;
                n.setAnnotation(string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")));
            }
        }
        if ((matcher = this.URLPattern.matcher(inLine)).find()) {
            String[] str = inLine.split("\t");
            for (i = 0; i < str.length; ++i) {
                String string = str[i];
                pattern = "url \"";
                if (!string.startsWith(pattern)) continue;
                n.setURL(string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")));
            }
        }
        if ((matcher = this.ClusterPattern.matcher(inLine)).find()) {
            String[] str = inLine.split("\t");
            for (i = 0; i < str.length; ++i) {
                String string = str[i];
                pattern = "cluster \"";
                if (!string.startsWith(pattern)) continue;
                n.setCluster(string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")));
            }
        }
        if ((matcher = this.fixedNodePattern.matcher(inLine)).find()) {
            n.setFixed(Boolean.getBoolean(matcher.group(1)));
        }
    }

    private Edge readEdge(String inLine) throws DataFormatException {
        Matcher matcher = this.basicEdgePattern.matcher(inLine);
        if (!matcher.find()) {
            throw new DataFormatException("Error in data file at line:\n " + inLine + ".\nEdge must contain basic node data.If you are using an old data file version,consider using the conversion utility\nOffending line: \n" + inLine);
        }
        Edge e = new Edge(matcher.group(1), matcher.group(2));
        matcher = this.confEdgePattern.matcher(inLine);
        if (matcher.find()) {
            float conf = Float.parseFloat(matcher.group(1));
            if (conf < 0.0f | conf > 1.0f) {
                throw new DataFormatException("Confidence may not be less than zero or greater than one.\n" + matcher.group(1) + " in line: \n" + inLine);
            }
            e.setConf(conf);
        }
        if ((matcher = this.orientationEdgePattern.matcher(inLine)).find()) {
            double d = Double.parseDouble(matcher.group(1));
            e.setOrientation(d);
        }
        if ((matcher = this.interactionEdgePattern.matcher(inLine)).find()) {
            e.setType(Integer.parseInt(matcher.group(1)));
        }
        return e;
    }

    public Graph readParameters(String edges, String nodes) {
        Graph g = new Graph();
        String[] edgeResult = edges.split(";\\n?");
        int lines = edgeResult.length;
        System.out.println("checking " + edgeResult.length + " edges");
        for (int i = 0; i < lines; ++i) {
            Edge temp = this.readEdgeParameter(edgeResult[i]);
            if (temp == null) continue;
            g.addEdge(temp);
        }
        System.out.println("checking nodes");
        if (nodes != null) {
            String[] nodeResult = nodes.split(";\\n?");
            lines = nodeResult.length;
            for (int i = 0; i < lines; ++i) {
                try {
                    this.readNodeParameter(g, nodeResult[i]);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Error in line " + nodeResult[i]);
                    System.out.println(ex.getMessage());
                }
            }
        }
        System.out.println("All done");
        return g;
    }

    public void convertToRealDistances(Graph g) {
        Iterator<Node> nodes = g.nodesIterator();
        while (nodes.hasNext()) {
            Node n = nodes.next();
            n.setXY(n.getX() * (double)this.width, n.getY() * (double)this.height);
        }
    }

    public void normalizePositions(Graph g) {
        Iterator<Node> nodes = g.nodesIterator();
        while (nodes.hasNext()) {
            Node n = nodes.next();
            n.setXY(n.getX() / (double)this.width, n.getY() / (double)this.height);
        }
    }

    private String chomp(String text) {
        text = text.replaceAll("\\s", "");
        return text;
    }

    private Edge readEdgeParameter(String[] result) {
        Edge e = new Edge(result[0], result[1], Float.parseFloat(result[3]), Integer.parseInt(result[2]), Double.parseDouble(result[4]));
        return e;
    }

    private Edge readEdgeParameter(String edgeLine) {
        String[] result = (edgeLine = this.chomp(edgeLine)).split(":");
        if (result.length < 4) {
            return null;
        }
        Edge e = new Edge(result[0], result[1], Float.parseFloat(result[3]), Integer.parseInt(result[2]), Double.parseDouble(result[4]));
        return e;
    }

    private void readNodeParameter(Graph g, String nodeLine) throws Exception {
        String[] result = (nodeLine = this.chomp(nodeLine)).split(":");
        if (result.length > 4) {
            Node n = g.getNode(result[0]);
            double nodeX = Double.parseDouble(result[1]);
            double nodeY = Double.parseDouble(result[2]);
            String[] colorComponents = result[3].split(",");
            Color color = new Color(Integer.parseInt(colorComponents[0]), Integer.parseInt(colorComponents[1]), Integer.parseInt(colorComponents[2]));
            n.setXY(nodeX, nodeY);
            n.setColor(color);
            int shape = Integer.parseInt(result[4]);
            n.setShape(shape);
            if (result.length >= 6) {
                n.setAnnotation(result[5]);
            }
            if (result.length >= 6) {
                for (int i = 6; i < result.length; ++i) {
                    if (result[i].toLowerCase().contains("'cluster")) {
                        String[] str = result[i].split("cluster");
                        n.setCluster(str[1].substring(0, str[1].length() - 1));
                    }
                    if (!result[i].toLowerCase().contains("'http")) continue;
                    n.setURL("http:" + result[i + 1].substring(0, result[i + 1].length() - 1));
                }
            }
        }
    }

    public void saveAsPS(Graph g, String saveFileName, MedusaSettings ss) throws IOException {
        this.saveAsPS(g, saveFileName, ss, this.nodeSize, this.fontSize);
    }

    public void saveAsPS(Graph g, String saveFileName, MedusaSettings ss, int nodeSize, int fontSize) throws IOException {
        this.nodeSize = nodeSize;
        this.fontSize = fontSize;
        File saveFile = new File(saveFileName);
        FileWriter out = new FileWriter(saveFile);
        out.write("%!PS\n");
        this.drawGraph(g, out, ss);
        out.write("showpage\n");
        out.close();
    }

    public void saveAsEPS(Graph g, String saveFileName, MedusaSettings ss, int nodeSize, int fontSize) throws IOException {
        this.nodeSize = nodeSize;
        this.fontSize = fontSize;
        File saveFile = new File(saveFileName);
        FileWriter out = new FileWriter(saveFile);
        out.write("%!PS-Adobe EPSF-3.0\n");
        out.write("%%Creator: Medusa\n");
        out.write("%%BoundingBox: 0 0 500 500\n");
        this.drawGraph(g, out, ss);
        out.close();
    }

    private void drawGraph(Graph g, FileWriter out, MedusaSettings ss) throws IOException {
        out.write("50 50 translate\n");
        out.write("0.2 setlinewidth\n");
        out.write("0 0 0 setrgbcolor\n");
        this.drawEdges(out, g, ss);
        this.drawNodes(out, g);
        this.drawLabels(out, g);
    }

    private int psY(double y) {
        return (int)((600.0 - y) / 600.0 * 500.0);
    }

    private int psX(double x) {
        return (int)(x / 600.0 * 500.0);
    }

    private void drawEdges(FileWriter out, Graph g, MedusaSettings ss) throws IOException {
        String[] nodes = new String[2];
        out.write("%% drawing edges\n");
        Iterator<Edge> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            nodes = e.getNodes();
            Node n1 = g.getNode(nodes[0]);
            int x1 = this.psX(n1.getX());
            int y1 = this.psY(n1.getY());
            Node n2 = g.getNode(nodes[1]);
            int x2 = this.psX(n2.getX());
            int y2 = this.psY(n2.getY());
            Integer colorType = new Integer(e.getType());
            Color color = ss.getColor(colorType);
            float alpha = e.getConf();
            out.write(this.colorToString(color));
            out.write(alpha + " setalpha\n");
            if (e.getOrientation() != 0.0) {
                int[] cPoints = PaintTools.intControlPoints(x1, y1, x2, y2, e.getOrientation(), 0.3);
                out.write(x1 + " " + y1 + " moveto\n");
                out.write(cPoints[0] + " " + cPoints[1] + " " + cPoints[2] + " " + cPoints[3] + " " + x2 + " " + y2 + " curveto stroke\n");
                continue;
            }
            out.write(x1 + " " + y1 + " moveto\n");
            out.write(x2 + " " + y2 + " lineto stroke\n");
        }
        out.write("1.0 setalpha\n");
    }

    private String colorToString(Color color) {
        double red = (double)color.getRed() / 255.0;
        double green = (double)color.getGreen() / 255.0;
        double blue = (double)color.getBlue() / 255.0;
        return red + " " + green + " " + blue + " setrgbcolor\n";
    }

    private void drawLabels(FileWriter out, Graph g) throws IOException {
        int labelCorrect = 5;
        out.write("%% drawing labels\n");
        out.write("0 0 0 setrgbcolor\n");
        Iterator<Node> i = g.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            int x1 = this.psX(n.getX());
            int y1 = this.psY(n.getY());
            out.write("/Times-Roman findfont\n" + this.fontSize + " scalefont\nsetfont\nnewpath\n");
            out.write(x1 - labelCorrect + " " + (y1 + labelCorrect) + " moveto\n");
            out.write("(" + n.getLabel() + ") show\n");
        }
    }

    private void drawNodes(FileWriter out, Graph g) throws IOException {
        out.write("%% drawing nodes\n");
        Iterator<Node> i = g.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            this.drawNodeShape(out, n);
        }
    }

    private void drawNodeShape(FileWriter out, Node n) throws IOException {
        int x1 = this.psX(n.getX());
        int y1 = this.psY(n.getY());
        Color color = n.getColor();
        int shape = n.getShape();
        out.write(this.colorToString(color));
        switch (shape) {
            case 1: {
                out.write(PaintTools.psRectangle(x1, y1, this.nodeSize));
                break;
            }
            case 2: {
                out.write(PaintTools.psTriangle(x1, y1, this.nodeSize));
                break;
            }
            case 3: {
                out.write(PaintTools.psRhomb(x1, y1, this.nodeSize));
                break;
            }
            default: {
                out.write(PaintTools.psCircle(x1, y1, this.nodeSize));
            }
        }
    }

    public void saveAsPajek(Graph g, String saveFileName) throws IOException {
        File saveFile = new File(saveFileName);
        FileWriter out = new FileWriter(saveFile);
        int nnodes = g.getNodeSize();
        out.write("*Vertices\t" + nnodes + "\n");
        int count = 1;
        String cr = "\r\n";
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        Iterator<Node> i = g.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            out.write(count + "\t\"" + n.getLabel() + "\"\t" + n.getX() + "\t" + n.getY() + cr);
            hm.put(n.getLabel(), new Integer(count));
            ++count;
        }
        String[] nodes = new String[2];
        out.write("*Edges\n");
        Iterator<Edge> i2 = g.edgesIterator();
        while (i2.hasNext()) {
            Edge e = i2.next();
            nodes = e.getNodes();
            Integer n1 = (Integer)hm.get(nodes[0]);
            Integer n2 = (Integer)hm.get(nodes[1]);
            out.write(n1 + "\t" + n2 + "\t" + e.getType() + cr);
        }
        out.close();
    }

    public void saveAsArena3D(Graph g, String saveFileName) throws IOException {
        File saveFile = new File(saveFileName);
        FileWriter out = new FileWriter(saveFile);
        int nnodes = g.getNodeSize();
        ArrayList<Color> layers = new ArrayList<Color>();
        Iterator<Node> i = g.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            if (layers.contains(n.getColor())) continue;
            layers.add(n.getColor());
        }
        if (layers.size() <= 1) {
            layers.add(Color.gray);
        }
        out.write("number_of_layers::" + layers.size() + "\r\n");
        HashMap<String, String> cl = new HashMap<String, String>();
        for (int k = 0; k < layers.size(); ++k) {
            out.write("layer::number_" + (k + 1) + "\r\n");
            Iterator<Node> i2 = g.nodesIterator();
            while (i2.hasNext()) {
                Node n = i2.next();
                if (!((Color)layers.get(k)).equals(n.getColor())) continue;
                cl.put(n.getLabel(), "number_" + (k + 1));
                out.write(n.getLabel() + "\t");
                out.write("DESCTIPTION::" + n.getAnnotation() + "\t");
                if (n.getURL() != null && n.getURL().contains("http")) {
                    out.write("URL::" + n.getURL() + "\t");
                }
                out.write("\r\n");
            }
            out.write("end_of_layer_inputs\r\n");
        }
        boolean count = true;
        String cr = "\r\n";
        ArrayList<String> connections = new ArrayList<String>();
        out.write("start_connections\r\n");
        Iterator<Edge> i3 = g.edgesIterator();
        while (i3.hasNext()) {
            Edge e = i3.next();
            if (connections.contains(e.getFromName() + "\t" + e.getToName())) continue;
            out.write(e.getFromName() + "::" + (String)cl.get(e.getFromName()) + "\t" + e.getToName() + "::" + (String)cl.get(e.getToName()) + "\t" + e.getConf() + "\r\n");
            connections.add(e.getFromName() + "\t" + e.getToName());
        }
        out.write("end_connections\r\n");
        out.close();
    }

    public void saveAsBiolayout(Graph g, String saveFileName) throws IOException {
        File saveFile = new File(saveFileName);
        FileWriter out = new FileWriter(saveFile);
        Iterator<Edge> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            out.write(e.getFromName() + "\t" + e.getToName() + "\t" + e.getConf() + "\t\"" + e.getType() + "\"\r\n");
        }
        out.close();
    }

    public void saveAsCytoscape(Graph g, String saveFileName) throws IOException {
        File saveFile = new File(saveFileName);
        FileWriter out = new FileWriter(saveFile);
        Iterator<Edge> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            out.write(e.getFromName() + "\t" + e.getType() + "\t" + e.getToName() + "\r\n");
        }
        out.close();
    }

    public void saveAsGraphViz(Graph g, String saveFileName) throws IOException {
        File saveFile = new File(saveFileName);
        FileWriter out = new FileWriter(saveFile);
        out.write("digraph G {\r\n");
        Iterator<Edge> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            out.write(e.getFromName() + " -> " + e.getToName() + ";\r\n");
        }
        out.write("}\r\n");
        out.close();
    }

    public void saveHTMLParameters(Graph g, String fileName) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<!-- edge parameters generated by Medusa -->\n");
        sb.append("<param name=\"edges\" value=\"\n");
        Iterator<Serializable> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            sb.append(e.getFromName());
            sb.append(":");
            sb.append(e.getToName());
            sb.append(":");
            sb.append(e.getType());
            sb.append(":");
            sb.append(e.getConf());
            sb.append(":");
            sb.append(e.getOrientation());
            sb.append(";\n");
        }
        sb.append("\"/>\n");
        sb.append("<!-- node parameters generated by Medusa -->\n");
        sb.append("<param name=\"nodes\" value=\"\n");
        i = g.nodesIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            sb.append(n.getLabel());
            sb.append(":");
            sb.append(n.getX());
            sb.append(":");
            sb.append(n.getY());
            sb.append(":");
            sb.append(n.getAppletColorEntry());
            sb.append(":");
            sb.append(n.getShape());
            sb.append(":");
            sb.append(n.getAnnotation());
            sb.append(";\n");
        }
        sb.append("\"/>\n");
        FileWriter out = new FileWriter(fileName);
        out.write(sb.toString());
        out.close();
    }
}

