/*
 * Decompiled with CFR 0.152.
 */
package medusa.batchoperations;

import java.io.File;
import java.io.IOException;
import medusa.DataFormatException;
import medusa.dataio.DataLoader;
import medusa.display.EditableGraphPanel;
import medusa.display.FRspring;
import medusa.graph.Graph;

public class BatchOperations {
    DataLoader dl = new DataLoader(1, 1);

    public void convertTabbedToMedusa(String dir) {
        dir = this.clean(dir);
        File f = new File(dir + File.separator);
        String[] children = f.list();
        for (int i = 0; i < children.length; ++i) {
            try {
                System.out.println(dir + File.separator + children[i]);
                Graph g = this.dl.loadSimplest(children[i]);
                System.out.println("saving " + dir + File.separator + children[i] + ".dat");
                this.dl.save(g, dir + File.separator + children[i] + ".dat");
                continue;
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
                continue;
            }
            catch (DataFormatException ex) {
                System.out.println(ex.getMessage());
            }
        }
        System.out.println("Converted as many files as possible in dir " + dir);
    }

    public void batchNormalize(String dir) {
    }

    public void layoutAll(String dir) {
        dir = this.clean(dir);
        File f = new File(dir);
        String[] children = f.list();
        int dim = 600;
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].endsWith(".dat")) continue;
            try {
                System.out.println("loading: " + children[i]);
                Graph g = this.dl.load(dir + File.separator + children[i]);
                FRspring frSpring = new FRspring(g, dim, dim);
                frSpring.iterateAll();
                g.divideNodePosition(dim);
                System.out.println("saving " + dir + File.separator + children[i]);
                this.dl.save(g, dir + File.separator + children[i]);
                continue;
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
                continue;
            }
            catch (DataFormatException ex) {
                System.out.println(ex.getMessage());
                continue;
            }
            catch (ArithmeticException ex) {
                System.out.println(ex.getMessage());
            }
        }
        System.out.println("Converted as many files as possible in dir " + dir);
    }

    public void exportAllToPNG(String dir) {
        dir = this.clean(dir);
        File f = new File(dir);
        String[] children = f.list();
        EditableGraphPanel dp = new EditableGraphPanel();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].endsWith(".dat")) continue;
            try {
                System.out.println("loading: " + children[i]);
                Graph g = this.dl.load(dir + File.separator + children[i]);
                dp.setGraph(g);
                System.out.println("saving " + dir + File.separator + children[i]);
                dp.saveImage(dir + File.separator + children[i] + ".png", 1);
                continue;
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
                continue;
            }
            catch (DataFormatException ex) {
                System.out.println(ex.getMessage());
                continue;
            }
            catch (ArithmeticException ex) {
                System.out.println(ex.getMessage());
            }
        }
        System.out.println("Converted as many files as possible in dir " + dir);
    }

    private String clean(String dir) {
        if (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
            System.out.println(dir);
        }
        return dir;
    }

    public static void main(String[] args) {
        BatchOperations b = new BatchOperations();
        System.out.println("Converting");
        b.convertTabbedToMedusa(args[0]);
        System.out.println("Laying out ");
        b.layoutAll(args[0]);
    }
}

