/*
 * Decompiled with CFR 0.152.
 */
package medusa;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MedusaSettings {
    Hashtable<Integer, Color> colorTable = new Hashtable();
    Hashtable<Integer, String> interactionTable = new Hashtable();
    Color[] colorList = new Color[]{new Color(0, 180, 0), new Color(255, 0, 0), new Color(0, 0, 255), new Color(140, 140, 255), new Color(30, 30, 30), new Color(200, 0, 200), new Color(0, 160, 200), new Color(170, 200, 0), this.randomColor(), this.randomColor(), this.randomColor(), this.randomColor()};

    public Color randomColor() {
        int r = (int)(Math.random() * 255.0);
        int g = (int)(Math.random() * 255.0);
        int b = Math.min(255, 510 - r - g);
        return new Color(r, g, b);
    }

    public MedusaSettings() {
        this.init();
    }

    public Color getColorFromParam(String param) {
        String[] rgb = param.split(",");
        int red = Integer.parseInt(rgb[0]);
        int green = Integer.parseInt(rgb[1]);
        int blue = Integer.parseInt(rgb[2]);
        return new Color(red, green, blue);
    }

    public MedusaSettings(String settingsParam) {
        if (settingsParam != null) {
            this.readParam(settingsParam);
        } else {
            this.init();
        }
    }

    public void readParam(String settingsParam) {
        String[] colors = settingsParam.split(";");
        for (int i = 0; i < colors.length; ++i) {
            Color c = this.getColorFromParam(colors[i]);
            System.out.println(c);
            this.colorTable.put(new Integer(i + 1), c);
        }
    }

    public void clear() {
        this.colorTable.clear();
        this.interactionTable.clear();
    }

    public void init() {
        this.initColorTable();
        this.initInteractionTable();
    }

    public void initCOGS() {
        this.initColorTable();
        this.initCOGTable();
    }

    public void initString() {
        this.initColorTable();
        this.initStringTable();
    }

    public void initColorTable() {
        for (int i = 0; i < this.colorList.length; ++i) {
            this.colorTable.put(new Integer(i + 1), this.colorList[i]);
        }
    }

    public void initInteractionTable() {
        this.interactionTable.put(new Integer(1), "Type 1");
        this.interactionTable.put(new Integer(2), "Type 2");
        this.interactionTable.put(new Integer(3), "Type 3");
        this.interactionTable.put(new Integer(4), "Type 4");
        this.interactionTable.put(new Integer(5), "Type 5");
        this.interactionTable.put(new Integer(6), "Type 6");
        this.interactionTable.put(new Integer(7), "Type 7");
        this.interactionTable.put(new Integer(8), "Type 8");
    }

    public void initStringTable() {
        this.interactionTable.put(new Integer(1), "Neighbourhood");
        this.interactionTable.put(new Integer(2), "Gene Fusion");
        this.interactionTable.put(new Integer(3), "Cooccurence");
        this.interactionTable.put(new Integer(4), "Homology");
        this.interactionTable.put(new Integer(5), "Coexpression");
        this.interactionTable.put(new Integer(6), "Experiments");
        this.interactionTable.put(new Integer(7), "Databases");
        this.interactionTable.put(new Integer(8), "Text Mining");
    }

    public void initCOGTable() {
        this.interactionTable.put(new Integer(1), "Neighbourhood");
        this.interactionTable.put(new Integer(2), "Gene Fusion");
        this.interactionTable.put(new Integer(3), "Homology");
        this.interactionTable.put(new Integer(4), "Coexpression");
        this.interactionTable.put(new Integer(5), "Experiments");
        this.interactionTable.put(new Integer(6), "Databases");
        this.interactionTable.put(new Integer(7), "Text Mining");
    }

    public void load(String fileName) throws IOException {
        String inLine;
        File loadFile = new File(fileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(loadFile)));
        Pattern xyPattern = Pattern.compile("(\\d+)[, ](\\d+)[, ](\\d+)");
        this.interactionTable = new Hashtable();
        this.colorTable = new Hashtable();
        this.initColorTable();
        while ((inLine = in.readLine()) != null) {
            String[] result = inLine.split("\\t");
            Matcher matcher = xyPattern.matcher(inLine);
            this.interactionTable.put(new Integer(result[0]), result[1]);
            if (!matcher.find()) continue;
            int red = Integer.parseInt(matcher.group(1));
            int green = Integer.parseInt(matcher.group(2));
            int blue = Integer.parseInt(matcher.group(3));
            this.colorTable.put(new Integer(result[0]), new Color(red, green, blue));
        }
        in.close();
    }

    public int getSize() {
        return this.interactionTable.size();
    }

    public void report() {
        for (int i = 1; i < this.interactionTable.size(); ++i) {
            System.out.println(this.getName(new Integer(i), 0));
        }
    }

    public Color parseColor(String rgb) {
        String[] result = rgb.split(",");
        if (result.length < 3) {
            return this.randomColor();
        }
        int r = Integer.parseInt(result[0]);
        int g = Integer.parseInt(result[1]);
        int b = Integer.parseInt(result[2]);
        return new Color(r, g, b);
    }

    public Color getColor(Integer i) {
        return this.colorTable.get(i);
    }

    public void setColor(Integer i, Color color) {
        this.colorTable.put(i, color);
    }

    public String getName(Integer i, int len) {
        String name = this.interactionTable.get(i);
        if (name == null) {
            return "null!?";
        }
        if (name.length() < len || len == 0) {
            return name;
        }
        return name.substring(0, len - 1);
    }

    public String getName(Integer i) {
        String name = this.interactionTable.get(i);
        if (name == null) {
            return "null!?";
        }
        return name;
    }

    public void setName(Integer i, String name) {
        this.interactionTable.put(i, name);
    }
}

