/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            transferDataArray[n] = new TransferData();
            transferDataArray[n].type = nArray[n];
            transferDataArray[n].formatetc = new FORMATETC();
            transferDataArray[n].formatetc.cfFormat = nArray[n];
            transferDataArray[n].formatetc.dwAspect = 1;
            transferDataArray[n].formatetc.lindex = -1;
            transferDataArray[n].formatetc.tymed = 1;
            ++n;
        }
        return transferDataArray;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        int n = 0;
        while (n < nArray.length) {
            FORMATETC fORMATETC = transferData.formatetc;
            if (fORMATETC.cfFormat == nArray[n] && (fORMATETC.dwAspect & 1) == 1 && (fORMATETC.tymed & 1) == 1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        int n2 = OS.GlobalAlloc(64, n);
        OS.MoveMemory(n2, byArray, n);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n2;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        FORMATETC fORMATETC = transferData.formatetc;
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        sTGMEDIUM.tymed = 1;
        transferData.result = iDataObject.GetData(fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n = sTGMEDIUM.unionField;
        int n2 = OS.GlobalSize(n);
        byte[] byArray = new byte[n2];
        int n3 = OS.GlobalLock(n);
        OS.MoveMemory(byArray, n3, n2);
        OS.GlobalUnlock(n);
        OS.GlobalFree(n);
        return byArray;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

