/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.PolynomialRegressionModel;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class PolynomialRegressionTest
extends OpenForecastTestCase {
    public void testPolynomialRegression() {
        DataSet observedData = new DataSet();
        for (int x = 0; x < 10; ++x) {
            double y = 10.6 + 3.5 * (double)x + 0.5 * Math.pow(x, 3.0);
            Observation dp = new Observation(y);
            dp.setIndependentValue("x1", x);
            dp.setIndependentValue("x2", (Math.random() - 0.5) * 100.0);
            observedData.add(dp);
        }
        PolynomialRegressionModel model = new PolynomialRegressionModel("x1", 5);
        model.init(observedData);
        DataSet fcValues = new DataSet();
        double[] expectedResult = new double[10];
        for (int x = 10; x < 20; ++x) {
            double y = 10.6 + 3.5 * (double)x + 0.5 * Math.pow(x, 3.0);
            Observation dp = new Observation(0.0);
            dp.setIndependentValue("x1", x);
            dp.setIndependentValue("x2", (Math.random() - 0.5) * 100.0);
            fcValues.add(dp);
            expectedResult[x - 10] = y;
        }
        DataSet results = model.forecast(fcValues);
        this.checkResults(results, expectedResult);
    }

    public PolynomialRegressionTest(String name) {
        super(name);
    }
}

