/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Forecaster;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.MovingAverageModel;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class MovingAverageTest
extends OpenForecastTestCase {
    public MovingAverageTest(String name) {
        super(name);
    }

    public void testConstantMovingAverage() {
        DataSet observedData = new DataSet();
        Observation dp = new Observation(5.0);
        dp.setIndependentValue("t", 1.0);
        observedData.add(dp);
        dp = new Observation(5.0);
        dp.setIndependentValue("t", 2.0);
        observedData.add(dp);
        dp = new Observation(5.0);
        dp.setIndependentValue("t", 3.0);
        observedData.add(dp);
        dp = new Observation(5.0);
        dp.setIndependentValue("t", 4.0);
        observedData.add(dp);
        dp = new Observation(5.0);
        dp.setIndependentValue("t", 5.0);
        observedData.add(dp);
        dp = new Observation(5.0);
        dp.setIndependentValue("t", 6.0);
        observedData.add(dp);
        MovingAverageModel model = new MovingAverageModel(3);
        model.init(observedData);
        DataSet fcValues = new DataSet();
        dp = new Observation(0.0);
        dp.setIndependentValue("t", 7.0);
        fcValues.add(dp);
        dp = new Observation(0.0);
        dp.setIndependentValue("t", 8.0);
        fcValues.add(dp);
        dp = new Observation(0.0);
        dp.setIndependentValue("t", 9.0);
        fcValues.add(dp);
        DataSet results = model.forecast(fcValues);
        double[] expectedResult = new double[]{5.0, 5.0, 5.0};
        this.checkResults(results, expectedResult);
    }

    public void testMovingAverage() {
        DataSet observedData = new DataSet();
        Observation dp = new Observation(4.0);
        dp.setIndependentValue("t", 101.0);
        observedData.add(dp);
        dp = new Observation(5.0);
        dp.setIndependentValue("t", 102.0);
        observedData.add(dp);
        dp = new Observation(6.0);
        dp.setIndependentValue("t", 103.0);
        observedData.add(dp);
        dp = new Observation(9.0);
        dp.setIndependentValue("t", 104.0);
        observedData.add(dp);
        dp = new Observation(3.0);
        dp.setIndependentValue("t", 105.0);
        observedData.add(dp);
        dp = new Observation(7.0);
        dp.setIndependentValue("t", 106.0);
        observedData.add(dp);
        dp = new Observation(5.0);
        dp.setIndependentValue("t", 107.0);
        observedData.add(dp);
        dp = new Observation(6.0);
        dp.setIndependentValue("t", 108.0);
        observedData.add(dp);
        dp = new Observation(7.0);
        dp.setIndependentValue("t", 109.0);
        observedData.add(dp);
        dp = new Observation(9.0);
        dp.setIndependentValue("t", 110.0);
        observedData.add(dp);
        dp = new Observation(3.0);
        dp.setIndependentValue("t", 111.0);
        observedData.add(dp);
        dp = new Observation(4.0);
        dp.setIndependentValue("t", 112.0);
        observedData.add(dp);
        dp = new Observation(6.0);
        dp.setIndependentValue("t", 113.0);
        observedData.add(dp);
        dp = new Observation(7.0);
        dp.setIndependentValue("t", 114.0);
        observedData.add(dp);
        dp = new Observation(7.0);
        dp.setIndependentValue("t", 115.0);
        observedData.add(dp);
        dp = new Observation(4.0);
        dp.setIndependentValue("t", 116.0);
        observedData.add(dp);
        MovingAverageModel model = new MovingAverageModel(4);
        model.init(observedData);
        DataSet fcValues = new DataSet();
        for (int t = 105; t <= 120; ++t) {
            dp = new Observation(0.0);
            dp.setIndependentValue("t", t);
            fcValues.add(dp);
        }
        DataSet results = model.forecast(fcValues);
        double[] expectedResult = new double[]{6.0, 5.75, 6.25, 6.0, 5.25, 6.25, 6.75, 6.25, 5.75, 5.5, 5.0, 6.0, 6.0, 6.0, 5.75, 5.4375};
        this.checkResults(results, expectedResult);
    }

    public void _testForecaster() {
        DataSet observedData = new DataSet();
        double[] values = new double[]{20.0, 21.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 22.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 19.0, 20.0, 20.0, 19.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 21.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 19.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0};
        for (int count = 0; count < values.length; ++count) {
            Observation dp = new Observation(values[count]);
            dp.setIndependentValue("t", count);
            observedData.add(dp);
        }
        observedData.setTimeVariable("t");
        observedData.setPeriodsPerYear(4);
        ForecastingModel model = Forecaster.getBestForecast(observedData);
        model.init(observedData);
        MovingAverageTest.assertTrue((String)"Validate that a moving average model was chosen", (boolean)model.getClass().getName().equals("net.sourceforge.openforecast.models.MovingAverageModel"));
    }
}

