/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.browser.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.tmatesoft.sqljet.browser.DBBrowserConfig;
import org.tmatesoft.sqljet.browser.core.BrowserComponentManager;

public class RecentMenu
implements MenuListener,
ChangeListener {
    private JMenu myMenu;
    private BrowserComponentManager myManager;

    public RecentMenu(BrowserComponentManager manager, JMenu owner) {
        this.myMenu = owner;
        this.myManager = manager;
        this.myManager.addChangeListener(this);
    }

    public void menuCanceled(MenuEvent e) {
        this.myMenu.removeAll();
    }

    public void menuDeselected(MenuEvent e) {
        this.myMenu.removeAll();
    }

    public void menuSelected(MenuEvent e) {
        List<File> recent = DBBrowserConfig.getRecentDBs();
        if (recent.isEmpty()) {
            JMenuItem item = this.myMenu.add("<empty>");
            item.setEnabled(false);
        } else {
            int index = 1;
            for (final File file : recent) {
                JMenuItem item = this.myMenu.add(index + " " + file.getPath());
                char indexChar = (index + "").charAt(0);
                item.setMnemonic(indexChar);
                ++index;
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        RecentMenu.this.myManager.open(file);
                    }
                });
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        File openDB = this.myManager.getDBFile();
        if (openDB == null) {
            return;
        }
        List<File> recent = DBBrowserConfig.getRecentDBs();
        int count = recent.size();
        Iterator<File> files = recent.iterator();
        while (files.hasNext()) {
            File file = files.next();
            if (!file.equals(openDB)) continue;
            files.remove();
            break;
        }
        if (count == recent.size() && recent.size() > 0 && recent.size() > 5) {
            recent.remove(recent.size() - 1);
        }
        recent.add(0, openDB);
        DBBrowserConfig.setRecentDBs(recent);
    }
}

