/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.EventListener;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class EnhancedPanel
extends JPanel {
    private static final Logger logger;
    private transient EventListenerList listenerList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnhancedPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    public EnhancedPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public EnhancedPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public EnhancedPanel() {
        this.init();
    }

    private void init() {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 4L) {
                    return;
                }
                Window window = EnhancedPanel.this.getAncestorWindow();
                boolean windowShown = window.isShowing();
                if (windowShown != EnhancedPanel.this.isShowing()) {
                    return;
                }
                EnhancedPanel.this.processPanelEvent(new PanelEvent(EnhancedPanel.this, windowShown ? 2000 : 2001));
            }
        });
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        if (!$assertionsDisabled && existingEvent.getSource() != newEvent.getSource()) {
            throw new AssertionError();
        }
        if (existingEvent instanceof PanelEvent && newEvent instanceof PanelEvent) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"This is dead code since the refactoring for TrueZIP 6.4!");
            }
            int id = newEvent.getID();
            if (!$assertionsDisabled && id != existingEvent.getID()) {
                throw new AssertionError();
            }
            switch (id) {
                case 2000: 
                case 2001: {
                    return newEvent;
                }
            }
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof PanelEvent) {
            this.processPanelEvent((PanelEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processPanelEvent(PanelEvent event) {
        logger.fine("Processing " + event);
        switch (event.getID()) {
            case 2000: {
                this.fireAncestorWindowShown(event);
                break;
            }
            case 2001: {
                this.fireAncestorWindowHidden(event);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public Window getAncestorWindow() {
        return EnhancedPanel.getAncestorWindow(this);
    }

    private static final Window getAncestorWindow(Component c) {
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        return (Window)c;
    }

    public void addPanelListener(PanelListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PanelListener.class, listener);
    }

    public void removePanelListener(PanelListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(PanelListener.class, listener);
    }

    public PanelListener[] getPanelListeners() {
        if (this.listenerList != null) {
            return (PanelListener[])this.listenerList.getListeners(PanelListener.class);
        }
        return new PanelListener[0];
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == PanelListener.class) {
            return this.getPanelListeners();
        }
        return super.getListeners(listenerType);
    }

    protected void fireAncestorWindowShown(PanelEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$de$schlichtherle$swing$event$PanelListener == null ? EnhancedPanel.class$("de.schlichtherle.swing.event.PanelListener") : class$de$schlichtherle$swing$event$PanelListener)) continue;
            ((PanelListener)listeners[i + 1]).ancestorWindowShown(event);
        }
    }

    protected void fireAncestorWindowHidden(PanelEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$de$schlichtherle$swing$event$PanelListener == null ? EnhancedPanel.class$("de.schlichtherle.swing.event.PanelListener") : class$de$schlichtherle$swing$event$PanelListener)) continue;
            ((PanelListener)listeners[i + 1]).ancestorWindowHidden(event);
        }
    }

    static {
        $assertionsDisabled = !EnhancedPanel.class.desiredAssertionStatus();
        logger = Logger.getLogger(EnhancedPanel.class.getName());
    }
}

