/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.surround.query.SimpleTerm;

public class SrndPrefixQuery
extends SimpleTerm {
    private final String prefix;
    private final char truncator;

    public SrndPrefixQuery(String prefix, boolean quoted, char truncator) {
        super(quoted);
        this.prefix = prefix;
        this.truncator = truncator;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public char getSuffixOperator() {
        return this.truncator;
    }

    public Term getLucenePrefixTerm(String fieldName) {
        return new Term(fieldName, this.getPrefix());
    }

    @Override
    public String toStringUnquoted() {
        return this.getPrefix();
    }

    @Override
    protected void suffixToString(StringBuffer r) {
        r.append(this.getSuffixOperator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        boolean expanded = false;
        try (TermEnum enumerator = reader.terms(this.getLucenePrefixTerm(fieldName));){
            Term term;
            while ((term = enumerator.term()) != null && term.text().startsWith(this.getPrefix()) && term.field().equals(fieldName)) {
                mtv.visitMatchingTerm(term);
                expanded = true;
                if (enumerator.next()) continue;
                break;
            }
        }
        if (!expanded) {
            System.out.println("No terms in " + fieldName + " field for: " + this.toString());
        }
    }
}

