/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.DefaultSimilarity;

public class SweetSpotSimilarity
extends DefaultSimilarity {
    private int ln_min = 1;
    private int ln_max = 1;
    private float ln_steep = 0.5f;
    private Map ln_mins = new HashMap(7);
    private Map ln_maxs = new HashMap(7);
    private Map ln_steeps = new HashMap(7);
    private float tf_base = 0.0f;
    private float tf_min = 0.0f;
    private float tf_hyper_min = 0.0f;
    private float tf_hyper_max = 2.0f;
    private double tf_hyper_base = 1.3;
    private float tf_hyper_xoffset = 10.0f;

    public void setBaselineTfFactors(float base, float min) {
        this.tf_min = min;
        this.tf_base = base;
    }

    public void setHyperbolicTfFactors(float min, float max, double base, float xoffset) {
        this.tf_hyper_min = min;
        this.tf_hyper_max = max;
        this.tf_hyper_base = base;
        this.tf_hyper_xoffset = xoffset;
    }

    public void setLengthNormFactors(int min, int max, float steepness) {
        this.ln_min = min;
        this.ln_max = max;
        this.ln_steep = steepness;
    }

    public void setLengthNormFactors(String field, int min, int max, float steepness) {
        this.ln_mins.put(field, new Integer(min));
        this.ln_maxs.put(field, new Integer(max));
        this.ln_steeps.put(field, new Float(steepness));
    }

    @Override
    public float lengthNorm(String fieldName, int numTerms) {
        int l = this.ln_min;
        int h = this.ln_max;
        float s = this.ln_steep;
        if (this.ln_mins.containsKey(fieldName)) {
            l = ((Number)this.ln_mins.get(fieldName)).intValue();
        }
        if (this.ln_maxs.containsKey(fieldName)) {
            h = ((Number)this.ln_maxs.get(fieldName)).intValue();
        }
        if (this.ln_steeps.containsKey(fieldName)) {
            s = ((Number)this.ln_steeps.get(fieldName)).floatValue();
        }
        return (float)(1.0 / Math.sqrt(s * (float)(Math.abs(numTerms - l) + Math.abs(numTerms - h) - (h - l)) + 1.0f));
    }

    @Override
    public float tf(int freq) {
        return this.baselineTf(freq);
    }

    public float baselineTf(float freq) {
        if (0.0f == freq) {
            return 0.0f;
        }
        return freq <= this.tf_min ? this.tf_base : (float)Math.sqrt(freq + this.tf_base * this.tf_base - this.tf_min);
    }

    public float hyperbolicTf(float freq) {
        if (0.0f == freq) {
            return 0.0f;
        }
        float min = this.tf_hyper_min;
        float max = this.tf_hyper_max;
        double base = this.tf_hyper_base;
        float xoffset = this.tf_hyper_xoffset;
        double x = freq - xoffset;
        float result = min + (float)((double)((max - min) / 2.0f) * ((Math.pow(base, x) - Math.pow(base, -x)) / (Math.pow(base, x) + Math.pow(base, -x)) + 1.0));
        return Float.isNaN(result) ? max : result;
    }
}

