/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LengthNormModifier {
    private Directory dir;
    private Similarity sim;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("Usage: LengthNormModifier <index> <package.SimilarityClassName> <field1> [field2] ...");
            System.exit(1);
        }
        Similarity s = null;
        try {
            Class<?> simClass = Class.forName(args[1]);
            s = (Similarity)simClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("Couldn't instantiate similarity with empty constructor: " + args[1]);
            e.printStackTrace(System.err);
        }
        File index = new File(args[0]);
        FSDirectory d = FSDirectory.getDirectory(index, false);
        LengthNormModifier lnm = new LengthNormModifier(d, s);
        for (int i = 2; i < args.length; ++i) {
            System.out.print("Updating field: " + args[i] + " " + new Date().toString() + " ... ");
            lnm.reSetNorms(args[i]);
            System.out.println(new Date().toString());
        }
        ((Directory)d).close();
    }

    public LengthNormModifier(Directory d, Similarity s) {
        this.dir = d;
        this.sim = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reSetNorms(String field) throws IOException {
        String fieldName = field.intern();
        int[] termCounts = new int[]{};
        IndexReader reader = null;
        TermEnum termEnum = null;
        TermDocs termDocs = null;
        try {
            reader = IndexReader.open(this.dir);
            termCounts = new int[reader.maxDoc()];
            try {
                termEnum = reader.terms(new Term(field, ""));
                try {
                    termDocs = reader.termDocs();
                    do {
                        Term term;
                        if ((term = termEnum.term()) == null || !term.field().equals(fieldName)) continue;
                        termDocs.seek(termEnum.term());
                        while (termDocs.next()) {
                            int n = termDocs.doc();
                            termCounts[n] = termCounts[n] + termDocs.freq();
                        }
                    } while (termEnum.next());
                }
                finally {
                    if (null != termDocs) {
                        termDocs.close();
                    }
                }
            }
            finally {
                if (null != termEnum) {
                    termEnum.close();
                }
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        try {
            reader = IndexReader.open(this.dir);
            for (int d = 0; d < termCounts.length; ++d) {
                if (reader.isDeleted(d)) continue;
                byte norm = Similarity.encodeNorm(this.sim.lengthNorm(fieldName, termCounts[d]));
                reader.setNorm(d, fieldName, norm);
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }
}

