/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;

final class TermInfosWriter {
    public static final int FORMAT = -3;
    private FieldInfos fieldInfos;
    private IndexOutput output;
    private TermInfo lastTi = new TermInfo();
    private long size;
    int indexInterval = 128;
    int skipInterval = 16;
    int maxSkipLevels = 10;
    private long lastIndexPointer;
    private boolean isIndex;
    private char[] lastTermText = new char[10];
    private int lastTermTextLength;
    private int lastFieldNumber = -1;
    private char[] termTextBuffer = new char[10];
    private TermInfosWriter other;

    TermInfosWriter(Directory directory, String segment, FieldInfos fis, int interval) throws IOException {
        this.initialize(directory, segment, fis, interval, false);
        this.other = new TermInfosWriter(directory, segment, fis, interval, true);
        this.other.other = this;
    }

    private TermInfosWriter(Directory directory, String segment, FieldInfos fis, int interval, boolean isIndex) throws IOException {
        this.initialize(directory, segment, fis, interval, isIndex);
    }

    private void initialize(Directory directory, String segment, FieldInfos fis, int interval, boolean isi) throws IOException {
        this.indexInterval = interval;
        this.fieldInfos = fis;
        this.isIndex = isi;
        this.output = directory.createOutput(segment + (this.isIndex ? ".tii" : ".tis"));
        this.output.writeInt(-3);
        this.output.writeLong(0L);
        this.output.writeInt(this.indexInterval);
        this.output.writeInt(this.skipInterval);
        this.output.writeInt(this.maxSkipLevels);
    }

    void add(Term term, TermInfo ti) throws IOException {
        int length = term.text.length();
        if (this.termTextBuffer.length < length) {
            this.termTextBuffer = new char[(int)((double)length * 1.25)];
        }
        term.text.getChars(0, length, this.termTextBuffer, 0);
        this.add(this.fieldInfos.fieldNumber(term.field), this.termTextBuffer, 0, length, ti);
    }

    private int compareToLastTerm(int fieldNumber, char[] termText, int start, int length) {
        int pos;
        int cmp;
        if (this.lastFieldNumber != fieldNumber && ((cmp = this.fieldInfos.fieldName(this.lastFieldNumber).compareTo(this.fieldInfos.fieldName(fieldNumber))) != 0 || this.lastFieldNumber != -1)) {
            return cmp;
        }
        for (pos = 0; pos < length && pos < this.lastTermTextLength; ++pos) {
            char c1 = this.lastTermText[pos];
            char c2 = termText[pos + start];
            if (c1 < c2) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        if (pos < this.lastTermTextLength) {
            return 1;
        }
        if (pos < length) {
            return -1;
        }
        return 0;
    }

    void add(int fieldNumber, char[] termText, int termTextStart, int termTextLength, TermInfo ti) throws IOException {
        assert (this.compareToLastTerm(fieldNumber, termText, termTextStart, termTextLength) < 0 || this.isIndex && termTextLength == 0 && this.lastTermTextLength == 0) : "Terms are out of order: field=" + this.fieldInfos.fieldName(fieldNumber) + " (number " + fieldNumber + ") lastField=" + this.fieldInfos.fieldName(this.lastFieldNumber) + " (number " + this.lastFieldNumber + ") text=" + new String(termText, termTextStart, termTextLength) + " lastText=" + new String(this.lastTermText, 0, this.lastTermTextLength);
        assert (ti.freqPointer >= this.lastTi.freqPointer) : "freqPointer out of order (" + ti.freqPointer + " < " + this.lastTi.freqPointer + ")";
        assert (ti.proxPointer >= this.lastTi.proxPointer) : "proxPointer out of order (" + ti.proxPointer + " < " + this.lastTi.proxPointer + ")";
        if (!this.isIndex && this.size % (long)this.indexInterval == 0L) {
            this.other.add(this.lastFieldNumber, this.lastTermText, 0, this.lastTermTextLength, this.lastTi);
        }
        this.writeTerm(fieldNumber, termText, termTextStart, termTextLength);
        this.output.writeVInt(ti.docFreq);
        this.output.writeVLong(ti.freqPointer - this.lastTi.freqPointer);
        this.output.writeVLong(ti.proxPointer - this.lastTi.proxPointer);
        if (ti.docFreq >= this.skipInterval) {
            this.output.writeVInt(ti.skipOffset);
        }
        if (this.isIndex) {
            this.output.writeVLong(this.other.output.getFilePointer() - this.lastIndexPointer);
            this.lastIndexPointer = this.other.output.getFilePointer();
        }
        if (this.lastTermText.length < termTextLength) {
            this.lastTermText = new char[(int)((double)termTextLength * 1.25)];
        }
        System.arraycopy(termText, termTextStart, this.lastTermText, 0, termTextLength);
        this.lastTermTextLength = termTextLength;
        this.lastFieldNumber = fieldNumber;
        this.lastTi.set(ti);
        ++this.size;
    }

    private void writeTerm(int fieldNumber, char[] termText, int termTextStart, int termTextLength) throws IOException {
        int start;
        int limit;
        int n = limit = termTextLength < this.lastTermTextLength ? termTextLength : this.lastTermTextLength;
        for (start = 0; start < limit && termText[termTextStart + start] == this.lastTermText[start]; ++start) {
        }
        int length = termTextLength - start;
        this.output.writeVInt(start);
        this.output.writeVInt(length);
        this.output.writeChars(termText, start + termTextStart, length);
        this.output.writeVInt(fieldNumber);
    }

    void close() throws IOException {
        this.output.seek(4L);
        this.output.writeLong(this.size);
        this.output.close();
        if (!this.isIndex) {
            this.other.close();
        }
    }
}

