/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

final class SegmentMerger {
    static final byte[] NORMS_HEADER = new byte[]{78, 82, 77, -1};
    private Directory directory;
    private String segment;
    private int termIndexInterval = 128;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private int mergedDocs;
    private CheckAbort checkAbort;
    private boolean mergeDocStores;
    private static final int MAX_RAW_MERGE_DOCS = 4192;
    private IndexOutput freqOutput = null;
    private IndexOutput proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private int skipInterval;
    private int maxSkipLevels;
    private SegmentMergeQueue queue = null;
    private DefaultSkipListWriter skipListWriter = null;
    private final TermInfo termInfo = new TermInfo();
    private byte[] payloadBuffer = null;

    SegmentMerger(Directory dir, String name) {
        this.directory = dir;
        this.segment = name;
    }

    SegmentMerger(IndexWriter writer, String name, MergePolicy.OneMerge merge) {
        this.directory = writer.getDirectory();
        this.segment = name;
        if (merge != null) {
            this.checkAbort = new CheckAbort(merge, this.directory);
        }
        this.termIndexInterval = writer.getTermIndexInterval();
    }

    final void add(IndexReader reader) {
        this.readers.addElement(reader);
    }

    final IndexReader segmentReader(int i) {
        return (IndexReader)this.readers.elementAt(i);
    }

    final int merge() throws CorruptIndexException, IOException {
        return this.merge(true);
    }

    final int merge(boolean mergeDocStores) throws CorruptIndexException, IOException {
        this.mergeDocStores = mergeDocStores;
        this.mergedDocs = this.mergeFields();
        this.mergeTerms();
        this.mergeNorms();
        if (mergeDocStores && this.fieldInfos.hasVectors()) {
            this.mergeVectors();
        }
        return this.mergedDocs;
    }

    final void closeReaders() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            reader.close();
        }
    }

    final Vector createCompoundFile(String fileName) throws IOException {
        int i;
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, fileName, this.checkAbort);
        Vector<String> files = new Vector<String>(IndexFileNames.COMPOUND_EXTENSIONS.length + 1);
        for (i = 0; i < IndexFileNames.COMPOUND_EXTENSIONS.length; ++i) {
            String ext = IndexFileNames.COMPOUND_EXTENSIONS[i];
            if (!this.mergeDocStores && (ext.equals("fdt") || ext.equals("fdx"))) continue;
            files.add(this.segment + "." + ext);
        }
        for (i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.omitNorms) continue;
            files.add(this.segment + "." + "nrm");
            break;
        }
        if (this.fieldInfos.hasVectors() && this.mergeDocStores) {
            for (i = 0; i < IndexFileNames.VECTOR_EXTENSIONS.length; ++i) {
                files.add(this.segment + "." + IndexFileNames.VECTOR_EXTENSIONS[i]);
            }
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
        return files;
    }

    private void addIndexed(IndexReader reader, FieldInfos fieldInfos, Collection names, boolean storeTermVectors, boolean storePositionWithTermVector, boolean storeOffsetWithTermVector, boolean storePayloads) throws IOException {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String field;
            fieldInfos.add(field, true, storeTermVectors, storePositionWithTermVector, storeOffsetWithTermVector, !reader.hasNorms(field = (String)i.next()), storePayloads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeFields() throws CorruptIndexException, IOException {
        if (!this.mergeDocStores) {
            SegmentReader sr = (SegmentReader)this.readers.elementAt(this.readers.size() - 1);
            this.fieldInfos = (FieldInfos)sr.fieldInfos.clone();
        } else {
            this.fieldInfos = new FieldInfos();
        }
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            if (reader instanceof SegmentReader) {
                SegmentReader segmentReader = (SegmentReader)reader;
                for (int j = 0; j < segmentReader.getFieldInfos().size(); ++j) {
                    FieldInfo fi = segmentReader.getFieldInfos().fieldInfo(j);
                    this.fieldInfos.add(fi.name, fi.isIndexed, fi.storeTermVector, fi.storePositionWithTermVector, fi.storeOffsetWithTermVector, !reader.hasNorms(fi.name), fi.storePayloads);
                }
                continue;
            }
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET), true, true, true, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_POSITION), true, true, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET), true, false, true, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.TERMVECTOR), true, false, false, false);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.STORES_PAYLOADS), false, false, false, true);
            this.addIndexed(reader, this.fieldInfos, reader.getFieldNames(IndexReader.FieldOption.INDEXED), false, false, false, false);
            this.fieldInfos.add(reader.getFieldNames(IndexReader.FieldOption.UNINDEXED), false);
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        int docCount = 0;
        if (this.mergeDocStores) {
            SegmentReader[] matchingSegmentReaders = new SegmentReader[this.readers.size()];
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader reader = (IndexReader)this.readers.elementAt(i);
                if (!(reader instanceof SegmentReader)) continue;
                SegmentReader segmentReader = (SegmentReader)reader;
                boolean same = true;
                FieldInfos segmentFieldInfos = segmentReader.getFieldInfos();
                for (int j = 0; same && j < segmentFieldInfos.size(); ++j) {
                    same = this.fieldInfos.fieldName(j).equals(segmentFieldInfos.fieldName(j));
                }
                if (!same) continue;
                matchingSegmentReaders[i] = segmentReader;
            }
            int[] rawDocLengths = new int[4192];
            FieldSelector fieldSelectorMerge = new FieldSelector(){

                @Override
                public FieldSelectorResult accept(String fieldName) {
                    return FieldSelectorResult.LOAD_FOR_MERGE;
                }
            };
            try (FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);){
                for (int i = 0; i < this.readers.size(); ++i) {
                    IndexReader reader = (IndexReader)this.readers.elementAt(i);
                    SegmentReader matchingSegmentReader = matchingSegmentReaders[i];
                    FieldsReader matchingFieldsReader = matchingSegmentReader != null ? matchingSegmentReader.getFieldsReader() : null;
                    int maxDoc = reader.maxDoc();
                    int j = 0;
                    while (j < maxDoc) {
                        if (!reader.isDeleted(j)) {
                            if (matchingSegmentReader != null) {
                                int start = j;
                                int numDocs = 0;
                                while (++j < maxDoc && !matchingSegmentReader.isDeleted(j) && ++numDocs < 4192) {
                                }
                                IndexInput stream = matchingFieldsReader.rawDocs(rawDocLengths, start, numDocs);
                                fieldsWriter.addRawDocuments(stream, rawDocLengths, numDocs);
                                docCount += numDocs;
                                if (this.checkAbort == null) continue;
                                this.checkAbort.work(300 * numDocs);
                                continue;
                            }
                            fieldsWriter.addDocument(reader.document(j, fieldSelectorMerge));
                            ++j;
                            ++docCount;
                            if (this.checkAbort == null) continue;
                            this.checkAbort.work(300.0);
                            continue;
                        }
                        ++j;
                    }
                }
            }
            assert ((long)(docCount * 8) == this.directory.fileLength(this.segment + "." + "fdx")) : "after mergeFields: fdx size mismatch: " + docCount + " docs vs " + this.directory.fileLength(this.segment + "." + "fdx") + " length in bytes of " + this.segment + "." + "fdx";
        } else {
            for (int i = 0; i < this.readers.size(); ++i) {
                docCount += ((IndexReader)this.readers.elementAt(i)).numDocs();
            }
        }
        return docCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeVectors() throws IOException {
        try (TermVectorsWriter termVectorsWriter = new TermVectorsWriter(this.directory, this.segment, this.fieldInfos);){
            for (int r = 0; r < this.readers.size(); ++r) {
                IndexReader reader = (IndexReader)this.readers.elementAt(r);
                int maxDoc = reader.maxDoc();
                for (int docNum = 0; docNum < maxDoc; ++docNum) {
                    if (reader.isDeleted(docNum)) continue;
                    termVectorsWriter.addAllDocVectors(reader.getTermFreqVectors(docNum));
                    if (this.checkAbort == null) continue;
                    this.checkAbort.work(300.0);
                }
            }
        }
        assert ((long)(4 + this.mergedDocs * 8) == this.directory.fileLength(this.segment + "." + "tvx")) : "after mergeVectors: tvx size mismatch: " + this.mergedDocs + " docs vs " + this.directory.fileLength(this.segment + "." + "tvx") + " length in bytes of " + this.segment + "." + "tvx";
    }

    private final void mergeTerms() throws CorruptIndexException, IOException {
        try {
            this.freqOutput = this.directory.createOutput(this.segment + ".frq");
            this.proxOutput = this.directory.createOutput(this.segment + ".prx");
            this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos, this.termIndexInterval);
            this.skipInterval = this.termInfosWriter.skipInterval;
            this.maxSkipLevels = this.termInfosWriter.maxSkipLevels;
            this.skipListWriter = new DefaultSkipListWriter(this.skipInterval, this.maxSkipLevels, this.mergedDocs, this.freqOutput, this.proxOutput);
            this.queue = new SegmentMergeQueue(this.readers.size());
            this.mergeTermInfos();
        }
        finally {
            if (this.freqOutput != null) {
                this.freqOutput.close();
            }
            if (this.proxOutput != null) {
                this.proxOutput.close();
            }
            if (this.termInfosWriter != null) {
                this.termInfosWriter.close();
            }
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos() throws CorruptIndexException, IOException {
        int base = 0;
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            TermEnum termEnum = reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(base, termEnum, reader);
            base += reader.numDocs();
            if (smi.next()) {
                this.queue.put(smi);
                continue;
            }
            smi.close();
        }
        SegmentMergeInfo[] match = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int matchSize = 0;
            match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
            Term term = match[0].term;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            while (top != null && term.compareTo(top.term) == 0) {
                match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
                top = (SegmentMergeInfo)this.queue.top();
            }
            int df = this.mergeTermInfo(match, matchSize);
            if (this.checkAbort != null) {
                this.checkAbort.work((double)df / 3.0);
            }
            while (matchSize > 0) {
                SegmentMergeInfo smi;
                if ((smi = match[--matchSize]).next()) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
        }
    }

    private final int mergeTermInfo(SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        long freqPointer = this.freqOutput.getFilePointer();
        long proxPointer = this.proxOutput.getFilePointer();
        int df = this.appendPostings(smis, n);
        long skipPointer = this.skipListWriter.writeSkip(this.freqOutput);
        if (df > 0) {
            this.termInfo.set(df, freqPointer, proxPointer, (int)(skipPointer - freqPointer));
            this.termInfosWriter.add(smis[0].term, this.termInfo);
        }
        return df;
    }

    private final int appendPostings(SegmentMergeInfo[] smis, int n) throws CorruptIndexException, IOException {
        int lastDoc = 0;
        int df = 0;
        this.skipListWriter.resetSkip();
        boolean storePayloads = this.fieldInfos.fieldInfo((String)smis[0].term.field).storePayloads;
        int lastPayloadLength = -1;
        for (int i = 0; i < n; ++i) {
            SegmentMergeInfo smi = smis[i];
            TermPositions postings = smi.getPositions();
            assert (postings != null);
            int base = smi.base;
            int[] docMap = smi.getDocMap();
            postings.seek(smi.termEnum);
            while (postings.next()) {
                int doc = postings.doc();
                if (docMap != null) {
                    doc = docMap[doc];
                }
                if ((doc += base) < 0 || df > 0 && doc <= lastDoc) {
                    throw new CorruptIndexException("docs out of order (" + doc + " <= " + lastDoc + " )");
                }
                if (++df % this.skipInterval == 0) {
                    this.skipListWriter.setSkipData(lastDoc, storePayloads, lastPayloadLength);
                    this.skipListWriter.bufferSkip(df);
                }
                int docCode = doc - lastDoc << 1;
                lastDoc = doc;
                int freq = postings.freq();
                if (freq == 1) {
                    this.freqOutput.writeVInt(docCode | 1);
                } else {
                    this.freqOutput.writeVInt(docCode);
                    this.freqOutput.writeVInt(freq);
                }
                int lastPosition = 0;
                for (int j = 0; j < freq; ++j) {
                    int position = postings.nextPosition();
                    int delta = position - lastPosition;
                    if (storePayloads) {
                        int payloadLength = postings.getPayloadLength();
                        if (payloadLength == lastPayloadLength) {
                            this.proxOutput.writeVInt(delta * 2);
                        } else {
                            this.proxOutput.writeVInt(delta * 2 + 1);
                            this.proxOutput.writeVInt(payloadLength);
                            lastPayloadLength = payloadLength;
                        }
                        if (payloadLength > 0) {
                            if (this.payloadBuffer == null || this.payloadBuffer.length < payloadLength) {
                                this.payloadBuffer = new byte[payloadLength];
                            }
                            postings.getPayload(this.payloadBuffer, 0);
                            this.proxOutput.writeBytes(this.payloadBuffer, 0, payloadLength);
                        }
                    } else {
                        this.proxOutput.writeVInt(delta);
                    }
                    lastPosition = position;
                }
            }
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNorms() throws IOException {
        byte[] normBuffer = null;
        try (IndexOutput output = null;){
            for (int i = 0; i < this.fieldInfos.size(); ++i) {
                FieldInfo fi = this.fieldInfos.fieldInfo(i);
                if (!fi.isIndexed || fi.omitNorms) continue;
                if (output == null) {
                    output = this.directory.createOutput(this.segment + "." + "nrm");
                    output.writeBytes(NORMS_HEADER, NORMS_HEADER.length);
                }
                for (int j = 0; j < this.readers.size(); ++j) {
                    IndexReader reader = (IndexReader)this.readers.elementAt(j);
                    int maxDoc = reader.maxDoc();
                    if (normBuffer == null || normBuffer.length < maxDoc) {
                        normBuffer = new byte[maxDoc];
                    }
                    reader.norms(fi.name, normBuffer, 0);
                    if (!reader.hasDeletions()) {
                        output.writeBytes(normBuffer, maxDoc);
                    } else {
                        for (int k = 0; k < maxDoc; ++k) {
                            if (reader.isDeleted(k)) continue;
                            output.writeByte(normBuffer[k]);
                        }
                    }
                    if (this.checkAbort == null) continue;
                    this.checkAbort.work(maxDoc);
                }
            }
        }
    }

    static final class CheckAbort {
        private double workCount;
        private MergePolicy.OneMerge merge;
        private Directory dir;

        public CheckAbort(MergePolicy.OneMerge merge, Directory dir) {
            this.merge = merge;
            this.dir = dir;
        }

        public void work(double units) throws MergePolicy.MergeAbortedException {
            this.workCount += units;
            if (this.workCount >= 10000.0) {
                this.merge.checkAborted(this.dir);
                this.workCount = 0.0;
            }
        }
    }
}

