/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import org.apache.lucene.index.IndexFileNames;

public class IndexFileNameFilter
implements FilenameFilter {
    static IndexFileNameFilter singleton = new IndexFileNameFilter();
    private HashSet extensions = new HashSet();
    private HashSet extensionsInCFS;

    public IndexFileNameFilter() {
        int i;
        for (i = 0; i < IndexFileNames.INDEX_EXTENSIONS.length; ++i) {
            this.extensions.add(IndexFileNames.INDEX_EXTENSIONS[i]);
        }
        this.extensionsInCFS = new HashSet();
        for (i = 0; i < IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE.length; ++i) {
            this.extensionsInCFS.add(IndexFileNames.INDEX_EXTENSIONS_IN_COMPOUND_FILE[i]);
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String extension = name.substring(1 + i);
            if (this.extensions.contains(extension)) {
                return true;
            }
            if (extension.startsWith("f") && extension.matches("f\\d+")) {
                return true;
            }
            if (extension.startsWith("s") && extension.matches("s\\d+")) {
                return true;
            }
        } else {
            if (name.equals("deletable")) {
                return true;
            }
            if (name.startsWith("segments")) {
                return true;
            }
        }
        return false;
    }

    public boolean isCFSFile(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String extension = name.substring(1 + i);
            if (this.extensionsInCFS.contains(extension)) {
                return true;
            }
            if (extension.startsWith("f") && extension.matches("f\\d+")) {
                return true;
            }
        }
        return false;
    }

    public static IndexFileNameFilter getFilter() {
        return singleton;
    }
}

