/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.payloads.TypeAsPayloadTokenFilter;

public class TypeAsPayloadTokenFilterTest
extends TestCase {
    public TypeAsPayloadTokenFilterTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void test() throws IOException {
        String test = "The quick red fox jumped over the lazy brown dogs";
        TypeAsPayloadTokenFilter nptf = new TypeAsPayloadTokenFilter(new WordTokenFilter(new WhitespaceTokenizer(new StringReader(test))));
        Token tok = new Token();
        int count = 0;
        while ((tok = nptf.next(tok)) != null) {
            TypeAsPayloadTokenFilterTest.assertTrue((String)(tok.type() + " is not null and it should be"), (boolean)tok.type().equals(String.valueOf(Character.toUpperCase(tok.termBuffer()[0]))));
            TypeAsPayloadTokenFilterTest.assertTrue((String)"tok.getPayload() is null and it shouldn't be", (tok.getPayload() != null ? 1 : 0) != 0);
            String type = new String(tok.getPayload().getData(), "UTF-8");
            TypeAsPayloadTokenFilterTest.assertTrue((String)"type is null and it shouldn't be", (type != null ? 1 : 0) != 0);
            TypeAsPayloadTokenFilterTest.assertTrue((String)(type + " is not equal to " + tok.type()), (type.equals(tok.type()) ? 1 : 0) != 0);
            ++count;
        }
        TypeAsPayloadTokenFilterTest.assertTrue((String)(count + " does not equal: " + 10), (count == 10 ? 1 : 0) != 0);
    }

    private class WordTokenFilter
    extends TokenFilter {
        private WordTokenFilter(TokenStream input) {
            super(input);
        }

        @Override
        public Token next(Token result) throws IOException {
            if ((result = this.input.next(result)) != null) {
                result.setType(String.valueOf(Character.toUpperCase(result.termBuffer()[0])));
            }
            return result;
        }
    }
}

