/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class NGramTokenFilter
extends TokenFilter {
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private int minGram;
    private int maxGram;
    private LinkedList ngrams;

    public NGramTokenFilter(TokenStream input, int minGram, int maxGram) {
        super(input);
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.ngrams = new LinkedList();
    }

    public NGramTokenFilter(TokenStream input) {
        this(input, 1, 2);
    }

    @Override
    public final Token next() throws IOException {
        if (this.ngrams.size() > 0) {
            return (Token)this.ngrams.removeFirst();
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.ngram(token);
        if (this.ngrams.size() > 0) {
            return (Token)this.ngrams.removeFirst();
        }
        return null;
    }

    private void ngram(Token token) {
        String inStr = token.termText();
        int inLen = inStr.length();
        for (int gramSize = this.minGram; gramSize <= this.maxGram; ++gramSize) {
            int pos = 0;
            while (pos + gramSize <= inLen) {
                String gram = inStr.substring(pos, pos + gramSize);
                Token tok = new Token(gram, pos, pos + gramSize);
                this.ngrams.add(tok);
                ++pos;
            }
        }
    }
}

