/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class TestElision
extends TestCase {
    public void testElision() {
        String test = "Plop, juste pour voir l'embrouille avec O'brian. M'enfin.";
        StandardTokenizer tokenizer = new StandardTokenizer(new StringReader(test));
        HashSet<String> articles = new HashSet<String>();
        articles.add("l");
        articles.add("M");
        ElisionFilter filter = new ElisionFilter((TokenStream)tokenizer, articles);
        List tas = this.filtre(filter);
        TestElision.assertEquals((Object)"embrouille", tas.get(4));
        TestElision.assertEquals((Object)"O'brian", tas.get(6));
        TestElision.assertEquals((Object)"enfin", tas.get(7));
    }

    private List filtre(TokenFilter filter) {
        ArrayList<String> tas = new ArrayList<String>();
        try {
            boolean encore = true;
            while (encore) {
                Token token = filter.next();
                boolean bl = encore = token != null;
                if (token == null) continue;
                tas.add(token.termText());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tas;
    }
}

