/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;

public class WordlistLoader {
    public static HashSet getWordSet(File wordfile) throws IOException {
        HashSet result = new HashSet();
        try (FileReader reader = null;){
            reader = new FileReader(wordfile);
            result = WordlistLoader.getWordSet(reader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet getWordSet(Reader reader) throws IOException {
        HashSet<String> result = new HashSet<String>();
        try (BufferedReader br = null;){
            br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            String word = null;
            while ((word = br.readLine()) != null) {
                result.add(word.trim());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getStemDict(File wordstemfile) throws IOException {
        if (wordstemfile == null) {
            throw new NullPointerException("wordstemfile may not be null");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        BufferedReader br = null;
        FileReader fr = null;
        try {
            String line;
            fr = new FileReader(wordstemfile);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] wordstem = line.split("\t", 2);
                result.put(wordstem[0], wordstem[1]);
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return result;
    }
}

