/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.cmdline.SqlTool;
import org.hsqldb.cmdline.SqlToolError;
import org.hsqldb.cmdline.SqltoolRB;
import org.hsqldb.cmdline.sqltool.Calculator;
import org.hsqldb.cmdline.sqltool.FileRecordReader;
import org.hsqldb.cmdline.sqltool.SqlFileScanner;
import org.hsqldb.cmdline.sqltool.Token;
import org.hsqldb.cmdline.sqltool.TokenList;
import org.hsqldb.cmdline.sqltool.TokenSource;
import org.hsqldb.lib.AppendableException;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.RCData;
import org.hsqldb.lib.StringUtil;

public class SqlFile {
    private static FrameworkLogger logger = FrameworkLogger.getLog(SqlFile.class);
    private static final int DEFAULT_HISTORY_SIZE = 40;
    private boolean executing;
    private boolean permitEmptySqlStatements;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private static String rawPrompt;
    private static Method createArrayOfMethod;
    private String contPrompt = "  +> ";
    private boolean htmlMode;
    private TokenList history;
    public static String LS;
    private int maxHistoryLength = 1;
    private boolean reportTimes;
    private Reader reader;
    private String inputStreamLabel;
    private File baseDir;
    private boolean dsvTrimAll;
    private boolean ignoreBangStatus;
    private boolean allQuoted;
    private boolean doPrepare;
    private static String DSV_X_SYNTAX_MSG;
    private static String DSV_M_SYNTAX_MSG;
    private static String nobufferYetString;
    private String prepareVar;
    private int dsvRecordsPerCommit = 0;
    static String DEFAULT_FILE_ENCODING;
    static Set<String> hiddenVars;
    private String nullRepToken;
    private String nullRepHtml;
    private String dsvColDelim;
    private String dsvColSplitter;
    private String dsvRowDelim;
    private String dsvRowSplitter;
    private String dsvConstCols;
    private String dsvSkipPrefix;
    private String dsvSkipCols;
    private String dsvTargetFile;
    private String dsvTargetTable;
    private String dsvRejectFile;
    private String dsvRejectReport;
    private String topHtmlFile;
    private String bottomHtmlFile;
    private SimpleDateFormat timestampFormat;
    private static Pattern varPattern;
    private static Pattern wordAndDotPattern;
    private static Pattern specialPattern;
    private static Pattern plPattern;
    private static Pattern mathAsgnPattern;
    private static Pattern mathPattern;
    private static Pattern foreachPattern;
    private static Pattern forrowsPattern;
    private static Pattern forPattern;
    private static Pattern ifwhilePattern;
    private static Pattern inlineifPattern;
    private static Pattern varsetPattern;
    private static Pattern substitutionPattern;
    private static Pattern slashHistoryPattern;
    private static Pattern historyPattern;
    private static Pattern wincmdPattern;
    private static Pattern useMacroPattern;
    private static Pattern useFnPattern;
    private static Pattern legacyEditMacroPattern;
    private static Pattern editMacroPattern;
    private static Pattern spMacroPattern;
    private static Pattern sqlMacroPattern;
    private static Pattern integerPattern;
    private static Pattern nameValPairPattern;
    private static Pattern dotPattern;
    private static Pattern commitOccursPattern;
    private static Pattern logPattern;
    private static Pattern arrayPattern;
    private static Pattern fnParamPat;
    private static Map<String, Pattern> nestingPLCommands;
    private static Map<String, Pattern> inlineNestPLCommands;
    private SharedFields shared;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String revString = "$Revision: 5244 $";
    private static final int revStringLength;
    private static final String revnum;
    private static String DSV_OPTIONS_TEXT;
    private static String D_OPTIONS_TEXT;
    private Recursion recursed;
    private PrintWriter pwQuery;
    private PrintWriter pwDsv;
    private boolean continueOnError;
    private SqlFileScanner scanner;
    private Token buffer;
    private Token prevToken;
    private boolean preempt;
    private String lastSqlStatement;
    private boolean autoClose = true;
    private boolean csvStyleQuoting;
    private static final char[] nonVarChars;
    private Boolean sqlExpandMode;
    private String fetchingVar;
    private boolean silentFetch;
    private boolean fetchBinary;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_NULL_HTML = "&Oslash;";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_ROW_SPLITTER = "\\r\\n|\\r|\\n";
    private static final String DEFAULT_COL_DELIM = "|";
    private static final String DEFAULT_COL_SPLITTER = "\\|";
    private static final String DEFAULT_SKIP_PREFIX = "#";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR = "    ";
    private static final String PRE_TD = "        ";
    int oldestHist = 1;
    byte[] binBuffer;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    private boolean removeEmptyVars() {
        String string = System.getProperty("sqltool.REMOVE_EMPTY_VARS");
        return string != null && Boolean.parseBoolean(string);
    }

    private void updateUserSettings() {
        if (this.shared.userVars.containsKey("NULL") || this.shared.userVars.containsKey("*NULL")) {
            this.errprintln(SqltoolRB.null_assignment.getString());
            this.shared.userVars.remove("NULL");
            this.shared.userVars.remove("*NULL");
        }
        for (String string : new String[]{"DSV_SKIP_COLS", "DSV_COL_DELIM", "TIMESTAMP_FORMAT", "DSV_COL_SPLITTER", "DSV_ROW_DELIM", "DSV_ROW_SPLITTER", "DSV_TARGET_FILE", "DSV_TARGET_TABLE", "DSV_CONST_COLS", "DSV_REJECT_FILE", "DSV_REJECT_REPORT", "DSV_RECORDS_PER_COMMIT"}) {
            String string2 = this.shared.userVars.get('*' + string);
            if (string2 == null || string2.length() > 0) continue;
            if (!this.removeEmptyVars()) {
                this.errprintln(SqltoolRB.auto_unset_warning.getString(string));
            }
            this.shared.userVars.remove('*' + string);
        }
        this.dsvSkipPrefix = SqlFile.convertEscapes(this.shared.userVars.get("*DSV_SKIP_PREFIX"));
        if (this.dsvSkipPrefix == null) {
            this.dsvSkipPrefix = DEFAULT_SKIP_PREFIX;
        } else if (this.dsvSkipPrefix.length() < 1) {
            this.dsvSkipPrefix = null;
        }
        this.dsvSkipCols = this.shared.userVars.get("*DSV_SKIP_COLS");
        this.dsvTrimAll = Boolean.parseBoolean(this.shared.userVars.get("*DSV_TRIM_ALL"));
        this.ignoreBangStatus = Boolean.parseBoolean(this.shared.userVars.get("*IGNORE_BANG_STATUS"));
        this.allQuoted = Boolean.parseBoolean(this.shared.userVars.get("*ALL_QUOTED"));
        this.dsvColDelim = SqlFile.convertEscapes(this.shared.userVars.get("*DSV_COL_DELIM"));
        if (this.dsvColDelim == null) {
            this.dsvColDelim = DEFAULT_COL_DELIM;
        }
        this.dsvColSplitter = this.shared.userVars.get("*DSV_COL_SPLITTER");
        if (this.dsvColSplitter == null) {
            this.dsvColSplitter = DEFAULT_COL_SPLITTER;
        }
        this.dsvRowDelim = SqlFile.convertEscapes(this.shared.userVars.get("*DSV_ROW_DELIM"));
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = DEFAULT_ROW_DELIM;
        }
        this.dsvRowSplitter = this.shared.userVars.get("*DSV_ROW_SPLITTER");
        if (this.dsvRowSplitter == null) {
            this.dsvRowSplitter = DEFAULT_ROW_SPLITTER;
        }
        this.dsvTargetFile = this.shared.userVars.get("*DSV_TARGET_FILE");
        this.dsvTargetTable = this.shared.userVars.get("*DSV_TARGET_TABLE");
        this.dsvConstCols = this.shared.userVars.get("*DSV_CONST_COLS");
        this.dsvRejectFile = this.shared.userVars.get("*DSV_REJECT_FILE");
        this.dsvRejectReport = this.shared.userVars.get("*DSV_REJECT_REPORT");
        this.topHtmlFile = this.shared.userVars.get("*TOP_HTMLFRAG_FILE");
        this.bottomHtmlFile = this.shared.userVars.get("*BOTTOM_HTMLFRAG_FILE");
        this.dsvRecordsPerCommit = 0;
        if (this.shared.userVars.get("*DSV_RECORDS_PER_COMMIT") != null) {
            try {
                this.dsvRecordsPerCommit = Integer.parseInt(this.shared.userVars.get("*DSV_RECORDS_PER_COMMIT"));
            }
            catch (NumberFormatException numberFormatException) {
                this.errprintln(SqltoolRB.reject_rpc.getString(this.shared.userVars.get("*DSV_RECORDS_PER_COMMIT")));
                this.shared.userVars.remove("*DSV_RECORDS_PER_COMMIT");
            }
        }
        this.nullRepToken = SqlFile.convertEscapes(this.shared.userVars.get("*NULL_REP_TOKEN"));
        if (this.nullRepToken == null) {
            this.nullRepToken = DEFAULT_NULL_REP;
        }
        this.nullRepHtml = this.shared.userVars.get("*NULL_REP_HTML");
        if (this.nullRepHtml == null) {
            this.nullRepHtml = DEFAULT_NULL_HTML;
        }
        this.timestampFormat = null;
        String string = this.shared.userVars.get("*TIMESTAMP_FORMAT");
        if (string != null) {
            try {
                this.timestampFormat = new SimpleDateFormat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errprintln(SqltoolRB.bad_time_format.getString(string, illegalArgumentException.getMessage()));
                this.shared.userVars.remove("*TIMESTAMP_FORMAT");
            }
        }
    }

    public SqlFile(File file) throws IOException {
        this(file, null);
    }

    public SqlFile(File file, String string) throws IOException {
        this(file, string, false);
    }

    public SqlFile(File file, String string, boolean bl) throws IOException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), string == null ? DEFAULT_FILE_ENCODING : string), file.toString(), System.out, string, bl, file.getParentFile());
    }

    public SqlFile(String string, boolean bl) throws IOException {
        this(string == null ? new InputStreamReader(System.in) : new InputStreamReader(System.in, string), "<stdin>", System.out, string, bl, null);
    }

    public SqlFile(Reader reader, String string, PrintStream printStream, String string2, boolean bl, File file) throws IOException {
        this(reader, string, file);
        try {
            this.shared = new SharedFields(printStream);
            this.shared.userVars.put("*START_TIME", new Date().toString());
            this.shared.userVars.put("*REVISION", revnum);
            this.shared.userVars.put("?", "");
            this.setEncoding(string2);
            this.continueOnError = this.interactive = bl;
            if (bl) {
                this.history = new TokenList();
                this.maxHistoryLength = 40;
            }
        }
        catch (IOException iOException) {
            this.closeReader();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.closeReader();
            throw runtimeException;
        }
    }

    private SqlFile(SqlFile sqlFile, File file) throws IOException {
        this(sqlFile, new InputStreamReader((InputStream)new FileInputStream(file), sqlFile.shared.encoding == null ? DEFAULT_FILE_ENCODING : sqlFile.shared.encoding), file.toString(), file.getParentFile());
    }

    private SqlFile(SqlFile sqlFile, Reader reader, String string, File file) {
        this(reader, string, file);
        try {
            this.recursed = Recursion.FILE;
            this.shared = sqlFile.shared;
            this.interactive = false;
            this.continueOnError = sqlFile.continueOnError;
        }
        catch (RuntimeException runtimeException) {
            this.closeReader();
            throw runtimeException;
        }
    }

    private SqlFile(Reader reader, String string, File file) {
        logger.privlog(Level.FINER, "<init>ting SqlFile instance", null, 2, FrameworkLogger.class);
        if (reader == null) {
            throw new IllegalArgumentException("'reader' may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("'inputStreamLabel' may not be null");
        }
        this.reader = reader;
        this.inputStreamLabel = string;
        this.baseDir = file == null ? new File(".") : file;
    }

    public void setConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("We don't yet support unsetting the JDBC Connection");
        }
        this.shared.jdbcConn = connection;
    }

    public Connection getConnection() {
        return this.shared.jdbcConn;
    }

    public void setContinueOnError(boolean bl) {
        this.continueOnError = bl;
    }

    public void setMaxHistoryLength(int n) {
        if (this.executing) {
            throw new IllegalStateException("Can't set maxHistoryLength after execute() has been called");
        }
        if (this.reader == null) {
            throw new IllegalStateException("Can't set maxHistoryLength execute() has run");
        }
        this.maxHistoryLength = n;
    }

    public void addMacros(Map<String, Token> map) {
        this.shared.macros.putAll(map);
    }

    public void addUserVars(Map<String, String> map) {
        for (String object : map.values()) {
            if (object != null) continue;
            throw new IllegalArgumentException("Null mapping values not allowed");
        }
        this.shared.userVars.putAll(map);
        ArrayList arrayList = new ArrayList();
        for (String string : map.keySet()) {
            if (string.equals("?") || varPattern.matcher(string).matches()) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            this.errprintln(SqltoolRB.varname_warning.getString(((Object)arrayList).toString()));
        }
        this.sqlExpandMode = null;
    }

    public Map<String, String> getUserVars() {
        return this.shared.userVars;
    }

    public Map<String, Token> getMacros() {
        return this.shared.macros;
    }

    private void setEncoding(String string) throws UnsupportedEncodingException {
        if (string == null || string.length() < 1) {
            this.shared.encoding = null;
            this.shared.userVars.remove("*ENCODING");
            return;
        }
        if (!Charset.isSupported(string)) {
            throw new UnsupportedEncodingException(string);
        }
        this.shared.userVars.put("*ENCODING", string);
        this.shared.encoding = string;
    }

    public void setAutoClose(boolean bl) {
        this.autoClose = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute() throws SqlToolError, SQLException {
        if (this.reader == null) {
            throw new IllegalStateException("Can't call execute() more than once for a single SqlFile instance");
        }
        this.updateUserSettings();
        try {
            this.scanner = new SqlFileScanner(this.reader);
            this.scanner.setStdPrintStream(this.shared.psStd);
            this.scanner.setRawLeadinPrompt(SqltoolRB.raw_leadin.getString());
            if (this.interactive) {
                this.stdprintln(SqltoolRB.SqlFile_banner.getString(revnum));
                this.scanner.setRawPrompt(rawPrompt);
                this.scanner.setSqlPrompt(this.contPrompt);
                this.scanner.setSqltoolPrompt(this.primaryPrompt);
                this.scanner.setInteractive(true);
                if (this.shared.jdbcConn == null) {
                    this.stdprintln(SqltoolRB.suggest_j.getString());
                }
                this.stdprint(this.primaryPrompt);
            }
            this.scanpass(this.scanner);
        }
        finally {
            try {
                this.closeQueryOutputStream();
                if (this.autoClose) {
                    this.closeReader();
                }
            }
            finally {
                this.reader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReader() {
        if (this.reader == null) {
            return;
        }
        try {
            if (this.scanner != null) {
                try {
                    this.scanner.yyclose();
                }
                catch (IOException iOException) {
                    this.errprintln(SqltoolRB.pipeclose_failure.getString(iOException));
                }
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.reader = null;
        }
    }

    private Matcher inlineNestMatcher(Token token) throws BadSpecial {
        if (token.type != 2) {
            return null;
        }
        String string = token.val.replaceFirst("\\s.*", "");
        if (!inlineNestPLCommands.containsKey(string)) {
            return null;
        }
        Pattern pattern = inlineNestPLCommands.get(string);
        Matcher matcher = pattern.matcher(token.val);
        return matcher.matches() ? matcher : null;
    }

    private String nestingCommand(Token token) throws BadSpecial {
        if (token.type != 2) {
            return null;
        }
        String string = token.val.replaceFirst("\\s.*", "");
        if (!nestingPLCommands.containsKey(string)) {
            return null;
        }
        Pattern pattern = nestingPLCommands.get(string);
        if (pattern.matcher(token.val).matches()) {
            return string;
        }
        throw new BadSpecial(SqltoolRB.pl_malformat.getString());
    }

    private void setSqlExpandMode() {
        for (String string : this.shared.userVars.keySet()) {
            if (string.charAt(0) == '*' || string.equals("?")) continue;
            this.sqlExpandMode = Boolean.TRUE;
            return;
        }
        this.sqlExpandMode = Boolean.FALSE;
    }

    /*
     * Exception decompiling
     */
    protected synchronized void scanpass(TokenSource var1_1) throws SqlToolError, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [37[UNCONDITIONALDOLOOP]], but top level block is 31[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBuffHist(Token token) throws BadSpecial, SQLException, SqlToolError {
        if (token.val.length() < 1) {
            throw new BadSpecial(SqltoolRB.bufhist_unspecified.getString());
        }
        char c = token.val.charAt(0);
        String string = token.val.substring(1);
        if (string.trim().length() == 0) {
            string = null;
        }
        switch (c) {
            case 'b': 
            case 'l': {
                if (string != null) {
                    throw new BadSpecial(SqltoolRB.special_extrachars.getString("l", string));
                }
                if (this.buffer == null) {
                    this.stdprintln(nobufferYetString);
                } else {
                    this.stdprintln(SqltoolRB.editbuffer_contents.getString(this.buffer.reconstitute()));
                }
                return;
            }
            case 'h': {
                if (string != null) {
                    throw new BadSpecial(SqltoolRB.special_extrachars.getString("h", string));
                }
                this.showHistory();
                return;
            }
            case '?': {
                this.stdprintln(SqltoolRB.buffer_help.getString());
                return;
            }
        }
        Integer n = null;
        Matcher matcher = slashHistoryPattern.matcher(token.val);
        if (matcher.matches()) {
            n = this.historySearch(matcher.group(1));
            if (n == null) {
                this.stdprintln(SqltoolRB.substitution_nomatch.getString());
                return;
            }
        } else {
            matcher = historyPattern.matcher(token.val);
            if (!matcher.matches()) {
                throw new BadSpecial(SqltoolRB.edit_malformat.getString());
            }
            Integer n2 = n = matcher.group(1) == null || matcher.group(1).length() < 1 ? null : Integer.valueOf(matcher.group(1));
        }
        if (matcher.groupCount() != 2) {
            throw new BadSpecial(SqltoolRB.edit_malformat.getString());
        }
        c = matcher.group(2) == null || matcher.group(2).length() < 1 ? (char)'\u0000' : matcher.group(2).charAt(0);
        String string2 = string = c == '\u0000' ? null : matcher.group(2).substring(1);
        if (string != null && string.trim().length() < 1) {
            string = null;
        }
        Token token2 = n == null ? null : this.commandFromHistory(n);
        switch (c) {
            case '\u0000': {
                this.setBuf(token2);
                this.stdprintln(SqltoolRB.buffer_restored.getString(this.buffer.reconstitute()));
                return;
            }
            case ';': {
                if (string != null) {
                    throw new BadSpecial(SqltoolRB.special_extrachars.getString(";", string));
                }
                if (token2 != null) {
                    this.setBuf(token2);
                }
                if (this.buffer == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                this.stdprintln(SqltoolRB.buffer_executing.getString(this.buffer.reconstitute()));
                this.preempt = true;
                return;
            }
            case 'a': {
                if (token2 == null) {
                    token2 = this.buffer;
                }
                if (token2 == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                boolean bl = false;
                if (string != null && string.trim().charAt(string.trim().length() - 1) == ';') {
                    if ((string = string.substring(0, string.lastIndexOf(59))).trim().length() < 1) {
                        throw new BadSpecial(SqltoolRB.append_empty.getString());
                    }
                    bl = true;
                }
                Token token3 = new Token(token2.type, token2.val, token2.line);
                if (string != null) {
                    token3.val = token3.val + string;
                }
                this.setBuf(token3);
                if (bl) {
                    this.stdprintln(SqltoolRB.buffer_executing.getString(this.buffer.reconstitute()));
                    this.preempt = true;
                    return;
                }
                if (this.interactive) {
                    this.scanner.setMagicPrefix(token3.reconstitute());
                }
                switch (token3.type) {
                    case 0: {
                        this.scanner.setRequestedState(2);
                        break;
                    }
                    case 1: {
                        this.scanner.setRequestedState(12);
                        break;
                    }
                    case 2: {
                        this.scanner.setRequestedState(14);
                        break;
                    }
                    default: {
                        assert (false) : "Internal assertion failed.  Appending to unexpected type: " + token3.getTypeString();
                        break;
                    }
                }
                this.scanner.setCommandBuffer(token3.val);
                return;
            }
            case 'w': {
                if (token2 == null) {
                    token2 = this.buffer;
                }
                if (token2 == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                if (string == null) {
                    throw new BadSpecial(SqltoolRB.destfile_demand.getString());
                }
                String string3 = this.dereferenceAt(this.dereference(string.trim(), false));
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3, true), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                    printWriter.println(token2.reconstitute(true));
                    printWriter.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.file_appendfail.getString(string3), exception);
                }
                finally {
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        finally {
                            printWriter = null;
                        }
                    }
                }
                return;
            }
            case 's': {
                boolean bl = false;
                boolean bl2 = false;
                if (token2 == null) {
                    token2 = this.buffer;
                }
                if (token2 == null) {
                    throw new BadSpecial(SqltoolRB.nobuffer_yet.getString());
                }
                try {
                    String string4;
                    if (string == null || string.length() < 3) {
                        throw new BadSubst(SqltoolRB.substitution_malformat.getString());
                    }
                    Matcher matcher2 = substitutionPattern.matcher(string);
                    if (!matcher2.matches()) {
                        throw new BadSubst(SqltoolRB.substitution_malformat.getString());
                    }
                    assert (matcher2.groupCount() > 2 && matcher2.groupCount() < 5) : "Internal assertion failed.  Matched substitution pattern, but captured " + matcher2.groupCount() + " groups";
                    String string5 = string4 = matcher2.groupCount() > 3 && matcher2.group(4) != null ? new String(matcher2.group(4)) : null;
                    if (string4 != null) {
                        if (string4.indexOf(59) > -1) {
                            bl = true;
                            string4 = string4.replaceFirst(";", "");
                        }
                        if (string4.indexOf(103) > -1) {
                            bl2 = true;
                            string4 = string4.replaceFirst("g", "");
                        }
                    }
                    Matcher matcher3 = Pattern.compile("(?s" + (string4 == null ? "" : string4) + ')' + matcher2.group(2)).matcher(token2.val);
                    Token token4 = new Token(token2.type, bl2 ? matcher3.replaceAll(matcher2.group(3)) : matcher3.replaceFirst(matcher2.group(3)), token2.line);
                    if (token4.val.equals(token2.val)) {
                        this.stdprintln(SqltoolRB.substitution_nomatch.getString());
                        return;
                    }
                    this.setBuf(token4);
                    this.stdprintln(bl ? SqltoolRB.buffer_executing.getString(this.buffer.reconstitute()) : SqltoolRB.editbuffer_contents.getString(this.buffer.reconstitute()));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new BadSpecial(SqltoolRB.substitution_syntax.getString(), patternSyntaxException);
                }
                catch (BadSubst badSubst) {
                    throw new BadSpecial(SqltoolRB.substitution_syntax.getString());
                }
                if (bl) {
                    this.preempt = true;
                }
                return;
            }
        }
        throw new BadSpecial(SqltoolRB.buffer_unknown.getString(Character.toString(c)));
    }

    private void enforce1charSpecial(String string, char c) throws BadSpecial {
        if (string.length() != 1) {
            throw new BadSpecial(SqltoolRB.special_extrachars.getString(Character.toString(c), string.substring(1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSpecial(String string) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        String string2;
        String string3 = string2 = string == null ? this.buffer.val : string;
        if (string2.length() < 1) {
            throw new BadSpecial(SqltoolRB.special_unspecified.getString());
        }
        Matcher matcher = specialPattern.matcher(this.dereference(string2, false));
        if (!matcher.matches()) {
            throw new BadSpecial(SqltoolRB.special_malformat.getString());
        }
        assert (matcher.groupCount() > 0 && matcher.groupCount() < 3) : "Internal assertion failed.  Pattern matched, yet captured " + matcher.groupCount() + " groups";
        String string4 = matcher.group(1);
        String string5 = matcher.groupCount() > 1 ? matcher.group(2) : null;
        switch (string4.charAt(0)) {
            case 'q': {
                this.enforce1charSpecial(string4, 'q');
                if (string5 != null) {
                    throw new QuitNow(string5.trim());
                }
                throw new QuitNow();
            }
            case 'H': 
            case 'h': {
                this.enforce1charSpecial(string4, 'h');
                this.htmlMode = string5 == null ? !this.htmlMode : Boolean.parseBoolean(string5.trim());
                this.shared.psStd.println(SqltoolRB.html_mode.getString(Boolean.toString(this.htmlMode)));
                return;
            }
            case 'm': {
                if (string4.equals("m?") || string4.equals("mq?") || string5 != null && string5.trim().equals("?") && (string4.equals("m") || string4.equals("mq"))) {
                    this.stdprintln(DSV_OPTIONS_TEXT + LS + DSV_M_SYNTAX_MSG);
                    return;
                }
                this.shared.userVars.remove("?");
                this.requireConnection();
                if (!string4.equals("mq") && string4.length() != 1 || string5 == null) {
                    throw new BadSpecial(DSV_M_SYNTAX_MSG);
                }
                string5 = string5.trim();
                String string6 = this.dsvSkipPrefix;
                if (string5.charAt(string5.length() - 1) == '*') {
                    if ((string5 = string5.substring(0, string5.length() - 1).trim()).length() < 1) {
                        throw new BadSpecial(DSV_M_SYNTAX_MSG);
                    }
                    string6 = null;
                }
                this.csvStyleQuoting = string4.equals("mq");
                try {
                    this.importDsv(this.dereferenceAt(string5), string6);
                }
                finally {
                    this.csvStyleQuoting = false;
                }
                this.shared.userVars.put("?", "");
                return;
            }
            case 'x': {
                if (string4.equals("x?") || string4.equals("xq?") || string5 != null && string5.trim().equals("?") && (string4.equals("x") || string4.equals("xq"))) {
                    this.stdprintln(DSV_OPTIONS_TEXT + LS + DSV_X_SYNTAX_MSG);
                    return;
                }
                this.shared.userVars.remove("?");
                this.requireConnection();
                try {
                    if (!string4.equals("xq") && string4.length() != 1 || string5 == null) {
                        throw new BadSpecial(DSV_X_SYNTAX_MSG);
                    }
                    String string7 = null;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (string5.trim().charAt(0) == ':') {
                        if (this.prevToken == null) {
                            throw new BadSpecial(nobufferYetString);
                        }
                        stringBuilder.append(this.prevToken.val).append(string5.substring(string5.indexOf(58) + 1));
                    } else if (wordAndDotPattern.matcher(string5.trim()).matches()) {
                        string7 = string5.trim();
                        stringBuilder.append("SELECT * FROM ").append(string7);
                    } else {
                        stringBuilder.append(string5.trim());
                    }
                    if (this.dsvTargetFile == null && string7 == null) {
                        throw new BadSpecial(SqltoolRB.dsv_targetfile_demand.getString());
                    }
                    ResultSet resultSet = null;
                    Statement statement = null;
                    File file = null;
                    this.csvStyleQuoting = string4.equals("xq");
                    try {
                        file = new File(this.dsvTargetFile == null ? string7 + (this.csvStyleQuoting ? ".csv" : ".dsv") : this.dereferenceAt(this.dsvTargetFile));
                        this.pwDsv = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                        statement = this.shared.jdbcConn.createStatement();
                        resultSet = statement.executeQuery(stringBuilder.toString());
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        int[] nArray = null;
                        if (this.dsvSkipCols != null) {
                            int n;
                            HashSet<String> hashSet = new HashSet<String>();
                            for (String string8 : this.dsvSkipCols.split("\\Q" + this.dsvColDelim, -1)) {
                                hashSet.add(string8.trim().toLowerCase());
                            }
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                                if (hashSet.remove(resultSetMetaData.getColumnName(n).toLowerCase())) continue;
                                arrayList.add(n);
                            }
                            if (arrayList.size() < 1) {
                                throw new BadSpecial(SqltoolRB.dsv_nocolsleft.getString(this.dsvSkipCols));
                            }
                            if (hashSet.size() > 0) {
                                throw new BadSpecial(SqltoolRB.dsv_skipcols_missing.getString(((Object)hashSet).toString()));
                            }
                            nArray = new int[arrayList.size()];
                            for (n = 0; n < nArray.length; ++n) {
                                nArray[n] = (Integer)arrayList.get(n);
                            }
                        }
                        this.displaySqlResults(statement, resultSet, nArray, null, true);
                    }
                    finally {
                        this.csvStyleQuoting = false;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {
                            }
                            finally {
                                resultSet = null;
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {
                            }
                            finally {
                                statement = null;
                            }
                        }
                    }
                    this.pwDsv.flush();
                    this.stdprintln(SqltoolRB.file_wrotechars.getString(Long.toString(file.length()), file.toString()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new BadSpecial(SqltoolRB.file_writefail.getString(string5), fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new BadSpecial(SqltoolRB.file_writefail.getString(string5), unsupportedEncodingException);
                }
                finally {
                    if (this.pwDsv != null) {
                        try {
                            this.pwDsv.close();
                        }
                        finally {
                            this.pwDsv = null;
                        }
                    }
                }
                return;
            }
            case 'd': {
                if (string4.equals("d?") || string4.equals("d") && string5 != null && string5.trim().equals("?")) {
                    this.stdprintln(D_OPTIONS_TEXT);
                    return;
                }
                this.requireConnection();
                if (string4.length() == 2) {
                    this.listTables(string4.charAt(1), string5 == null ? null : string5.trim());
                    return;
                }
                if (string4.length() == 1 && string5 != null) {
                    try {
                        string5 = string5.trim();
                        int n = string5.indexOf(32);
                        if (n < 0) {
                            this.describe(string5, null);
                        } else {
                            this.describe(string5.substring(0, n), string5.substring(n + 1).trim());
                        }
                        return;
                    }
                    catch (SQLException sQLException) {
                        throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString(), sQLException);
                    }
                }
                throw new BadSpecial(SqltoolRB.special_d_like.getString());
            }
            case 'o': {
                boolean bl = string4.equals("oc");
                if (bl) {
                    string4 = "o";
                }
                this.enforce1charSpecial(string4, 'o');
                if (string5 == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial(SqltoolRB.outputfile_nonetoclose.getString());
                    }
                    if (bl) {
                        this.writeFooter(this.pwQuery, "(the HTML report file)");
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                string5 = string5.trim();
                if (this.pwQuery != null) {
                    this.shared.psStd.println(SqltoolRB.outputfile_reopening.getString());
                    this.closeQueryOutputStream();
                }
                String string9 = this.dereferenceAt(string5);
                boolean bl2 = new File(string9).exists();
                try {
                    this.pwQuery = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string9, true), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding));
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.file_writefail.getString(string9), exception);
                }
                if (this.htmlMode && !bl2) {
                    this.writeHeader(this.pwQuery, string9);
                }
                this.pwQuery.flush();
                return;
            }
            case 'i': {
                this.enforce1charSpecial(string4, 'i');
                if (string5 == null) {
                    throw new BadSpecial(SqltoolRB.sqlfile_name_demand.getString());
                }
                string5 = string5.trim();
                this.sqlExpandMode = null;
                try {
                    new SqlFile(this, new File(this.dereferenceAt(string5))).execute();
                }
                catch (ContinueException continueException) {
                    throw continueException;
                }
                catch (BreakException breakException) {
                    String string10 = breakException.getMessage();
                    if (string10 != null && !string10.equals("file")) {
                        throw breakException;
                    }
                }
                catch (QuitNow quitNow) {
                    throw quitNow;
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.sqlfile_execute_fail.getString(string5), exception);
                }
                this.updateUserSettings();
                return;
            }
            case 'p': {
                if (string4.equals("pr")) {
                    if (string5 == null) {
                        if (this.shared.psStd != null) {
                            this.shared.psStd.println();
                        }
                        if (this.pwQuery != null) {
                            this.pwQuery.println();
                            this.pwQuery.flush();
                        }
                    } else {
                        this.shared.psStd.println(string5);
                        if (this.pwQuery != null) {
                            this.pwQuery.println(string5);
                            this.pwQuery.flush();
                        }
                    }
                    return;
                }
                this.enforce1charSpecial(string4, 'p');
                if (string5 == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(string5.trim(), true);
                }
                return;
            }
            case 'l': {
                if (string4.equals("l?") && string5 == null || string4.equals("l") && string5 != null && string5.equals("?")) {
                    this.stdprintln(SqltoolRB.log_syntax.getString());
                } else {
                    Matcher matcher2;
                    this.enforce1charSpecial(string4, 'l');
                    Matcher matcher3 = matcher2 = string5 == null ? null : logPattern.matcher(string5.trim());
                    if (matcher2 == null || !matcher2.matches()) {
                        throw new BadSpecial(SqltoolRB.log_syntax_error.getString());
                    }
                    String string11 = matcher2.group(1);
                    Level level = null;
                    if (string11.equalsIgnoreCase("FINER")) {
                        level = Level.FINER;
                    } else if (string11.equalsIgnoreCase("WARNING")) {
                        level = Level.WARNING;
                    } else if (string11.equalsIgnoreCase("SEVERE")) {
                        level = Level.SEVERE;
                    } else if (string11.equalsIgnoreCase("INFO")) {
                        level = Level.INFO;
                    } else if (string11.equalsIgnoreCase("FINEST")) {
                        level = Level.FINEST;
                    }
                    assert (level != null) : "Internal assertion failed.   Unexpected Level string: " + string11;
                    logger.enduserlog(level, matcher2.group(2));
                }
                return;
            }
            case 'a': {
                this.requireConnection();
                this.enforce1charSpecial(string4, 'a');
                if (string5 != null) {
                    string5 = string5.trim();
                    this.shared.jdbcConn.setAutoCommit(Boolean.parseBoolean(string5));
                    this.shared.possiblyUncommitteds = false;
                }
                this.stdprintln(SqltoolRB.a_setting.getString(Boolean.toString(this.shared.jdbcConn.getAutoCommit())));
                return;
            }
            case 'j': {
                try {
                    this.enforce1charSpecial(string4, 'j');
                    String string12 = null;
                    String string13 = null;
                    String string14 = null;
                    String string15 = null;
                    boolean bl = false;
                    String[] stringArray = string5 == null ? new String[]{} : string5.trim().split("\\s+", 3);
                    switch (stringArray.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            string12 = stringArray[0];
                            break;
                        }
                        case 2: {
                            string13 = stringArray[0];
                            string14 = "";
                            string15 = stringArray[1];
                            break;
                        }
                        case 3: {
                            string13 = stringArray[0];
                            string14 = stringArray[1];
                            string15 = stringArray[2];
                        }
                    }
                    if (stringArray.length > 0 && this.shared.jdbcConn != null) {
                        try {
                            bl = this.shared.jdbcConn.getAutoCommit();
                            this.shared.jdbcConn.close();
                            this.shared.possiblyUncommitteds = false;
                            this.shared.jdbcConn = null;
                            this.stdprintln(SqltoolRB.disconnect_success.getString());
                        }
                        catch (SQLException sQLException) {
                            throw new BadSpecial(SqltoolRB.disconnect_failure.getString(), sQLException);
                        }
                    }
                    if (string12 != null || string13 != null) {
                        try {
                            if (string12 != null) {
                                this.shared.jdbcConn = new RCData(new File(SqlTool.DEFAULT_RCFILE), string12).getConnection();
                            } else if (string13 != null) {
                                this.shared.jdbcConn = DriverManager.getConnection(string15, string13, string14);
                            }
                            this.shared.possiblyUncommitteds = false;
                            this.shared.jdbcConn.setAutoCommit(bl);
                        }
                        catch (Exception exception) {
                            throw new BadSpecial(SqltoolRB.connect_failure.getString(), exception);
                        }
                    }
                    this.displayConnBanner();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return;
                }
                return;
            }
            case 'v': {
                this.requireConnection();
                this.enforce1charSpecial(string4, 'v');
                if (string5 != null) {
                    if (integerPattern.matcher(string5 = string5.trim()).matches()) {
                        this.shared.jdbcConn.setTransactionIsolation(Integer.parseInt(string5));
                    } else {
                        RCData.setTI(this.shared.jdbcConn, string5);
                    }
                }
                this.stdprintln(SqltoolRB.transiso_report.getString(this.shared.jdbcConn.isReadOnly() ? "R/O " : "R/W ", RCData.tiToString(this.shared.jdbcConn.getTransactionIsolation())));
                return;
            }
            case '=': {
                this.requireConnection();
                this.enforce1charSpecial(string4, '=');
                this.shared.jdbcConn.commit();
                this.shared.possiblyUncommitteds = false;
                this.stdprintln(SqltoolRB.committed.getString());
                return;
            }
            case 'b': {
                if (string4.length() == 1) {
                    if (string5 != null) {
                        throw new BadSpecial(SqltoolRB.special_b_malformat.getString());
                    }
                    this.fetchBinary = true;
                    return;
                }
                if (string4.charAt(1) == 'p') {
                    if (string5 != null) {
                        throw new BadSpecial(SqltoolRB.special_b_malformat.getString());
                    }
                    this.doPrepare = true;
                    return;
                }
                if (string4.charAt(1) != 'd' && string4.charAt(1) != 'l' || string5 == null) {
                    throw new BadSpecial(SqltoolRB.special_b_malformat.getString());
                }
                string5 = string5.trim();
                File file = new File(this.dereferenceAt(string5));
                try {
                    if (string4.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.binBuffer = SqlFile.loadBinary(file);
                        this.stdprintln(SqltoolRB.binary_loadedbytesinto.getString(this.binBuffer.length));
                    }
                }
                catch (BadSpecial badSpecial) {
                    throw badSpecial;
                }
                catch (IOException iOException) {
                    throw new BadSpecial(SqltoolRB.binary_filefail.getString(string5), iOException);
                }
                return;
            }
            case 't': {
                this.enforce1charSpecial(string4, '=');
                if (string5 != null) {
                    this.reportTimes = Boolean.parseBoolean(string5.trim());
                }
                this.stdprintln(SqltoolRB.exectime_reporting.getString(Boolean.toString(this.reportTimes)));
                return;
            }
            case 'c': {
                this.enforce1charSpecial(string4, '=');
                if (string5 != null) {
                    this.continueOnError = Boolean.parseBoolean(string5.trim());
                }
                this.stdprintln(SqltoolRB.c_setting.getString(Boolean.toString(this.continueOnError)));
                return;
            }
            case '?': {
                this.stdprintln(SqltoolRB.special_help.getString());
                return;
            }
            case '!': {
                byte[] byArray = new byte[1024];
                String string16 = (string4.length() == 1 ? "" : string4.substring(1)) + (string4.length() > 1 && string5 != null ? " " : "") + (string5 == null ? "" : string5.trim());
                if (string16.trim().length() < 1) {
                    throw new BadSpecial(SqltoolRB.bang_incomplete.getString());
                }
                Process process = null;
                try {
                    int n;
                    Runtime runtime = Runtime.getRuntime();
                    process = wincmdPattern == null ? runtime.exec(string16) : runtime.exec(SqlFile.genWinArgs(string16));
                    process.getOutputStream().close();
                    InputStream inputStream = process.getInputStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.stdprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    inputStream = process.getErrorStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        String string17 = new String(byArray, 0, n);
                        if (string17.endsWith(LS)) {
                            if (string17.length() == LS.length()) continue;
                            string17 = string17.substring(0, string17.length() - LS.length());
                        }
                        logger.severe(string17);
                    }
                    inputStream.close();
                    inputStream = null;
                    if (process.waitFor() != 0 && !this.ignoreBangStatus) {
                        throw new BadSpecial(SqltoolRB.bang_command_fail.getString(string16));
                    }
                }
                catch (BadSpecial badSpecial) {
                    throw badSpecial;
                }
                catch (Exception exception) {
                    throw new BadSpecial(SqltoolRB.bang_command_fail.getString(string16), exception);
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
                return;
            }
        }
        throw new BadSpecial(SqltoolRB.special_unknown.getString(Character.toString(string4.charAt(0))));
    }

    static int pastName(String string, int n) {
        String string2 = string.substring(n);
        int n2 = string.length();
        for (char c : nonVarChars) {
            int n3 = string2.indexOf(c);
            if (n3 <= -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n + n2;
    }

    private String dereference(String string, boolean bl) throws SqlToolError {
        boolean bl2;
        String string2;
        int n;
        String string3;
        String string4;
        int n2;
        if (string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl && string.trim().charAt(0) == '/') {
            int n3 = string.indexOf(47);
            n2 = SqlFile.pastName(string.substring(n3 + 1), 0);
            if (n2 < 1) {
                throw new SqlToolError(SqltoolRB.plalias_malformat.getString());
            }
            string4 = string.substring(n3 + 1, n3 + 1 + n2);
            string3 = this.shared.userVars.get(string4);
            if (string3 == null) {
                throw new SqlToolError(SqltoolRB.plvar_undefined.getString(string4));
            }
            stringBuffer.replace(n3, n3 + 1 + n2, this.shared.userVars.get(string4));
        }
        int n4 = 0;
        while ((n = (string2 = stringBuffer.toString()).indexOf("${")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SqlToolError(SqltoolRB.sysprop_empty.getString());
            }
            if (n2 < 0) {
                throw new SqlToolError(SqltoolRB.sysprop_unterminated.getString());
            }
            bl2 = string2.charAt(n + 2) == ':';
            string4 = string2.substring(n + (bl2 ? 3 : 2), n2);
            if (n4++ > 10000) {
                throw new SqlToolError(SqltoolRB.var_infinite.getString(string4));
            }
            string3 = System.getProperty(string4);
            if (string3 == null) {
                if (bl2) {
                    string3 = "";
                } else {
                    throw new SqlToolError(SqltoolRB.sysprop_undefined.getString(string4));
                }
            }
            stringBuffer.replace(n, n2 + 1, string3);
        }
        n4 = 0;
        while ((n = (string2 = stringBuffer.toString()).indexOf("*{")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SqlToolError(SqltoolRB.plvar_nameempty.getString());
            }
            if (n2 < 0) {
                throw new SqlToolError(SqltoolRB.plvar_unterminated.getString());
            }
            bl2 = string2.charAt(n + 2) == ':';
            string4 = string2.substring(n + (bl2 ? 3 : 2), n2);
            if (n4++ > 100000) {
                throw new SqlToolError(SqltoolRB.var_infinite.getString(string4));
            }
            string3 = this.shared.userVars.get(string4);
            if (string3 == null) {
                if (string4.equals("*TIMESTAMP")) {
                    if (this.timestampFormat == null) {
                        throw new SqlToolError(SqltoolRB.no_timestamp_format.getString());
                    }
                    string3 = this.timestampFormat.format(new Date());
                } else {
                    if (!bl2) {
                        throw new SqlToolError(SqltoolRB.plvar_undefined.getString(string4));
                    }
                    string3 = "";
                }
            }
            stringBuffer.replace(n, n2 + 1, string3);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBlock(Token token) throws BadSpecial, SqlToolError, SQLException {
        Matcher matcher = plPattern.matcher(this.dereference(token.val, false));
        if (!matcher.matches()) {
            throw new BadSpecial(SqltoolRB.pl_malformat.getString());
        }
        if (matcher.groupCount() < 1 || matcher.group(1) == null) {
            this.stdprintln(SqltoolRB.deprecated_noop.getString("*"));
            return;
        }
        String[] stringArray = matcher.group(1).split("\\s+", -1);
        if (stringArray[0].equals("for")) {
            String string;
            Matcher matcher2 = forPattern.matcher(this.dereference(token.val, false));
            if (!matcher2.matches()) {
                throw new BadSpecial(SqltoolRB.pl_malformat_specific.getString("for"));
            }
            assert (matcher2.groupCount() == 2 || matcher2.groupCount() == 3) : "Internal assertion failed.  forh pattern matched, but captured " + matcher2.groupCount() + " groups";
            String string2 = matcher2.group(matcher2.groupCount());
            String string3 = matcher2.group(matcher2.groupCount() - 1);
            String string4 = string = matcher2.groupCount() < 3 || matcher2.group(1) == null || matcher2.group(1).trim().length() < 1 ? null : matcher2.group(1);
            if (string != null) {
                try {
                    Matcher matcher3 = mathAsgnPattern.matcher(string);
                    if (matcher3.matches()) {
                        this.shared.userVars.put(matcher3.group(1), Long.toString(Calculator.reassignValue(matcher3.group(1), this.shared.userVars, matcher3.group(2), matcher3.groupCount() < 3 ? null : matcher3.group(3))));
                    } else {
                        Matcher matcher4 = mathPattern.matcher(string);
                        if (matcher4.matches()) {
                            this.shared.userVars.put(matcher4.group(1), Long.toString(new Calculator(matcher4.groupCount() > 1 && matcher4.group(2) != null ? matcher4.group(2) : "", this.shared.userVars).reduce(0, false)));
                        }
                    }
                    this.sqlExpandMode = null;
                }
                catch (RuntimeException runtimeException) {
                    throw new BadSpecial(SqltoolRB.math_expr_fail.getString(runtimeException));
                }
            }
            String[] stringArray2 = string3.substring(1, string3.length() - 1).replaceAll("!([a-zA-Z0-9*])", "! $1").replaceAll("([a-zA-Z0-9*])!", "$1 !").split("\\s+", -1);
            try {
                while (this.eval(stringArray2)) {
                    Recursion recursion = this.recursed;
                    this.recursed = Recursion.FOR;
                    try {
                        this.scanpass(token.nestedBlock.dup());
                    }
                    catch (ContinueException continueException) {
                        String string5 = continueException.getMessage();
                        if (string5 != null && !string5.equals("for")) {
                            throw continueException;
                        }
                    }
                    finally {
                        this.recursed = recursion;
                    }
                    try {
                        Matcher matcher5 = mathAsgnPattern.matcher(string2);
                        if (matcher5.matches()) {
                            this.shared.userVars.put(matcher5.group(1), Long.toString(Calculator.reassignValue(matcher5.group(1), this.shared.userVars, matcher5.group(2), matcher5.groupCount() < 3 ? null : matcher5.group(3))));
                        } else {
                            matcher5 = mathPattern.matcher(string2);
                            if (matcher5.matches()) {
                                this.shared.userVars.put(matcher5.group(1), Long.toString(new Calculator(matcher5.groupCount() > 1 && matcher5.group(2) != null ? matcher5.group(2) : "", this.shared.userVars).reduce(0, false)));
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw new BadSpecial(SqltoolRB.math_expr_fail.getString(runtimeException));
                    }
                    this.sqlExpandMode = null;
                }
                return;
            }
            catch (BreakException breakException) {
                String string6 = breakException.getMessage();
                if (string6 == null || string6.equals("for")) return;
                throw breakException;
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
            }
            finally {
                this.updateUserSettings();
                this.sqlExpandMode = null;
            }
        }
        if (stringArray[0].equals("forrows")) {
            Object object;
            TokenList tokenList;
            String[] stringArray3;
            Matcher matcher6 = forrowsPattern.matcher(this.dereference(token.val, false));
            if (!matcher6.matches()) {
                throw new BadSpecial(SqltoolRB.pl_malformat_specific.getString("forrows"));
            }
            String[] stringArray4 = matcher6.groupCount() > 0 && matcher6.group(1) != null && matcher6.group(1).length() > 0 ? matcher6.group(1).trim().split("\\s+") : null;
            String[] stringArray5 = stringArray3 = stringArray4 == null ? null : new String[stringArray4.length];
            if (stringArray3 != null) {
                for (int i = 0; i < stringArray4.length; ++i) {
                    stringArray3[i] = this.shared.userVars.get(stringArray4[i]);
                }
            }
            if ((tokenList = token.nestedBlock.dup()).size() < 2) {
                throw new BadSpecial("Empty forrows loop");
            }
            Token token2 = (Token)tokenList.remove(0);
            if (token2.type != 0) {
                throw new BadSpecial("*forrows command not followed immediately by an SQL statement");
            }
            this.setBuf(token2);
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            Statement statement = this.processSQL();
            ResultSet resultSet = null;
            if (statement == null) {
                throw new BadSpecial("Failed to prepare SQL for loop");
            }
            int n = 0;
            try {
                resultSet = statement.getResultSet();
                object = resultSet.getMetaData();
                n = object.getColumnCount();
                if (stringArray4 != null && stringArray4.length > n) {
                    throw new BadSpecial("*forrows command specifies " + stringArray4.length + " variables, but query pulled only " + n + " columns");
                }
                if (n < 1) {
                    return;
                }
                while (resultSet.next()) {
                    String[] stringArray6 = new String[n];
                    arrayList.add(stringArray6);
                    for (int i = 1; i <= n; ++i) {
                        stringArray6[i - 1] = resultSet.getString(i);
                    }
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    resultSet = null;
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                }
                finally {
                    statement = null;
                }
            }
            this.lastSqlStatement = null;
            if (arrayList.size() > 0) {
                object = ((String[])arrayList.get(0))[0];
                String string = ((String[])arrayList.get(arrayList.size() - 1))[n - 1];
                this.shared.userVars.put("?", string == null ? this.nullRepToken : string);
                if (this.fetchingVar != null) {
                    if (object == null) {
                        this.shared.userVars.remove(this.fetchingVar);
                    } else {
                        this.shared.userVars.put(this.fetchingVar, (String)object);
                    }
                    this.updateUserSettings();
                    this.sqlExpandMode = null;
                    this.fetchingVar = null;
                }
            } else {
                this.shared.userVars.put("?", "");
            }
            object = new StringBuilder();
            try {
                for (String[] stringArray7 : arrayList) {
                    void var14_82;
                    if (stringArray7.length == 1) {
                        String string = stringArray7[0] == null ? this.nullRepToken : stringArray7[0];
                    } else {
                        ((StringBuilder)object).setLength(0);
                        for (String string : stringArray7) {
                            if (((StringBuilder)object).length() > 0) {
                                ((StringBuilder)object).append(this.dsvColDelim);
                            }
                            ((StringBuilder)object).append(string == null ? this.nullRepToken : string);
                        }
                        String string = ((StringBuilder)object).toString();
                    }
                    this.shared.userVars.put("*ROW", (String)var14_82);
                    if (stringArray4 != null) {
                        void var17_101;
                        boolean bl = false;
                        while (var17_101 < stringArray4.length) {
                            if (stringArray7[var17_101] == null) {
                                this.shared.userVars.remove(stringArray4[var17_101]);
                            } else {
                                this.shared.userVars.put(stringArray4[var17_101], stringArray7[var17_101]);
                            }
                            ++var17_101;
                        }
                    }
                    this.updateUserSettings();
                    Recursion recursion = this.recursed;
                    this.recursed = Recursion.FORROWS;
                    try {
                        this.scanpass(tokenList.dup());
                    }
                    catch (ContinueException continueException) {
                        String string = continueException.getMessage();
                        if (string == null || string.equals("forrows")) continue;
                        throw continueException;
                    }
                    finally {
                        this.recursed = recursion;
                    }
                }
                return;
            }
            catch (BreakException breakException) {
                String string = breakException.getMessage();
                if (string == null || string.equals("forrows")) return;
                throw breakException;
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
            }
            finally {
                this.shared.userVars.remove("*ROW");
                if (stringArray3 != null) {
                    for (int i = 1; i < stringArray3.length; ++i) {
                        if (stringArray3[i] == null) {
                            this.shared.userVars.remove(stringArray4[i]);
                            continue;
                        }
                        this.shared.userVars.put(stringArray4[i], stringArray3[i]);
                    }
                }
                this.updateUserSettings();
                this.sqlExpandMode = null;
            }
        }
        if (stringArray[0].equals("foreach")) {
            Matcher matcher7 = foreachPattern.matcher(this.dereference(token.val, false));
            if (!matcher7.matches()) {
                throw new BadSpecial(SqltoolRB.pl_malformat_specific.getString("foreach"));
            }
            if (matcher7.groupCount() != 2) assert (matcher7.groupCount() == 2) : "Internal assertion failed.  foreach pattern matched, but captured " + matcher7.groupCount() + " groups";
            String string = matcher7.group(1);
            if (string.indexOf(58) > -1) {
                throw new BadSpecial(SqltoolRB.plvar_nocolon.getString());
            }
            if (!varPattern.matcher(string).matches()) {
                this.errprintln(SqltoolRB.varname_warning.getString(string));
            }
            String[] stringArray8 = matcher7.group(2).split("\\s+", -1);
            String string7 = this.shared.userVars.get(string);
            try {
                for (String string8 : stringArray8) {
                    this.shared.userVars.put(string, string8);
                    this.updateUserSettings();
                    Recursion recursion = this.recursed;
                    this.recursed = Recursion.FOREACH;
                    try {
                        this.scanpass(token.nestedBlock.dup());
                    }
                    catch (ContinueException continueException) {
                        String string9 = continueException.getMessage();
                        if (string9 == null || string9.equals("foreach")) continue;
                        throw continueException;
                    }
                    finally {
                        this.recursed = recursion;
                    }
                }
                return;
            }
            catch (BreakException breakException) {
                String string10 = breakException.getMessage();
                if (string10 == null || string10.equals("foreach")) return;
                throw breakException;
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
            }
            finally {
                if (string7 == null) {
                    this.shared.userVars.remove(string);
                } else {
                    this.shared.userVars.put(string, string7);
                }
                this.updateUserSettings();
                this.sqlExpandMode = null;
            }
        }
        if (!stringArray[0].equals("if") && !stringArray[0].equals("while")) throw new BadSpecial(SqltoolRB.pl_unknown.getString(stringArray[0]));
        Matcher matcher8 = ifwhilePattern.matcher(this.dereference(token.val, false));
        if (!matcher8.matches()) {
            throw new BadSpecial(SqltoolRB.ifwhile_malformat.getString());
        }
        assert (matcher8.groupCount() == 1) : "Internal assertion failed.  if/while pattern matched, but captured " + matcher8.groupCount() + " groups";
        String[] stringArray9 = matcher8.group(1).replaceAll("!([a-zA-Z0-9*])", "! $1").replaceAll("([a-zA-Z0-9*])!", "$1 !").split("\\s+", -1);
        if (stringArray[0].equals("if")) {
            try {
                Token token3;
                Token token4;
                Token token5 = token4 = token.nestedBlock.size() < 1 ? null : (Token)token.nestedBlock.get(token.nestedBlock.size() - 1);
                if (!(token4 == null || token4.type == 2 && token4.val.equals("else"))) {
                    token4 = null;
                }
                Token token6 = token3 = this.eval(stringArray9) ? token : token4;
                if (token3 == null) return;
                Recursion recursion = this.recursed;
                this.recursed = Recursion.IF;
                try {
                    this.scanpass(token3.nestedBlock.dup());
                    return;
                }
                finally {
                    this.recursed = recursion;
                }
            }
            catch (BreakException breakException) {
                String string = breakException.getMessage();
                if (string != null && string.equals("if")) return;
                throw breakException;
            }
            catch (ContinueException continueException) {
                throw continueException;
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (BadSpecial badSpecial) {
                badSpecial.appendMessage(SqltoolRB.pl_malformat_specific.getString("if"));
                throw badSpecial;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
            }
        } else if (stringArray[0].equals("while")) {
            try {
                while (this.eval(stringArray9)) {
                    Recursion recursion = this.recursed;
                    this.recursed = Recursion.WHILE;
                    try {
                        this.scanpass(token.nestedBlock.dup());
                    }
                    catch (ContinueException continueException) {
                        String string = continueException.getMessage();
                        if (string == null || string.equals("while")) continue;
                        throw continueException;
                    }
                    finally {
                        this.recursed = recursion;
                    }
                }
                return;
            }
            catch (BreakException breakException) {
                String string = breakException.getMessage();
                if (string == null || string.equals("while")) return;
                throw breakException;
            }
            catch (QuitNow quitNow) {
                throw quitNow;
            }
            catch (BadSpecial badSpecial) {
                badSpecial.appendMessage(SqltoolRB.pl_malformat_specific.getString("while"));
                throw badSpecial;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BadSpecial(SqltoolRB.pl_block_fail.getString(), exception);
            }
        } else {
            assert (false) : SqltoolRB.pl_unknown.getString(stringArray[0]);
            return;
        }
    }

    private void processPL() throws BadSpecial, SqlToolError {
        String string = this.buffer.val;
        String string2 = this.dereference(string, false);
        Matcher matcher = mathAsgnPattern.matcher(string2);
        if (matcher.matches()) {
            try {
                this.shared.userVars.put(matcher.group(1), Long.toString(Calculator.reassignValue(matcher.group(1), this.shared.userVars, matcher.group(2), matcher.groupCount() < 3 ? null : matcher.group(3))));
                this.sqlExpandMode = null;
                return;
            }
            catch (RuntimeException runtimeException) {
                throw new BadSpecial(SqltoolRB.math_expr_fail.getString(runtimeException));
            }
        }
        matcher = mathPattern.matcher(string2);
        if (matcher.matches()) {
            try {
                this.shared.userVars.put(matcher.group(1), Long.toString(new Calculator(matcher.groupCount() > 1 && matcher.group(2) != null ? matcher.group(2) : "", this.shared.userVars).reduce(0, false)));
                this.sqlExpandMode = null;
                return;
            }
            catch (RuntimeException runtimeException) {
                throw new BadSpecial(SqltoolRB.math_expr_fail.getString(runtimeException));
            }
        }
        Matcher matcher2 = plPattern.matcher(string2);
        if (!matcher2.matches()) {
            throw new BadSpecial(SqltoolRB.pl_malformat.getString());
        }
        if (matcher2.groupCount() < 1 || matcher2.group(1) == null) {
            this.stdprintln(SqltoolRB.deprecated_noop.getString("*"));
            return;
        }
        String[] stringArray = matcher2.group(1).split("\\s+", -1);
        if (stringArray[0].charAt(0) == '?') {
            String string3 = stringArray[0].substring(1);
            String string4 = null;
            string4 = string3.startsWith("assign") || stringArray.length > 1 && stringArray[1].startsWith("assign") ? SqltoolRB.pl_assign.getString() : (string3.equals("control") || stringArray.length > 1 && stringArray[1].equals("control") ? SqltoolRB.pl_control.getString() : SqltoolRB.pl_help.getString());
            this.stdprintln(string4);
            return;
        }
        if (stringArray[0].equals("else")) {
            if (this.recursed != Recursion.IF) {
                throw new BadSpecial(SqltoolRB.else_without_if.getString());
            }
            return;
        }
        if (stringArray[0].equals("end")) {
            throw new BadSpecial(SqltoolRB.end_noblock.getString());
        }
        if (stringArray[0].equals("continue")) {
            if (stringArray.length > 1) {
                if (stringArray.length == 2 && (stringArray[1].equals("foreach") || stringArray[1].equals("forrows") || stringArray[1].equals("for") || stringArray[1].equals("while"))) {
                    throw new ContinueException(stringArray[1]);
                }
                throw new BadSpecial(SqltoolRB.continue_syntax.getString());
            }
            throw new ContinueException();
        }
        if (stringArray[0].equals("return")) {
            if (stringArray.length > 1) {
                throw new BadSpecial(SqltoolRB.break_syntax.getString());
            }
            throw new BreakException("file");
        }
        if (stringArray[0].equals("break")) {
            if (stringArray.length > 1) {
                if (stringArray.length == 2 && (stringArray[1].equals("foreach") || stringArray[1].equals("forrows") || stringArray[1].equals("while") || stringArray[1].equals("for") || stringArray[1].equals("file"))) {
                    throw new BreakException(stringArray[1]);
                }
                throw new BadSpecial(SqltoolRB.break_syntax.getString());
            }
            throw new BreakException();
        }
        if (stringArray[0].equals("list") || stringArray[0].equals("listvalues") || stringArray[0].equals("listsysprops")) {
            boolean bl;
            boolean bl2 = stringArray[0].equals("listsysprops");
            boolean bl3 = bl = stringArray[0].equals("listvalues") || bl2;
            if (stringArray.length == 1) {
                this.stdprint(this.formatNicely(bl2 ? System.getProperties() : this.shared.userVars, bl));
            } else {
                if (bl) {
                    this.stdprintln(SqltoolRB.pl_list_parens.getString());
                } else {
                    this.stdprintln(SqltoolRB.pl_list_lengths.getString());
                }
                String[] stringArray2 = stringArray;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string5;
                    String string6 = (String)(bl2 ? System.getProperties() : this.shared.userVars).get(string5 = stringArray2[i]);
                    if (string6 == null) continue;
                    this.stdprintln(PRE_TR + string5 + ": " + (bl ? "(" + string6 + ')' : Integer.toString(string6.length())));
                }
            }
            return;
        }
        if (stringArray[0].equals("dump") || stringArray[0].equals("load")) {
            if (stringArray.length != 3) {
                throw new BadSpecial(SqltoolRB.dumpload_malformat.getString());
            }
            String string7 = stringArray[1];
            if (string7.indexOf(58) > -1) {
                throw new BadSpecial(SqltoolRB.plvar_nocolon.getString());
            }
            File file = new File(this.dereferenceAt(stringArray[2]));
            try {
                if (stringArray[0].equals("dump")) {
                    this.dump(string7, file);
                } else {
                    this.load(string7, file, this.shared.encoding);
                }
            }
            catch (IOException iOException) {
                throw new BadSpecial(SqltoolRB.dumpload_fail.getString(string7, file.toString()), iOException);
            }
            return;
        }
        if (stringArray[0].equals("prepare")) {
            if (stringArray.length != 2) {
                throw new BadSpecial(SqltoolRB.pl_malformat_specific.getString("prepare"));
            }
            if (this.shared.userVars.get(stringArray[1]) == null) {
                throw new BadSpecial(SqltoolRB.plvar_undefined.getString(stringArray[1]));
            }
            this.prepareVar = stringArray[1];
            this.doPrepare = true;
            return;
        }
        if (stringArray[0].equals("-")) {
            if (stringArray.length != 2) {
                throw new BadSpecial(SqltoolRB.pl_unset_nomoreargs.getString());
            }
            if (this.fetchingVar != null && this.fetchingVar.equals(stringArray[1])) {
                this.fetchingVar = null;
            }
            if (stringArray[1].equals("*ENCODING")) {
                try {
                    this.setEncoding(matcher2.group(3));
                    return;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new BadSpecial(SqltoolRB.encode_fail.getString(matcher2.group(3)));
                }
            }
            this.shared.userVars.remove(stringArray[1]);
            this.updateUserSettings();
            this.sqlExpandMode = null;
            return;
        }
        String string8 = this.dereference(string, false);
        matcher2 = varsetPattern.matcher(string8);
        if (!matcher2.matches()) {
            throw new BadSpecial(SqltoolRB.pl_unknown.getString(stringArray[0]));
        }
        assert (matcher2.groupCount() > 1 && matcher2.groupCount() < 4) : "varset pattern matched but captured " + matcher2.groupCount() + " groups";
        String string9 = matcher2.group(1);
        if (string8.trim().equals(string9 + '_')) {
            throw new BadSpecial(SqltoolRB.pl_unknown.getString(stringArray[0]));
        }
        if (string9.indexOf(58) > -1) {
            throw new BadSpecial(SqltoolRB.plvar_nocolon.getString());
        }
        if (!varPattern.matcher(string9).matches()) {
            this.errprintln(SqltoolRB.varname_warning.getString(string9));
        }
        switch (matcher2.group(2).charAt(0)) {
            case ':': {
                if (this.prevToken == null) {
                    throw new BadSpecial(nobufferYetString);
                }
                StringBuilder stringBuilder = new StringBuilder();
                switch (this.prevToken.type) {
                    case 2: {
                        stringBuilder.append('*');
                        break;
                    }
                    case 1: {
                        stringBuilder.append('\\');
                        break;
                    }
                }
                stringBuilder.append(this.prevToken.val);
                if (matcher2.groupCount() > 2 && matcher2.group(3) != null) {
                    stringBuilder.append(matcher2.group(3));
                }
                this.shared.userVars.put(string9, stringBuilder.toString());
                this.updateUserSettings();
                this.sqlExpandMode = null;
                return;
            }
            case '_': {
                this.silentFetch = true;
            }
            case '~': {
                if (matcher2.groupCount() > 2 && matcher2.group(3) != null && matcher2.group(3).trim().length() > 0) {
                    throw new BadSpecial(SqltoolRB.plvar_tildedash_nomoreargs.getString(matcher2.group(3).trim()));
                }
                this.shared.userVars.remove(string9);
                this.updateUserSettings();
                this.sqlExpandMode = null;
                this.fetchingVar = string9;
                return;
            }
            case '=': {
                String string10;
                if (this.fetchingVar != null && this.fetchingVar.equals(string9)) {
                    this.fetchingVar = null;
                }
                String string11 = string10 = matcher2.groupCount() > 2 && matcher2.group(3) != null ? matcher2.group(3).replaceFirst("^\\s+", "") : null;
                if (string10 != null && string10.length() < 1) {
                    string10 = null;
                }
                if (string9.equals("*ENCODING")) {
                    try {
                        this.setEncoding(string10.trim());
                        return;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new BadSpecial(SqltoolRB.encode_fail.getString(string10));
                    }
                }
                if (string10 == null) {
                    if (this.removeEmptyVars()) {
                        this.stdprintln(SqltoolRB.remove_empty_vars_suggestset.getString());
                        this.shared.userVars.remove(string9);
                    } else {
                        this.shared.userVars.put(string9, "");
                    }
                } else {
                    this.shared.userVars.put(string9, string10);
                }
                this.updateUserSettings();
                this.sqlExpandMode = null;
                return;
            }
        }
        throw new BadSpecial(SqltoolRB.pl_unknown.getString(stringArray[0]));
    }

    private void stdprint(String string) {
        this.stdprint(string, false);
    }

    private void stdprintln(String string) {
        this.stdprintln(string, false);
    }

    private void stdprintln(boolean bl) {
        if (this.shared.psStd != null) {
            if (this.htmlMode) {
                this.shared.psStd.println("<BR>");
            } else {
                this.shared.psStd.println();
            }
        }
        if (bl && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprintln(String string) {
        if (this.pwQuery != null && this.htmlMode) {
            this.pwQuery.println("<DIV class=\"sqltool-error\"><CODE>" + SqlFile.escapeHtml(string) + "</CODE></DIV>");
            this.pwQuery.flush();
        }
        if (this.shared.psStd != null && this.htmlMode) {
            this.shared.psStd.println("<DIV class=\"sqltool-error\"><CODE>" + SqlFile.escapeHtml(string) + "</CODE></DIV>");
        } else {
            logger.privlog(Level.SEVERE, string, null, 4, SqlFile.class);
        }
    }

    private void stdprint(String string, boolean bl) {
        if (this.shared.psStd != null) {
            this.shared.psStd.print(this.htmlMode ? "<P>" + SqlFile.escapeHtml(string) + "</P>" : string);
        }
        if (bl && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + SqlFile.escapeHtml(string) + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String string, boolean bl) {
        this.shared.psStd.println(this.htmlMode ? "<P>" + SqlFile.escapeHtml(string) + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + SqlFile.escapeHtml(string) + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentSchema() throws BadSpecial, SqlToolError {
        this.requireConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.shared.jdbcConn.createStatement();
            resultSet = statement.executeQuery("VALUES CURRENT_SCHEMA");
            if (!resultSet.next()) {
                throw new BadSpecial(SqltoolRB.no_vendor_schemaspt.getString());
            }
            String string = resultSet.getString(1);
            if (string == null) {
                throw new BadSpecial(SqltoolRB.schemaname_retrieval_fail.getString());
            }
            String string2 = string;
            return string2;
        }
        catch (SQLException sQLException) {
            throw new BadSpecial(SqltoolRB.no_vendor_schemaspt.getString());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    resultSet = null;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    statement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listTables(char c, String string) throws BadSpecial, SqlToolError {
        this.requireConnection();
        String string2 = null;
        int[] nArray = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "";
        String string4 = string;
        try {
            String[] stringArray3;
            DatabaseMetaData databaseMetaData = this.shared.jdbcConn.getMetaData();
            String string5 = databaseMetaData.getDatabaseProductName();
            int n = 0;
            int n2 = 0;
            if (string5.indexOf("HSQL") > -1) {
                try {
                    n = databaseMetaData.getDatabaseMajorVersion();
                    n2 = databaseMetaData.getDatabaseMinorVersion();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    n = 2;
                    n2 = 0;
                }
            }
            stringArray = new String[1];
            switch (c) {
                case '*': {
                    stringArray = null;
                    break;
                }
                case 'S': {
                    if (string5.indexOf("Oracle") > -1) {
                        this.errprintln(SqltoolRB.vendor_oracle_dS.getString());
                        stringArray[0] = "TABLE";
                        string2 = "SYS";
                        stringArray2 = oracleSysSchemas;
                        break;
                    }
                    stringArray[0] = "SYSTEM TABLE";
                    break;
                }
                case 's': {
                    if (string5.indexOf("HSQL") > -1) {
                        if (string4 != null && (stringArray3 = dotPattern.matcher(string4)).matches()) {
                            string4 = stringArray3.group(2).length() > 0 ? stringArray3.group(2) : null;
                            string3 = "\nWHERE sequence_schema = '" + (stringArray3.group(1).length() > 0 ? stringArray3.group(1) : this.getCurrentSchema()) + "'";
                        }
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT sequence_schema, sequence_name FROM information_schema." + (n2 > 8 || n > 1 ? "sequences" : "system_sequences") + string3);
                        break;
                    }
                    stringArray[0] = "SEQUENCE";
                    break;
                }
                case 'r': {
                    if (string5.indexOf("HSQL") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT authorization_name FROM information_schema." + (n2 > 8 || n > 1 ? "authorizations" : "system_authorizations") + "\nWHERE authorization_type = 'ROLE'\n" + "ORDER BY authorization_name");
                        break;
                    }
                    if (string5.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT name FROM syssrvroles ORDER BY name");
                        break;
                    }
                    if (string5.indexOf("Apache Derby") > -1) {
                        throw new BadSpecial(SqltoolRB.vendor_derby_dr.getString());
                    }
                    throw new BadSpecial(SqltoolRB.vendor_nosup_d.getString("r"));
                }
                case 'u': {
                    if (string5.indexOf("HSQL") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT " + (n2 > 8 || n > 1 ? "user_name" : "user") + ", admin FROM " + "information_schema.system_users\n" + "ORDER BY user_name");
                        break;
                    }
                    if (string5.indexOf("Oracle") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT username, created FROM all_users ORDER BY username");
                        break;
                    }
                    if (string5.indexOf("PostgreSQL") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
                        break;
                    }
                    if (string5.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT name, accdate, fullname FROM syslogins ORDER BY name");
                        break;
                    }
                    if (string5.indexOf("Apache Derby") > -1) {
                        throw new BadSpecial(SqltoolRB.vendor_derby_du.getString());
                    }
                    throw new BadSpecial(SqltoolRB.vendor_nosup_d.getString("u"));
                }
                case 'a': {
                    if (string5.indexOf("HSQL") > -1 && n2 < 9 && n < 2) {
                        if (string4 != null && (stringArray3 = dotPattern.matcher(string4)).matches()) {
                            string4 = stringArray3.group(2).length() > 0 ? stringArray3.group(2) : null;
                            string3 = "\nWHERE alias_schema = '" + (stringArray3.group(1).length() > 0 ? stringArray3.group(1) : this.getCurrentSchema()) + "'";
                        }
                        statement = this.shared.jdbcConn.createStatement();
                        statement.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + string3);
                        break;
                    }
                    stringArray[0] = "ALIAS";
                    break;
                }
                case 't': {
                    this.excludeSysSchemas = string5.indexOf("Oracle") > -1;
                    stringArray[0] = "TABLE";
                    break;
                }
                case 'v': {
                    stringArray[0] = "VIEW";
                    break;
                }
                case 'c': {
                    resultSet = databaseMetaData.getCatalogs();
                    if (resultSet == null) {
                        throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString());
                    }
                    this.displaySqlResults(null, resultSet, listMDSchemaCols, string4, false);
                    return;
                }
                case 'n': {
                    resultSet = databaseMetaData.getSchemas();
                    if (resultSet == null) {
                        throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString());
                    }
                    this.displaySqlResults(null, resultSet, listMDSchemaCols, string4, false);
                    return;
                }
                case 'i': {
                    String string6 = null;
                    if (string4 != null) {
                        Matcher matcher = dotPattern.matcher(string4);
                        if (matcher.matches()) {
                            string6 = matcher.group(2).length() > 0 ? matcher.group(2) : null;
                            string2 = matcher.group(1).length() > 0 ? matcher.group(1) : this.getCurrentSchema();
                        } else {
                            string6 = string4;
                        }
                        string4 = null;
                    }
                    if ((resultSet = databaseMetaData.getIndexInfo(null, string2, string6, false, true)) == null) {
                        throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString());
                    }
                    this.displaySqlResults(null, resultSet, listMDIndexCols, null, false);
                    return;
                }
                default: {
                    throw new BadSpecial(SqltoolRB.special_d_unknown.getString(Character.toString(c)) + LS + D_OPTIONS_TEXT);
                }
            }
            if (statement == null) {
                nArray = string5.indexOf("HSQL") > -1 ? listMDTableCols[1] : (string5.indexOf("Oracle") > -1 ? listMDTableCols[2] : listMDTableCols[0]);
                if (string2 == null && string4 != null && (stringArray3 = dotPattern.matcher(string4)).matches()) {
                    string4 = stringArray3.group(2).length() > 0 ? stringArray3.group(2) : null;
                    string2 = stringArray3.group(1).length() > 0 ? stringArray3.group(1) : this.getCurrentSchema();
                }
            }
            ResultSet resultSet2 = resultSet = statement == null ? databaseMetaData.getTables(null, string2, null, stringArray) : statement.getResultSet();
            if (resultSet == null) {
                throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString());
            }
            this.displaySqlResults(statement, resultSet, nArray, string4, false);
            if (stringArray2 != null) {
                for (String string7 : stringArray2) {
                    resultSet = databaseMetaData.getTables(null, string7, null, stringArray);
                    if (resultSet == null) {
                        throw new BadSpecial(SqltoolRB.metadata_fetch_failfor.getString(string7));
                    }
                    if (!resultSet.next()) continue;
                    this.displaySqlResults(null, databaseMetaData.getTables(null, string7, null, stringArray), nArray, string4, false);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString(), sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw new BadSpecial(SqltoolRB.metadata_fetch_fail.getString(), nullPointerException);
        }
        finally {
            this.excludeSysSchemas = false;
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    resultSet = null;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    statement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement processSQL() throws SQLException, SqlToolError {
        this.shared.userVars.remove("?");
        this.requireConnection();
        assert (this.buffer != null) : "Internal assertion failed.  No buffer in processSQL().";
        assert (this.buffer.type == 0) : "Internal assertion failed.  Token type " + this.buffer.getTypeString() + " in processSQL().";
        if (this.sqlExpandMode == null) {
            this.setSqlExpandMode();
        }
        String string = this.lastSqlStatement = this.sqlExpandMode != false ? this.dereference(this.buffer.val, true) : this.buffer.val;
        if (!this.permitEmptySqlStatements && this.buffer.val == null || this.buffer.val.trim().length() < 1) {
            throw new SqlToolError(SqltoolRB.sqlstatement_empty.getString());
        }
        Statement statement = null;
        long l = 0L;
        if (this.reportTimes) {
            l = new Date().getTime();
        }
        try {
            if (this.doPrepare) {
                if (this.lastSqlStatement.indexOf(63) < 1) {
                    this.lastSqlStatement = null;
                    throw new SqlToolError(SqltoolRB.prepare_demandqm.getString());
                }
                this.doPrepare = false;
                PreparedStatement preparedStatement = this.shared.jdbcConn.prepareStatement(this.lastSqlStatement);
                statement = preparedStatement;
                if (this.prepareVar == null) {
                    if (this.binBuffer == null) {
                        this.lastSqlStatement = null;
                        throw new SqlToolError(SqltoolRB.binbuffer_empty.getString());
                    }
                    preparedStatement.setBytes(1, this.binBuffer);
                } else {
                    String string2 = this.shared.userVars.get(this.prepareVar);
                    if (string2 == null) {
                        this.lastSqlStatement = null;
                        throw new SqlToolError(SqltoolRB.plvar_undefined.getString(this.prepareVar));
                    }
                    this.prepareVar = null;
                    preparedStatement.setString(1, string2);
                }
                preparedStatement.executeUpdate();
            } else {
                statement = this.shared.jdbcConn.createStatement();
                statement.execute(this.lastSqlStatement);
            }
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2) {
                }
                finally {
                    statement = null;
                }
            }
            throw sQLException;
        }
        catch (SqlToolError sqlToolError) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    statement = null;
                }
            }
            throw sqlToolError;
        }
        finally {
            if (this.reportTimes) {
                long l2 = new Date().getTime() - l;
                this.condlPrintln(SqltoolRB.exectime_report.getString((int)l2), false);
            }
        }
        try {
            this.shared.possiblyUncommitteds = !this.shared.jdbcConn.getAutoCommit() && !commitOccursPattern.matcher(this.lastSqlStatement).matches();
        }
        catch (SQLException sQLException) {
            this.lastSqlStatement = null;
            try {
                this.shared.jdbcConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shared.jdbcConn = null;
            this.shared.possiblyUncommitteds = false;
            this.stdprintln(SqltoolRB.disconnect_success.getString());
            return null;
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private void displaySqlResults(Statement statement, ResultSet resultSet, int[] nArray, String string, boolean bl) throws SQLException, SqlToolError {
        try {
            if (this.pwDsv != null && this.csvStyleQuoting && (this.dsvColDelim.indexOf(34) > -1 || this.dsvRowDelim.indexOf(34) > -1)) {
                throw new SqlToolError(SqltoolRB.dsv_q_nodblquote.getString());
            }
            int n = statement == null ? -1 : statement.getUpdateCount();
            boolean bl2 = this.silentFetch;
            boolean bl3 = this.fetchBinary;
            Pattern pattern = null;
            this.silentFetch = false;
            this.fetchBinary = false;
            if (string != null) {
                try {
                    pattern = Pattern.compile(string);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new SqlToolError(SqltoolRB.regex_malformat.getString(patternSyntaxException));
                }
            }
            if (this.excludeSysSchemas) {
                this.stdprintln(SqltoolRB.vendor_nosup_sysschemas.getString());
            }
            switch (n) {
                case -1: {
                    int n2;
                    String[] stringArray;
                    int n3;
                    boolean bl4;
                    int n4;
                    if (resultSet == null) {
                        this.stdprintln(SqltoolRB.noresult.getString(), true);
                        break;
                    }
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n5 = resultSetMetaData.getColumnCount();
                    int n6 = nArray == null ? n5 : nArray.length;
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    String[] stringArray2 = null;
                    int[] nArray2 = new int[n6];
                    if (!this.htmlMode) {
                        for (int i = 0; i < nArray2.length; ++i) {
                            nArray2[i] = 0;
                        }
                    }
                    boolean[] blArray = new boolean[n6];
                    int[] nArray3 = new int[n6];
                    boolean[] blArray2 = new boolean[n6];
                    int n7 = -1;
                    stringArray2 = new String[n6];
                    for (n4 = 1; n4 <= n5; ++n4) {
                        if (nArray != null) {
                            bl4 = true;
                            for (n3 = 0; n3 < nArray.length; ++n3) {
                                if (n4 != nArray[n3]) continue;
                                bl4 = false;
                            }
                            if (bl4) continue;
                        }
                        stringArray2[++n7] = this.pwDsv != null && this.csvStyleQuoting && this.allQuoted ? '\"' + resultSetMetaData.getColumnLabel(n4) + '\"' : resultSetMetaData.getColumnLabel(n4);
                        nArray3[n7] = resultSetMetaData.getColumnType(n4);
                        blArray[n7] = false;
                        blArray2[n7] = true;
                        switch (nArray3[n7]) {
                            case -7: 
                            case -6: 
                            case -5: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                blArray[n7] = true;
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -1: 
                            case 12: 
                            case 2004: 
                            case 2005: {
                                blArray2[n7] = false;
                            }
                        }
                        if (this.htmlMode || stringArray2[n7] == null || stringArray2[n7].length() <= nArray2[n7]) continue;
                        nArray2[n7] = stringArray2[n7].length();
                    }
                    while (resultSet.next()) {
                        stringArray = new String[n6];
                        n7 = -1;
                        n4 = pattern != null ? 1 : 0;
                        for (n3 = 1; n3 <= n5; ++n3) {
                            int n8;
                            if (nArray != null) {
                                bl4 = true;
                                int[] nArray4 = nArray;
                                n8 = nArray4.length;
                                for (n2 = 0; n2 < n8; ++n2) {
                                    int n9 = nArray4[n2];
                                    if (n3 != n9) continue;
                                    bl4 = false;
                                }
                                if (bl4) continue;
                            }
                            if (!SqlFile.canDisplayType(nArray3[++n7])) {
                                bl3 = true;
                            }
                            String string2 = null;
                            boolean bl5 = true;
                            if (!bl3) {
                                switch (nArray3[n7]) {
                                    case 91: 
                                    case 92: 
                                    case 93: 
                                    case 94: 
                                    case 95: {
                                        void var28_37;
                                        Timestamp timestamp = resultSet.getTimestamp(n3);
                                        bl5 = resultSet.wasNull();
                                        String string3 = string2 = timestamp == null ? null : timestamp.toString();
                                        if (nArray3[n7] == 93 || nArray3[n7] == 95 || string2 == null) break;
                                        int n10 = string2.lastIndexOf(46);
                                        int n11 = n10 + 1;
                                        while (var28_37 < string2.length()) {
                                            if (string2.charAt((int)var28_37) != '0') {
                                                n10 = 0;
                                                break;
                                            }
                                            ++var28_37;
                                        }
                                        if (n10 <= 1) break;
                                        string2 = string2.substring(0, n10);
                                        break;
                                    }
                                    default: {
                                        string2 = resultSet.getString(n3);
                                        bl5 = resultSet.wasNull();
                                        if (string2 != null) break;
                                        try {
                                            string2 = this.streamToString(resultSet.getAsciiStream(n3), this.shared.encoding);
                                            bl5 = resultSet.wasNull();
                                            break;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                            if (bl3 || string2 == null && !bl5) {
                                if (this.pwDsv != null) {
                                    throw new SqlToolError(SqltoolRB.dsv_bincol.getString());
                                }
                                try {
                                    this.binBuffer = SqlFile.streamToBytes(resultSet.getBinaryStream(n3));
                                    bl5 = resultSet.wasNull();
                                }
                                catch (IOException iOException) {
                                    throw new SqlToolError(SqltoolRB.streamread_failure.getString(), iOException);
                                }
                                this.stdprintln(SqltoolRB.binbuf_write.getString(Integer.toString(this.binBuffer.length), stringArray2[n7], SqlFile.sqlTypeToString(nArray3[n7])));
                                if (bl) {
                                    this.shared.userVars.put("?", "");
                                }
                                if (this.fetchingVar != null) {
                                    this.shared.userVars.put(this.fetchingVar, "");
                                    this.updateUserSettings();
                                    this.sqlExpandMode = null;
                                    this.fetchingVar = null;
                                }
                                this.lastSqlStatement = null;
                                return;
                            }
                            if (this.excludeSysSchemas && string2 != null && n3 == 2) {
                                String[] stringArray3 = oracleSysSchemas;
                                n8 = stringArray3.length;
                                for (n2 = 0; n2 < n8; ++n2) {
                                    String string4 = stringArray3[n2];
                                    if (!string2.equals(string4)) continue;
                                    n4 = 1;
                                    break;
                                }
                            }
                            if (bl) {
                                this.shared.userVars.put("?", string2 == null ? this.nullRepToken : string2);
                            }
                            if (this.fetchingVar != null) {
                                if (string2 == null) {
                                    this.shared.userVars.remove(this.fetchingVar);
                                } else {
                                    this.shared.userVars.put(this.fetchingVar, string2);
                                }
                                this.updateUserSettings();
                                this.sqlExpandMode = null;
                                this.fetchingVar = null;
                            }
                            if (bl2) {
                                this.lastSqlStatement = null;
                                return;
                            }
                            if (pattern != null && (string2 == null || pattern.matcher(string2).find())) {
                                n4 = 0;
                            }
                            stringArray[n7] = string2 == null && this.pwDsv == null ? (nArray3[n7] == 12 ? (this.htmlMode ? "\u0000" : this.nullRepToken) : "") : string2;
                            if (this.htmlMode || this.pwDsv != null || stringArray[n7].length() <= nArray2[n7]) continue;
                            nArray2[n7] = stringArray[n7].length();
                        }
                        if (n4 != 0) continue;
                        arrayList.add(stringArray);
                    }
                    if (bl && !this.shared.userVars.containsKey("?")) {
                        this.shared.userVars.put("?", "");
                    }
                    if (this.fetchingVar != null) {
                        this.shared.userVars.remove(this.fetchingVar);
                        this.updateUserSettings();
                        this.sqlExpandMode = null;
                        this.fetchingVar = null;
                    }
                    if (this.pwDsv == null) {
                        this.condlPrintln("<TABLE class=\"sqltool\"><THEAD>", true);
                        if (n6 > 1) {
                            this.condlPrint(SqlFile.htmlRow(0) + LS + PRE_TD, true);
                            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                                this.condlPrint("<TH>" + SqlFile.escapeHtml(stringArray2[n3]) + "</TH>", true);
                                this.condlPrint((n3 > 0 ? "  " : "") + (n3 < stringArray2.length - 1 || blArray[n3] ? StringUtil.toPaddedString(stringArray2[n3], nArray2[n3], ' ', !blArray[n3]) : stringArray2[n3]), false);
                            }
                            this.condlPrintln(LS + PRE_TR + "</TR>", true);
                            this.condlPrintln("", false);
                            if (!this.htmlMode) {
                                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                                    this.condlPrint((n3 > 0 ? "  " : "") + SqlFile.divider(nArray2[n3]), false);
                                }
                                this.condlPrintln("", false);
                            }
                        }
                        this.condlPrintln("</THEAD><TBODY>", true);
                        for (n3 = 0; n3 < arrayList.size(); ++n3) {
                            this.condlPrint(SqlFile.htmlRow(n3 % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                            stringArray = (String[])arrayList.get(n3);
                            for (int i = 0; i < stringArray.length; ++i) {
                                this.condlPrint("<TD" + (blArray[i] ? " class=\"sqltool-right\"" : "") + ">" + (stringArray[i].equals("\u0000") ? this.nullRepHtml : SqlFile.escapeHtml(stringArray[i])) + "</TD>", true);
                                this.condlPrint((i > 0 ? "  " : "") + (i < stringArray.length - 1 || blArray[i] ? StringUtil.toPaddedString(stringArray[i], nArray2[i], ' ', !blArray[i]) : stringArray[i]), false);
                            }
                            this.condlPrintln(LS + PRE_TR + "</TR>", true);
                            this.condlPrintln("", false);
                        }
                        this.condlPrintln("</TBODY></TABLE>", true);
                        if (!this.interactive || arrayList.size() == 1) break;
                        this.stdprintln(LS + SqltoolRB.rows_fetched.getString(arrayList.size()), true);
                        break;
                    }
                    if (n6 > 0) {
                        for (n3 = 0; n3 < stringArray2.length; ++n3) {
                            this.dsvSafe(stringArray2[n3]);
                            this.pwDsv.print(stringArray2[n3]);
                            if (n3 >= stringArray2.length - 1) continue;
                            this.pwDsv.print(this.dsvColDelim);
                        }
                        this.pwDsv.print(this.dsvRowDelim);
                    }
                    if (this.csvStyleQuoting) {
                        Pattern pattern2 = Pattern.compile(this.dsvColDelim);
                        for (String[] stringArray4 : arrayList) {
                            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                                if (stringArray4[n2] == null || !this.allQuoted && stringArray4[n2].indexOf(34) <= -1 && stringArray4[n2].indexOf(this.dsvColDelim) <= -1) continue;
                                stringArray4[n2] = '\"' + stringArray4[n2].replace("\"", "\"\"") + '\"';
                            }
                        }
                    }
                    for (String[] stringArray5 : arrayList) {
                        for (int i = 0; i < stringArray5.length; ++i) {
                            if (this.pwDsv == null) {
                                this.dsvSafe(stringArray5[i]);
                            }
                            this.pwDsv.print(stringArray5[i] == null ? (blArray2[i] ? "" : this.nullRepToken) : stringArray5[i]);
                            if (i >= stringArray5.length - 1) continue;
                            this.pwDsv.print(this.dsvColDelim);
                        }
                        this.pwDsv.print(this.dsvRowDelim);
                    }
                    this.stdprintln(SqltoolRB.rows_fetched_dsv.getString(arrayList.size()));
                    break;
                }
                default: {
                    if (bl) {
                        this.shared.userVars.put("?", Integer.toString(n));
                    }
                    if (this.fetchingVar != null) {
                        this.shared.userVars.put(this.fetchingVar, Integer.toString(n));
                        this.fetchingVar = null;
                        this.updateUserSettings();
                        this.sqlExpandMode = null;
                    }
                    if (n == 0 || !this.interactive) break;
                    this.stdprintln(n == 1 ? SqltoolRB.row_update_singular.getString() : SqltoolRB.row_update_multiple.getString(n));
                }
            }
            this.lastSqlStatement = null;
        }
        finally {
            if (resultSet != null) {
                try {
                    try {
                        resultSet.close();
                        resultSet = null;
                    }
                    catch (SQLException sQLException) {
                        logger.warning("Failed to close SQL result set: " + sQLException);
                        resultSet = null;
                    }
                }
                catch (Throwable throwable) {
                    resultSet = null;
                    throw throwable;
                }
            }
            if (statement != null) {
                try {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException sQLException) {
                        logger.warning("Failed to close SQL statement: " + sQLException);
                        statement = null;
                    }
                }
                catch (Throwable throwable) {
                    statement = null;
                    throw throwable;
                }
            }
        }
    }

    private static String htmlRow(int n) {
        switch (n) {
            case 0: {
                return "    <TR>";
            }
            case 1: {
                return "    <TR class=\"sqltool-odd\">";
            }
            case 2: {
                return "    <TR class=\"sqltool-even\">";
            }
        }
        return null;
    }

    private static String divider(int n) {
        return n > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, n);
    }

    private void showHistory() throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(SqltoolRB.history_unavailable.getString());
        }
        if (this.history.size() < 1) {
            throw new BadSpecial(SqltoolRB.history_none.getString());
        }
        if (this.shared.psStd == null) {
            return;
        }
        for (int i = 0; i < this.history.size(); ++i) {
            Token token = (Token)this.history.get(i);
            this.shared.psStd.println(DEFAULT_SKIP_PREFIX + (i + this.oldestHist) + " or " + (i - this.history.size()) + ':');
            this.shared.psStd.println(token.reconstitute());
        }
        if (this.buffer != null) {
            this.shared.psStd.println(SqltoolRB.editbuffer_contents.getString(this.buffer.reconstitute()));
        }
        this.shared.psStd.println();
        this.shared.psStd.println(SqltoolRB.buffer_instructions.getString());
    }

    private Token commandFromHistory(int n) throws BadSpecial {
        int n2 = n;
        if (this.history == null) {
            throw new BadSpecial(SqltoolRB.history_unavailable.getString());
        }
        if (n2 == 0) {
            throw new BadSpecial(SqltoolRB.history_number_req.getString());
        }
        if (n2 > 0) {
            if ((n2 -= this.oldestHist) < 0) {
                throw new BadSpecial(SqltoolRB.history_backto.getString(this.oldestHist));
            }
            if (n2 >= this.history.size()) {
                throw new BadSpecial(SqltoolRB.history_upto.getString(this.history.size() + this.oldestHist - 1));
            }
        } else if ((n2 += this.history.size()) < 0) {
            throw new BadSpecial(SqltoolRB.history_back.getString(this.history.size()));
        }
        return (Token)this.history.get(n2);
    }

    private Integer historySearch(String string) throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(SqltoolRB.history_unavailable.getString());
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile("(?ims)" + string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new BadSpecial(SqltoolRB.regex_malformat.getString(patternSyntaxException));
        }
        for (int i = this.history.size() - 1; i >= 0; --i) {
            if (!pattern.matcher(((Token)this.history.get((int)i)).val).find()) continue;
            return i + this.oldestHist;
        }
        return null;
    }

    private boolean setBuf(Token token) {
        if (this.buffer != null && this.buffer.equals(token)) {
            return false;
        }
        switch (token.type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                assert (false) : "Internal assertion failed.  Attempted to add command type " + token.getTypeString() + " to buffer";
                break;
            }
        }
        this.buffer = new Token(token.type, new String(token.val), token.line);
        return true;
    }

    private boolean historize() {
        if (this.history == null || this.buffer == null) {
            return false;
        }
        if (this.history.size() > 0 && ((Token)this.history.get(this.history.size() - 1)).equals(this.buffer)) {
            return false;
        }
        this.history.add(this.buffer);
        if (this.history.size() <= this.maxHistoryLength) {
            return true;
        }
        this.history.remove(0);
        ++this.oldestHist;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describe(String string, String string2) throws SQLException {
        assert (this.shared.jdbcConn != null) : "Somehow got to 'describe' even though we have no Conn";
        Pattern pattern = null;
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[]{SqltoolRB.describe_table_name.getString(), SqltoolRB.describe_table_datatype.getString(), SqltoolRB.describe_table_width.getString(), SqltoolRB.describe_table_nonulls.getString(), SqltoolRB.describe_table_precision.getString(), SqltoolRB.describe_table_scale.getString()};
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        boolean[] blArray = new boolean[]{false, false, true, false, true, true};
        if (string2 != null) {
            try {
                bl = string2.charAt(0) == '/';
                pattern = Pattern.compile(bl ? string2.substring(1) : string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SQLException(SqltoolRB.regex_malformat.getString(patternSyntaxException));
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.htmlMode || stringArray[i].length() <= nArray[i]) continue;
            nArray[i] = stringArray[i].length();
        }
        ResultSet resultSet = null;
        Statement statement = this.shared.jdbcConn.createStatement();
        try {
            int n;
            String[] stringArray2;
            int n2;
            statement.execute("SELECT * FROM " + string + " WHERE 1 = 2");
            resultSet = statement.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray2 = new String[6];
                int n4 = resultSetMetaData.getPrecision(n2 + 1);
                int n5 = resultSetMetaData.getScale(n2 + 1);
                stringArray2[0] = resultSetMetaData.getColumnName(n2 + 1);
                if (pattern != null && !bl && !pattern.matcher(stringArray2[0]).find()) continue;
                stringArray2[1] = resultSetMetaData.getColumnTypeName(n2 + 1);
                stringArray2[2] = Integer.toString(resultSetMetaData.getColumnDisplaySize(n2 + 1));
                stringArray2[3] = resultSetMetaData.isNullable(n2 + 1) == 1 ? "" : "*";
                stringArray2[4] = n4 == 0 ? "" : Integer.toString(n4);
                String string3 = stringArray2[5] = n5 == 0 ? "" : Integer.toString(n5);
                if (pattern != null && bl && !pattern.matcher(stringArray2[0] + ' ' + stringArray2[1] + ' ' + stringArray2[2] + ' ' + stringArray2[3]).find()) continue;
                arrayList.add(stringArray2);
                for (n = 0; n < stringArray2.length; ++n) {
                    if (stringArray2[n].length() <= nArray[n]) continue;
                    nArray[n] = stringArray2[n].length();
                }
            }
            this.condlPrint("<TABLE class=\"sqltool sqltool-describe\"><THEAD>" + LS + SqlFile.htmlRow(0) + LS + PRE_TD, true);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.condlPrint("<TH>" + SqlFile.escapeHtml(stringArray[n2]) + "</TH>", true);
                this.condlPrint((n2 > 0 ? "  " : "") + (n2 < stringArray.length - 1 || blArray[n2] ? StringUtil.toPaddedString(stringArray[n2], nArray[n2], ' ', !blArray[n2]) : stringArray[n2]), false);
            }
            this.condlPrintln(LS + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            this.condlPrintln("</THEAD><TBODY>", true);
            if (!this.htmlMode) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    this.condlPrint((n2 > 0 ? "  " : "") + SqlFile.divider(nArray[n2]), false);
                }
                this.condlPrintln("", false);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.condlPrint(SqlFile.htmlRow(n2 % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                stringArray2 = (String[])arrayList.get(n2);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.condlPrint("<TD" + (blArray[n] ? " class=\"sqltool-right\"" : "") + ">" + SqlFile.escapeHtml(stringArray2[n]) + "</TD>", true);
                    this.condlPrint((n > 0 ? "  " : "") + (n < stringArray2.length - 1 || blArray[n] ? StringUtil.toPaddedString(stringArray2[n], nArray[n], ' ', !blArray[n]) : stringArray2[n]), false);
                }
                this.condlPrintln(LS + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
            }
            this.condlPrintln(LS + "</TBODY></TABLE>", true);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    resultSet = null;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    statement = null;
                }
            }
        }
    }

    private boolean eval(String[] stringArray) throws BadSpecial {
        int n;
        boolean bl = stringArray.length > 0 && stringArray[0].equals("!");
        String[] stringArray2 = new String[bl ? stringArray.length - 1 : stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            String string = stringArray[n + (bl ? 1 : 0)];
            stringArray2[n] = string.length() > 1 && string.charAt(0) == '*' ? this.shared.userVars.get(string.substring(1)) : stringArray[n + (bl ? 1 : 0)];
        }
        if (stringArray2.length == 1) {
            return (stringArray2[0] != null && stringArray2[0].length() > 0 && !stringArray2[0].equals("0")) ^ bl;
        }
        if (stringArray2.length == 3) {
            char c;
            if (stringArray2[1] == null) {
                throw new BadSpecial(SqltoolRB.logical_unrecognized.getString());
            }
            if (stringArray2[1].equals("!=") || stringArray2[1].equals("<>") || stringArray2[1].equals("><")) {
                bl = !bl;
                stringArray2[1] = "==";
            }
            if (stringArray2[1].equals(">=") || stringArray2[1].equals("=>")) {
                bl = !bl;
                stringArray2[1] = "<";
            }
            if (stringArray2[1].equals("<=") || stringArray2[1].equals("=<")) {
                bl = !bl;
                stringArray2[1] = ">";
            }
            if (stringArray2[1].equals("==")) {
                if (stringArray2[0] == null || stringArray2[2] == null) {
                    return (stringArray2[0] == null && stringArray2[2] == null) ^ bl;
                }
                return stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            n = stringArray2[0] == null || stringArray2[0].length() < 1 ? 0 : (int)stringArray2[0].charAt(0);
            char c2 = c = stringArray2[2] == null || stringArray2[2].length() < 1 ? (char)'\u0000' : stringArray2[2].charAt(0);
            if (stringArray2[1].equals(">")) {
                if (stringArray2[0] == null || stringArray2[2] == null) {
                    return !bl;
                }
                if (n == 45 && c == '-') {
                    bl = !bl;
                } else {
                    if (n == 45) {
                        return bl;
                    }
                    if (c == '-') {
                        return !bl;
                    }
                }
                return (stringArray2[0].length() > stringArray2[2].length() || stringArray2[0].length() == stringArray2[2].length() && stringArray2[0].compareTo(stringArray2[2]) > 0) ^ bl;
            }
            if (stringArray2[1].equals("<")) {
                if (stringArray2[0] == null || stringArray2[2] == null) {
                    return !bl;
                }
                if (n == 45 && c == '-') {
                    bl = !bl;
                } else {
                    if (n == 45) {
                        return !bl;
                    }
                    if (c == '-') {
                        return bl;
                    }
                }
                return (stringArray2[2].length() > stringArray2[0].length() || stringArray2[2].length() == stringArray2[0].length() && stringArray2[2].compareTo(stringArray2[0]) > 0) ^ bl;
            }
        }
        throw new BadSpecial(SqltoolRB.logical_unrecognized.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        try {
            if (this.htmlMode) {
                this.pwQuery.flush();
            }
        }
        finally {
            try {
                this.pwQuery.close();
            }
            finally {
                this.pwQuery = null;
            }
        }
    }

    private void condlPrintln(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        if (this.shared.psStd != null) {
            this.shared.psStd.println(string);
        }
        if (this.pwQuery != null) {
            this.pwQuery.println(string);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        if (this.shared.psStd != null) {
            this.shared.psStd.print(string);
        }
        if (this.pwQuery != null) {
            this.pwQuery.print(string);
            this.pwQuery.flush();
        }
    }

    private String formatNicely(Map<?, ?> map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            SqlFile.appendLine(stringBuffer, SqltoolRB.pl_list_parens.getString());
        } else {
            SqlFile.appendLine(stringBuffer, SqltoolRB.pl_list_lengths.getString());
        }
        for (Map.Entry<?, ?> entry : new TreeMap(map).entrySet()) {
            String string = (String)entry.getValue();
            SqlFile.appendLine(stringBuffer, PRE_TR + (String)entry.getKey() + ": " + (bl ? "(" + string + ')' : Integer.toString(string.length())));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String string, File file) throws IOException, BadSpecial {
        String string2 = this.shared.userVars.get(string);
        if (string2 == null) {
            throw new BadSpecial(SqltoolRB.plvar_undefined.getString(string));
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.shared.encoding == null ? DEFAULT_FILE_ENCODING : this.shared.encoding);
        try {
            char c;
            outputStreamWriter.write(string2);
            if (string2.length() > 0 && (c = string2.charAt(string2.length() - 1)) != '\n' && c != '\r') {
                outputStreamWriter.write(LS);
            }
            outputStreamWriter.flush();
        }
        finally {
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
            }
            finally {
                outputStreamWriter = null;
            }
        }
        this.stdprintln(SqltoolRB.file_wrotechars.getString(Long.toString(file.length()), file.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(File file) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial(SqltoolRB.binbuffer_empty.getString());
        }
        int n = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(this.binBuffer);
            n = this.binBuffer.length;
            this.binBuffer = null;
            fileOutputStream.flush();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                fileOutputStream = null;
            }
        }
        this.stdprintln(SqltoolRB.file_wrotechars.getString(n, file.toString()));
    }

    /*
     * Exception decompiling
     */
    public String streamToString(InputStream var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void load(String string, File file, String string2) throws IOException {
        String string3 = this.streamToString(new FileInputStream(file), string2);
        this.shared.userVars.put(string, string3);
        if (!varPattern.matcher(string).matches()) {
            this.errprintln(SqltoolRB.varname_warning.getString(string));
        }
        this.updateUserSettings();
        this.sqlExpandMode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamToBytes(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[10240];
        byte[] byArray2 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        finally {
            byteArrayOutputStream = null;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBinary(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray = new byte[10240];
        byte[] byArray2 = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                fileInputStream = null;
                byteArrayOutputStream = null;
            }
        }
        return byArray2;
    }

    public static boolean canDisplayType(int n) {
        switch (n) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 94: {
                return "SQL_TIME_WITH_TIME_ZONE";
            }
            case 95: {
                return "SQL_TIMESTAMP_WITH_TIME_ZONE";
            }
        }
        return "Unknown type " + n;
    }

    public void dsvSafe(String string) throws SqlToolError {
        assert (this.pwDsv != null && this.dsvColDelim != null && this.dsvRowDelim != null && this.nullRepToken != null) : "Assertion failed.  \ndsvSafe called when DSV settings are incomplete";
        if (string == null) {
            return;
        }
        if (string.indexOf(this.dsvColDelim) > 0) {
            throw new SqlToolError(SqltoolRB.dsv_coldelim_present.getString(this.dsvColDelim));
        }
        if (string.indexOf(this.dsvRowDelim) > 0) {
            throw new SqlToolError(SqltoolRB.dsv_rowdelim_present.getString(this.dsvRowDelim));
        }
        if (string.trim().equals(this.nullRepToken)) {
            throw new SqlToolError(SqltoolRB.dsv_nullrep_present.getString(this.nullRepToken));
        }
    }

    public static String convertEscapes(String string) {
        if (string == null) {
            return null;
        }
        return SqlFile.convertNumericEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(string, "\\n", "\n"), "\\r", "\r"), "\\t", "\t"), "\\\\", "\\"), "\\f", "\f"));
    }

    private static String convertNumericEscapes(String string) {
        String string2 = string;
        int n = 0;
        for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            while ((n = string2.indexOf("\\" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
            while ((n = string2.indexOf("\\x" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
            while ((n = string2.indexOf("\\X" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
        }
        return string2;
    }

    private static String convertNumericEscape(String string, int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (Character.toUpperCase(string.charAt(n + 1)) == 'X') {
            n3 = n + 2;
            n4 = 16;
            n2 = n3 + 2;
            if (n2 > string.length()) {
                n2 = string.length();
            }
        } else {
            n3 = n + 1;
            n4 = Character.toUpperCase(string.charAt(n3)) == '0' ? 8 : 10;
            for (n2 = n3 + 1; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
            }
        }
        return string.substring(0, n) + (char)Integer.parseInt(string.substring(n3, n2), n4) + string.substring(n2);
    }

    private static String convertEscapes(String string, String string2, String string3) {
        String string4 = string;
        int n = 0;
        int n2 = string2.length();
        while ((n = string4.indexOf(string2, n)) > -1 && n < string4.length() - 1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + n2);
        }
        return string4;
    }

    private void checkFor02(String string) throws SqlToolError {
        try {
            if (this.csvStyleQuoting && string.indexOf(2) > -1) {
                throw new SqlToolError(SqltoolRB.csv_coldelim_present.getString("\\u0002"));
            }
        }
        catch (RuntimeException runtimeException) {
            throw new SqlToolError(SqltoolRB.read_convertfail.getString(), runtimeException);
        }
    }

    private String preprocessCsvQuoting(String string, int n) throws SqlToolError {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.indexOf(34) < 0) {
            return string.replaceAll(this.dsvColSplitter, "\u0002");
        }
        int n2 = -1;
        block0: while (n2 < string.length() - 1) {
            int n3 = string.indexOf(34, n2 + 1);
            int n4 = (n3 < 0 ? string.length() : n3) - (n2 + 1);
            if (n4 > 1) {
                stringBuilder.append(string.substring(n2 + 1, n2 + 1 + n4).replaceAll(this.dsvColSplitter, "\u0002"));
            }
            if (n3 < 0) break;
            n2 = n3;
            while ((n3 = string.indexOf(34, n2 + 1)) > -1) {
                if (n3 - n2 > 1) {
                    stringBuilder.append(string.substring(n2 + 1, n3));
                }
                n2 = n3;
                if (string.length() < n3 + 2 || string.charAt(n3 + 1) != '\"') continue block0;
                ++n2;
                stringBuilder.append('\"');
            }
            throw new SqlToolError(SqltoolRB.csv_quote_unterminated.getString(n));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void importDsv(String var1_1, String var2_2) throws SqlToolError {
        this.requireConnection();
        if (this.csvStyleQuoting && (this.dsvColSplitter.indexOf(34) > -1 || this.dsvRowSplitter.indexOf(34) > -1)) {
            throw new SqlToolError(SqltoolRB.dsv_q_nodblquote.getString());
        }
        var4_3 = null;
        if (this.dsvConstCols != null) {
            var4_3 = new TreeMap<String, String>();
            for (String var8_13 : this.dsvConstCols.split(this.dsvColSplitter, -1)) {
                var3_12 = SqlFile.nameValPairPattern.matcher(var8_13);
                if (!var3_12.matches()) {
                    throw new SqlToolError(SqltoolRB.dsv_constcols_nullcol.getString());
                }
                var4_3.put(var3_12.group(1).toLowerCase(), var3_12.groupCount() < 2 || var3_12.group(2) == null ? "" : var3_12.group(2));
            }
        }
        var5_4 = null;
        if (this.dsvSkipCols != null) {
            var5_4 = new HashSet();
            for (Object var9_16 : this.dsvSkipCols.split(this.dsvColSplitter, -1)) {
                var5_4.add(var9_16.trim().toLowerCase());
            }
        }
        var6_7 = null;
        try {
            var6_7 = new FileRecordReader(var1_1, this.dsvRowSplitter, this.shared.encoding == null ? SqlFile.DEFAULT_FILE_ENCODING : this.shared.encoding);
        }
        catch (UnsupportedEncodingException var7_9) {
            throw new SqlToolError(var7_9);
        }
        catch (IOException var7_10) {
            throw new SqlToolError(SqltoolRB.file_readfail.getString(new String[]{var1_1}));
        }
        catch (PatternSyntaxException var7_11) {
            throw new SqlToolError(SqltoolRB.regex_malformat.getString(new String[]{this.dsvRowSplitter}));
        }
        var9_16 = new ArrayList<E>();
        var10_17 = this.dsvTargetTable;
        var11_18 = 0;
        var12_19 = null;
        var13_20 = false;
        var14_21 = 0;
        var15_22 = null;
        try {
            block189: {
                block184: {
                    while (true) {
                        try {
                            var15_22 = var6_7.nextRecord();
                        }
                        catch (IOException var16_24) {
                            throw new SqlToolError(var16_24);
                        }
                        if (var15_22 == null) {
                            throw new SqlToolError(SqltoolRB.dsv_header_none.getString());
                        }
                        this.checkFor02(var15_22);
                        ++var11_18;
                        var12_19 = var15_22.trim();
                        if (var12_19.length() < 1 || var2_2 != null && var12_19.startsWith(var2_2)) continue;
                        if (var12_19.startsWith("targettable=")) {
                            if (var10_17 != null) continue;
                            var10_17 = var12_19.substring("targettable=".length()).trim();
                            continue;
                        }
                        if (var12_19.equals("headerswitch{")) {
                            if (var10_17 == null) {
                                throw new SqlToolError(SqltoolRB.dsv_header_noswitchtarg.getString(var11_18));
                            }
                            var13_20 = true;
                            continue;
                        }
                        if (var12_19.equals("}")) {
                            throw new SqlToolError(SqltoolRB.dsv_header_noswitchmatch.getString(var11_18));
                        }
                        if (!var13_20) break block184;
                        var16_23 = var12_19.indexOf(58);
                        if (var16_23 < 1 || var16_23 == var12_19.length() - 1) {
                            throw new SqlToolError(SqltoolRB.dsv_header_nonswitched.getString(var11_18));
                        }
                        var17_27 = var12_19.substring(0, var16_23).trim();
                        if (var17_27.equals("*") || var17_27.equalsIgnoreCase(var10_17)) break;
                    }
                    var14_21 = 1 + var15_22.indexOf(58);
                }
                if (this.csvStyleQuoting) {
                    var15_22 = this.preprocessCsvQuoting(var15_22, var11_18);
                }
                var16_25 = var15_22.substring(var14_21);
                var18_28 = var16_25.split(this.csvStyleQuoting != false ? "\u0002" : this.dsvColSplitter, -1);
                var19_29 = new HashSet<String>();
                for (String var23_38 : var18_28) {
                    if (var23_38.length() < 1) {
                        throw new SqlToolError(SqltoolRB.dsv_nocolheader.getString(var9_16.size() + 1, var11_18));
                    }
                    var17_27 = var23_38.trim().toLowerCase();
                    if (var17_27.equals("-") || var5_4 != null && var5_4.remove(var17_27) || var4_3 != null && var4_3.containsKey(var17_27)) {
                        var17_27 = null;
                    }
                    var9_16.add(var17_27);
                    if (var17_27 == null) continue;
                    if (var19_29.contains(var17_27.toLowerCase())) {
                        throw new SqlToolError(SqltoolRB.import_col_dup.getString(new String[]{var17_27}));
                    }
                    var19_29.add(var17_27.toLowerCase());
                }
                if (var5_4 != null && var5_4.size() > 0) {
                    throw new SqlToolError(SqltoolRB.dsv_skipcols_missing.getString(new String[]{var5_4.toString()}));
                }
                var20_31 = false;
                var21_33 = var9_16.iterator();
                while (var21_33.hasNext()) {
                    var22_36 = (String)var21_33.next();
                    if (var22_36 == null) continue;
                    var20_31 = true;
                    break;
                }
                if (!var20_31) {
                    throw new SqlToolError(SqltoolRB.dsv_nocolsleft.getString(new String[]{this.dsvSkipCols}));
                }
                var21_34 = var9_16.size();
                if (var4_3 != null) {
                    var9_16.addAll(var4_3.keySet());
                }
                var22_37 = var9_16.toArray(new String[0]);
                if (var10_17 == null && (var23_39 = (var10_17 = var6_7.getName()).lastIndexOf(46)) > 0) {
                    var10_17 = var10_17.substring(0, var23_39);
                }
                var23_40 = new StringBuffer();
                var24_41 = new ArrayList<String>();
                var25_42 = 0;
                for (Object var29_48 : var22_37) {
                    if (var29_48 == null) {
                        ++var25_42;
                        continue;
                    }
                    if (var23_40.length() > 0) {
                        var23_40.append(", ");
                    }
                    var23_40.append((String)var29_48);
                    var24_41.add((String)var29_48);
                }
                var26_43 /* !! */  = (String[])new boolean[var22_37.length - var25_42];
                var27_45 = new boolean[var26_43 /* !! */ .length];
                var28_47 = new boolean[var26_43 /* !! */ .length];
                var29_48 = new char[var26_43 /* !! */ .length];
                var30_49 = var24_41.toArray(new String[0]);
                var31_50 = new StringBuffer("INSERT INTO " + var10_17 + " (" + var23_40 + ") VALUES (");
                var32_51 = new StringBuffer("SELECT " + var23_40 + " FROM " + var10_17 + " WHERE 1 = 2");
                try {
                    var33_52 = this.shared.jdbcConn.createStatement().executeQuery(var32_51.toString()).getMetaData();
                    if (var33_52.getColumnCount() != var26_43 /* !! */ .length) {
                        throw new SqlToolError(SqltoolRB.dsv_metadata_mismatch.getString());
                    }
                    block95: for (var34_55 = 0; var34_55 < var26_43 /* !! */ .length; ++var34_55) {
                        var26_43 /* !! */ [var34_55] = (String)true;
                        var27_45[var34_55] = false;
                        var28_47[var34_55] = false;
                        var29_48[var34_55] = 115;
                        switch (var33_52.getColumnType(var34_55 + 1)) {
                            case -7: {
                                var26_43 /* !! */ [var34_55] = (String)true;
                                var29_48[var34_55] = 98;
                                continue block95;
                            }
                            case -4: 
                            case -3: 
                            case -2: {
                                var26_43 /* !! */ [var34_55] = (String)true;
                                var29_48[var34_55] = 120;
                                continue block95;
                            }
                            case 16: {
                                var28_47[var34_55] = true;
                                continue block95;
                            }
                            case 2003: {
                                var26_43 /* !! */ [var34_55] = (String)true;
                                var29_48[var34_55] = 97;
                                continue block95;
                            }
                            case -1: 
                            case 12: 
                            case 2004: 
                            case 2005: {
                                var26_43 /* !! */ [var34_55] = (String)false;
                                continue block95;
                            }
                            case 91: 
                            case 92: 
                            case 93: 
                            case 94: 
                            case 95: {
                                var27_45[var34_55] = true;
                            }
                        }
                    }
                }
                catch (SQLException var33_53) {
                    throw new SqlToolError(SqltoolRB.query_metadatafail.getString(new String[]{var32_51.toString()}), var33_53);
                }
                for (var33_54 = 0; var33_54 < var26_43 /* !! */ .length; ++var33_54) {
                    if (var33_54 > 0) {
                        var31_50.append(", ");
                    }
                    var31_50.append('?');
                }
                var33_54 = 0;
                var34_56 = null;
                var35_57 = null;
                var36_58 = null;
                var37_59 = null;
                try {
                    block187: {
                        if (this.dsvRejectFile != null) {
                            try {
                                var34_56 = new File(this.dereferenceAt(this.dsvRejectFile));
                                var36_58 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(var34_56), this.shared.encoding == null ? SqlFile.DEFAULT_FILE_ENCODING : this.shared.encoding));
                                var36_58.print(var16_25 + this.dsvRowDelim);
                            }
                            catch (BadSpecial var38_60) {
                                throw new SqlToolError(SqltoolRB.dsv_rejectfile_setupfail.getString(new String[]{this.dsvRejectFile}), var38_60);
                            }
                            catch (IOException var38_61) {
                                throw new SqlToolError(SqltoolRB.dsv_rejectfile_setupfail.getString(new String[]{this.dsvRejectFile}), var38_61);
                            }
                        }
                        if (this.dsvRejectReport != null) {
                            try {
                                var35_57 = new File(this.dereferenceAt(this.dsvRejectReport));
                                var37_59 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(var35_57), this.shared.encoding == null ? SqlFile.DEFAULT_FILE_ENCODING : this.shared.encoding));
                                v0 = var38_62 = this.shared.userVars.containsKey("REPORT_TITLE") == false ? 1 : 0;
                                if (var38_62 != 0) {
                                    this.shared.userVars.put("REPORT_TITLE", "SqlTool " + (this.csvStyleQuoting != false ? "CSV" : "DSV") + " Reject Report");
                                }
                                try {
                                    this.writeHeader(var37_59, this.dsvRejectReport);
                                }
                                finally {
                                    if (var38_62 != 0) {
                                        this.shared.userVars.remove("REPORT_TITLE");
                                    }
                                }
                                var37_59.println(SqltoolRB.rejectreport_top.getString(new String[]{var6_7.getPath(), var34_56 == null ? SqltoolRB.none.getString() : var34_56.getPath(), var34_56 == null ? null : var34_56.getPath()}));
                            }
                            catch (BadSpecial var38_63) {
                                throw new SqlToolError(SqltoolRB.dsv_rejectreport_setupfail.getString(new String[]{this.dsvRejectReport}), var38_63);
                            }
                            catch (IOException var38_64) {
                                throw new SqlToolError(SqltoolRB.dsv_rejectreport_setupfail.getString(new String[]{this.dsvRejectReport}), var38_64);
                            }
                        }
                        var38_62 = 0;
                        var39_66 = 0;
                        var40_67 = null;
                        var41_68 = false;
                        var42_69 = false;
                        try {
                            v1 = var42_69 = this.dsvRecordsPerCommit > 0 && this.shared.jdbcConn.getAutoCommit() != false;
                            if (var42_69) {
                                this.shared.jdbcConn.setAutoCommit(false);
                            }
                        }
                        catch (SQLException var43_70) {
                            throw new SqlToolError(SqltoolRB.rpc_autocommit_failure.getString(), var43_70);
                        }
                        try {
                            try {
                                var40_67 = this.shared.jdbcConn.prepareStatement(var31_50.toString() + ')');
                            }
                            catch (SQLException var43_71) {
                                throw new SqlToolError(SqltoolRB.insertion_preparefail.getString(new String[]{var31_50.toString()}), var43_71);
                            }
                            var43_72 /* !! */  = new String[var26_43 /* !! */ .length];
                            var47_75 = null;
                            block97: while (true) {
                                try {
                                    while (true) lbl-1000:
                                    // 2 sources

                                    {
                                        try {
                                            block186: {
                                                while (true) {
                                                    try {
                                                        var15_22 = var6_7.nextRecord();
                                                    }
                                                    catch (IOException var49_81) {
                                                        throw new SqlToolError(var49_81);
                                                    }
                                                    if (var15_22 == null) break block97;
                                                    this.checkFor02(var15_22);
                                                    if (this.csvStyleQuoting) {
                                                        var15_22 = this.preprocessCsvQuoting(var15_22, ++var11_18);
                                                    }
                                                    if ((var12_19 = var15_22.trim()).length() < 1) continue;
                                                    if (var2_2 != null && var12_19.startsWith(var2_2)) {
                                                        ++var39_66;
                                                        continue;
                                                    }
                                                    if (!var13_20) break block186;
                                                    if (var12_19.equals("}")) {
                                                        var13_20 = false;
                                                        continue;
                                                    }
                                                    var49_82 = var12_19.indexOf(58);
                                                    if (var49_82 < 1 || var49_82 == var12_19.length() - 1) break;
                                                }
                                                throw new SqlToolError(SqltoolRB.dsv_header_matchernonhead.getString(var11_18));
                                            }
                                            ++var38_62;
                                            var44_76 = 0;
                                            var45_78 = 0;
                                            var18_28 = var15_22.split(this.csvStyleQuoting != false ? "\u0002" : this.dsvColSplitter, -1);
                                            for (String var52_95 : var18_28) {
                                                if (var44_76 == var21_34) {
                                                    throw new RowError(SqltoolRB.dsv_colcount_mismatch.getString(var21_34, 1 + var44_76));
                                                }
                                                if (var22_37[var44_76++] == null) continue;
                                                var43_72 /* !! */ [var45_78++] = this.dsvTrimAll != false ? var52_95.trim() : var52_95;
                                            }
                                            if (var44_76 < var21_34) {
                                                throw new RowError(SqltoolRB.dsv_colcount_mismatch.getString(var21_34, var44_76));
                                            }
                                            if (var4_3 != null) {
                                                for (String var50_89 : var4_3.values()) {
                                                    var43_72 /* !! */ [var45_78++] = var50_89;
                                                }
                                            }
                                            if (var45_78 != var43_72 /* !! */ .length) {
                                                throw new RowError(SqltoolRB.dsv_insertcol_mismatch.getString(var43_72 /* !! */ .length, var45_78));
                                            }
                                            for (var49_84 = 0; var49_84 < var43_72 /* !! */ .length; ++var49_84) {
                                                var47_75 = var30_49[var49_84];
                                                if (var26_43 /* !! */ [var49_84] != false) {
                                                    var43_72 /* !! */ [var49_84] = var43_72 /* !! */ [var49_84].trim();
                                                }
                                                if (var27_45[var49_84]) {
                                                    if (var43_72 /* !! */ [var49_84].length() < 1 && var26_43 /* !! */ [var49_84] != false || var43_72 /* !! */ [var49_84].equals(this.nullRepToken)) {
                                                        var40_67.setTimestamp(var49_84 + 1, null);
                                                    } else {
                                                        if (var43_72 /* !! */ [var49_84].indexOf(58) > 0 && var43_72 /* !! */ [var49_84].indexOf(45) > 0) {
                                                            var8_15 = var43_72 /* !! */ [var49_84];
                                                        } else if (var43_72 /* !! */ [var49_84].indexOf(58) < 1) {
                                                            var8_15 = var43_72 /* !! */ [var49_84] + " 0:00:00";
                                                        } else if (var43_72 /* !! */ [var49_84].indexOf(45) < 1) {
                                                            var8_15 = "0000-00-00 " + var43_72 /* !! */ [var49_84];
                                                        } else {
                                                            var8_15 = null;
                                                            if (!SqlFile.$assertionsDisabled) {
                                                                throw new AssertionError((Object)("Unexpected date/time val: " + var43_72 /* !! */ [var49_84]));
                                                            }
                                                        }
                                                        try {
                                                            var40_67.setTimestamp(var49_84 + 1, Timestamp.valueOf(var8_15));
                                                        }
                                                        catch (IllegalArgumentException var50_90) {
                                                            throw new RowError(SqltoolRB.time_bad.getString(new String[]{var8_15}), var50_90);
                                                        }
                                                    }
                                                } else if (var28_47[var49_84]) {
                                                    if (var43_72 /* !! */ [var49_84].length() < 1 && var26_43 /* !! */ [var49_84] != false || var43_72 /* !! */ [var49_84].equals(this.nullRepToken)) {
                                                        var40_67.setNull(var49_84 + 1, 16);
                                                    } else {
                                                        try {
                                                            var40_67.setBoolean(var49_84 + 1, Boolean.parseBoolean(var43_72 /* !! */ [var49_84]));
                                                        }
                                                        catch (IllegalArgumentException var50_91) {
                                                            throw new RowError(SqltoolRB.boolean_bad.getString(new String[]{var43_72 /* !! */ [var49_84]}), var50_91);
                                                        }
                                                    }
                                                } else {
                                                    switch (var29_48[var49_84]) {
                                                        case 98: {
                                                            var40_67.setBytes(var49_84 + 1, var43_72 /* !! */ [var49_84].length() < 1 ? null : SqlFile.bitCharsToBytes(var43_72 /* !! */ [var49_84]));
                                                            break;
                                                        }
                                                        case 120: {
                                                            var40_67.setBytes(var49_84 + 1, var43_72 /* !! */ [var49_84].length() < 1 ? null : SqlFile.hexCharOctetsToBytes(var43_72 /* !! */ [var49_84]));
                                                            break;
                                                        }
                                                        case 97: {
                                                            if (SqlFile.createArrayOfMethod == null) {
                                                                throw new SqlToolError(SqltoolRB.arrayimp_jvmreq.getString());
                                                            }
                                                            if (var43_72 /* !! */ [var49_84].length() < 1) {
                                                                var40_67.setArray(var49_84 + 1, null);
                                                                break;
                                                            }
                                                            var46_79 = SqlFile.arrayPattern.matcher(var43_72 /* !! */ [var49_84]);
                                                            if (!var46_79.matches()) {
                                                                throw new RowError(SqltoolRB.arrayval_malformat.getString(new String[]{var43_72 /* !! */ [var49_84]}));
                                                            }
                                                            var48_80 = var46_79.group(1) == null ? new String[]{} : var46_79.group(1).split("\\s*,\\s*");
                                                            try {
                                                                var40_67.setArray(var49_84 + 1, (Array)SqlFile.createArrayOfMethod.invoke((Object)this.shared.jdbcConn, new Object[]{"VARCHAR", var48_80}));
                                                                break;
                                                            }
                                                            catch (IllegalAccessException var50_92) {
                                                                throw new RuntimeException(var50_92);
                                                            }
                                                            catch (InvocationTargetException var50_93) {
                                                                if (var50_93.getCause() != null && var50_93.getCause() instanceof AbstractMethodError) {
                                                                    throw new SqlToolError(SqltoolRB.sqlarray_badjvm.getString());
                                                                }
                                                                throw new RuntimeException(var50_93);
                                                            }
                                                        }
                                                        default: {
                                                            var40_67.setString(var49_84 + 1, var43_72 /* !! */ [var49_84].length() < 1 && var26_43 /* !! */ [var49_84] != false || var43_72 /* !! */ [var49_84].equals(this.nullRepToken) != false ? null : var43_72 /* !! */ [var49_84]);
                                                        }
                                                    }
                                                }
                                                var47_75 = null;
                                            }
                                            var7_8 = var40_67.executeUpdate();
                                            if (var7_8 != 1) {
                                                throw new RowError(SqltoolRB.inputrec_modified.getString(var7_8));
                                            }
                                            if (this.dsvRecordsPerCommit > 0 && (var38_62 - var33_54) % this.dsvRecordsPerCommit == 0) {
                                                this.shared.jdbcConn.commit();
                                                this.shared.possiblyUncommitteds = false;
                                                continue block97;
                                            }
                                            this.shared.possiblyUncommitteds = true;
                                            continue;
                                        }
                                        catch (NumberFormatException var49_85) {
                                            throw new RowError(null, var49_85);
                                        }
                                        catch (SQLException var49_86) {
                                            throw new RowError(null, var49_86);
                                        }
                                        break;
                                    }
                                }
                                catch (RowError var49_87) {
                                    ++var33_54;
                                    if (var36_58 != null || var37_59 != null) {
                                        if (var36_58 != null) {
                                            var36_58.print(var15_22 + this.dsvRowDelim);
                                        }
                                        if (var37_59 == null) continue;
                                        this.genRejectReportRecord(var37_59, var33_54, var11_18, var47_75, var49_87.getMessage(), var49_87.getCause());
                                        continue;
                                    }
                                    var41_68 = true;
                                    throw new SqlToolError(SqltoolRB.dsv_recin_fail.getString(var11_18, var47_75) + (var49_87.getMessage() == null ? "" : "  " + var49_87.getMessage()), var49_87.getCause());
                                }
                                {
                                    ** while (true)
                                }
                                break;
                            }
                            if (var40_67 == null) break block187;
                        }
                        catch (Throwable var54_97) {
                            if (var40_67 != null) {
                                try {
                                    var40_67.close();
                                }
                                catch (SQLException var55_98) {
                                }
                                finally {
                                    var40_67 = null;
                                }
                            }
                            try {
                                if (this.dsvRecordsPerCommit > 0 && (var38_62 - var33_54) % this.dsvRecordsPerCommit != 0) {
                                    this.shared.jdbcConn.commit();
                                    this.shared.possiblyUncommitteds = false;
                                }
                                if (var42_69) {
                                    this.shared.jdbcConn.setAutoCommit(true);
                                }
                            }
                            catch (SQLException var55_99) {
                                throw new SqlToolError(SqltoolRB.rpc_commit_failure.getString(), var55_99);
                            }
                            var55_100 = null;
                            if (var38_62 > 0) {
                                var55_100 = SqltoolRB.dsv_import_summary.getString(new String[]{var2_2 == null ? "" : "'" + var2_2 + "'-", Integer.toString(var39_66), Integer.toString(var33_54), Integer.toString(var38_62 - var33_54), var41_68 != false ? "importAborted" : null});
                                this.stdprintln(var55_100);
                            }
                            try {
                                if (var38_62 > var33_54 && this.dsvRecordsPerCommit < 1 && !this.shared.jdbcConn.getAutoCommit()) {
                                    this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
                                }
                            }
                            catch (SQLException var56_102) {
                                this.stdprintln(SqltoolRB.autocommit_fetchfail.getString());
                                this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
                            }
                            if (var36_58 != null) {
                                var36_58.flush();
                            }
                            if (var37_59 != null && var33_54 > 0) {
                                var37_59.println(SqltoolRB.rejectreport_bottom.getString(new String[]{var55_100, SqlFile.revnum}));
                                this.writeFooter(var37_59, this.dsvRejectReport);
                                var37_59.flush();
                            }
                            throw var54_97;
                        }
                        try {
                            var40_67.close();
                        }
                        catch (SQLException var43_73) {
                        }
                        finally {
                            var40_67 = null;
                        }
                    }
                    try {
                        if (this.dsvRecordsPerCommit > 0 && (var38_62 - var33_54) % this.dsvRecordsPerCommit != 0) {
                            this.shared.jdbcConn.commit();
                            this.shared.possiblyUncommitteds = false;
                        }
                        if (var42_69) {
                            this.shared.jdbcConn.setAutoCommit(true);
                        }
                    }
                    catch (SQLException var43_74) {
                        throw new SqlToolError(SqltoolRB.rpc_commit_failure.getString(), var43_74);
                    }
                    var43_72 /* !! */  = null;
                    if (var38_62 > 0) {
                        var43_72 /* !! */  = SqltoolRB.dsv_import_summary.getString(new String[]{var2_2 == null ? "" : "'" + var2_2 + "'-", Integer.toString(var39_66), Integer.toString(var33_54), Integer.toString(var38_62 - var33_54), var41_68 != false ? "importAborted" : null});
                        this.stdprintln((String)var43_72 /* !! */ );
                    }
                    try {
                        if (var38_62 > var33_54 && this.dsvRecordsPerCommit < 1 && !this.shared.jdbcConn.getAutoCommit()) {
                            this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
                        }
                    }
                    catch (SQLException var44_77) {
                        this.stdprintln(SqltoolRB.autocommit_fetchfail.getString());
                        this.stdprintln(SqltoolRB.insertions_notcommitted.getString());
                    }
                    if (var36_58 != null) {
                        var36_58.flush();
                    }
                    if (var37_59 != null && var33_54 > 0) {
                        var37_59.println(SqltoolRB.rejectreport_bottom.getString(new String[]{var43_72 /* !! */ , SqlFile.revnum}));
                        this.writeFooter(var37_59, this.dsvRejectReport);
                        var37_59.flush();
                    }
                    if (var36_58 == null) break block189;
                }
                catch (Throwable var59_105) {
                    if (var36_58 != null) {
                        try {
                            var36_58.close();
                        }
                        finally {
                            var36_58 = null;
                        }
                    }
                    if (var37_59 != null) {
                        try {
                            var37_59.close();
                        }
                        finally {
                            var37_59 = null;
                        }
                    }
                    if (var33_54 == 0) {
                        if (var34_56 != null && var34_56.exists() && !var34_56.delete()) {
                            this.errprintln(SqltoolRB.dsv_rejectfile_purgefail.getString(new String[]{var34_56.toString()}));
                        }
                        if (var35_57 != null && !var35_57.delete()) {
                            this.errprintln(SqltoolRB.dsv_rejectreport_purgefail.getString(new String[]{var35_57.toString()}));
                        }
                    }
                    throw var59_105;
                }
                try {
                    var36_58.close();
                }
                finally {
                    var36_58 = null;
                }
            }
            if (var37_59 != null) {
                try {
                    var37_59.close();
                }
                finally {
                    var37_59 = null;
                }
            }
            if (var33_54 == 0) {
                if (var34_56 != null && var34_56.exists() && !var34_56.delete()) {
                    this.errprintln(SqltoolRB.dsv_rejectfile_purgefail.getString(new String[]{var34_56.toString()}));
                }
                if (var35_57 != null && !var35_57.delete()) {
                    this.errprintln(SqltoolRB.dsv_rejectreport_purgefail.getString(new String[]{var35_57.toString()}));
                }
            }
        }
        finally {
            if (var6_7.isOpen()) {
                try {
                    var6_7.close();
                }
                catch (Exception var16_26) {
                    SqlFile.logger.error(SqltoolRB.inputfile_closefail.getString() + ": " + var16_26);
                }
            }
        }
    }

    protected static void appendLine(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + LS);
    }

    private static String[] genWinArgs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cmd.exe");
        arrayList.add("/y");
        arrayList.add("/c");
        Matcher matcher = wincmdPattern.matcher(string);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.group(i) == null) continue;
                if (matcher.group(i).length() > 1 && matcher.group(i).charAt(0) == '\"') {
                    arrayList.add(matcher.group(i).substring(1, matcher.group(i).length() - 1));
                    continue;
                }
                arrayList.addAll(Arrays.asList(matcher.group(i).split("\\s+", -1)));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private void genRejectReportRecord(PrintWriter printWriter, int n, int n2, String string, String string2, Throwable throwable) {
        printWriter.println(SqltoolRB.rejectreport_row.getString("sqltool-" + (n % 2 == 0 ? "even" : "odd"), Integer.toString(n), Integer.toString(n2), string == null ? "" : string, (string2 == null ? "" : string2) + (string2 == null || throwable == null ? "" : "<HR/>") + (throwable == null ? "" : (throwable instanceof SQLException && throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()))));
    }

    private TokenList seekTokenSource(String string) throws BadSpecial, IOException, SqlToolError {
        Token token;
        TokenList tokenList = new TokenList();
        Pattern pattern = null;
        Pattern pattern2 = null;
        if (string != null) {
            if (string.equals("if")) {
                pattern = Pattern.compile("end\\s+" + string);
                pattern2 = Pattern.compile("else");
            } else {
                pattern = string.equals("else") ? Pattern.compile("end\\s+if") : Pattern.compile("end\\s+" + string);
            }
        }
        while ((token = this.scanner.yylex()) != null) {
            if (pattern != null && token.type == 2 && pattern.matcher(token.val).matches()) {
                return tokenList;
            }
            if (pattern2 != null && token.type == 2 && pattern2.matcher(token.val).matches()) {
                assert (token.nestedBlock == null) : "else statement's .nested block not null";
                token.nestedBlock = this.seekTokenSource("else");
                tokenList.add(token);
                return tokenList;
            }
            Matcher matcher = this.inlineNestMatcher(token);
            if (matcher != null) {
                this.processInlineBlock(token, matcher.group(1), matcher.group(2));
            } else {
                String string2 = this.nestingCommand(token);
                if (string2 != null) {
                    token.nestedBlock = this.seekTokenSource(string2);
                }
            }
            tokenList.add(token);
        }
        if (string == null) {
            return tokenList;
        }
        throw new BadSpecial(SqltoolRB.pl_block_unterminated.getString(string));
    }

    private void processMacro(Token token) throws BadSpecial {
        if (token.val.length() < 1) {
            throw new BadSpecial(SqltoolRB.macro_tip.getString());
        }
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        switch (token.val.charAt(0)) {
            case '?': {
                this.stdprintln(SqltoolRB.macro_help.getString());
                break;
            }
            case ':': {
                Matcher matcher = editMacroPattern.matcher(token.val);
                if (!matcher.matches()) {
                    throw new BadSpecial(SqltoolRB.macro_malformat.getString());
                }
                if (this.buffer == null) {
                    this.stdprintln(nobufferYetString);
                    return;
                }
                stringBuffer.append(this.buffer.val);
                if (matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0) {
                    stringBuffer.append(matcher.group(2));
                }
                n = this.buffer.type;
                if (stringBuffer.length() < 1) {
                    throw new BadSpecial(SqltoolRB.macrodef_empty.getString());
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
                    throw new BadSpecial(SqltoolRB.macrodef_semi.getString());
                }
                this.shared.macros.put(matcher.group(1), new Token(this.buffer.type, stringBuffer, token.line));
                break;
            }
            case '=': {
                String string = token.val;
                string = string.substring(1).trim();
                if (string.length() < 1) {
                    for (Map.Entry<String, Token> entry : this.shared.macros.entrySet()) {
                        this.stdprintln(entry.getKey() + " = " + entry.getValue().reconstitute());
                    }
                    break;
                }
                Matcher matcher = legacyEditMacroPattern.matcher(string);
                if (matcher.matches()) {
                    if (this.buffer == null) {
                        this.stdprintln(nobufferYetString);
                        return;
                    }
                    stringBuffer.append(this.buffer.val);
                    if (matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0) {
                        stringBuffer.append(matcher.group(2));
                    }
                    n = this.buffer.type;
                } else {
                    matcher = spMacroPattern.matcher(string);
                    if (matcher.matches()) {
                        stringBuffer.append(matcher.group(3));
                        n = matcher.group(2).equals("*") ? 2 : 1;
                    } else {
                        matcher = sqlMacroPattern.matcher(string);
                        if (!matcher.matches()) {
                            throw new BadSpecial(SqltoolRB.macro_malformat.getString());
                        }
                        stringBuffer.append(matcher.group(2));
                        n = 0;
                    }
                }
                if (stringBuffer.length() < 1) {
                    throw new BadSpecial(SqltoolRB.macrodef_empty.getString());
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
                    throw new BadSpecial(SqltoolRB.macrodef_semi.getString());
                }
                this.shared.macros.put(matcher.group(1), new Token(n, stringBuffer, token.line));
                break;
            }
            default: {
                Matcher matcher = useFnPattern.matcher(token.val);
                if (matcher.matches()) {
                    Token token2 = this.shared.macros.get(matcher.group(1) + ')');
                    if (token2 == null) {
                        throw new BadSpecial(SqltoolRB.macro_undefined.getString(matcher.group(1) + "...)"));
                    }
                    String[] stringArray = null;
                    stringArray = matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0 ? matcher.group(2).split("\\s*,\\s*", -1) : new String[]{};
                    String string = matcher.groupCount() > 2 && matcher.group(3) != null ? matcher.group(3) : null;
                    boolean bl = this.preempt = string != null && string.endsWith(";");
                    if (this.preempt) {
                        string = string.length() == 1 ? null : string.substring(0, string.length() - 1);
                    }
                    Matcher matcher2 = fnParamPat.matcher(token2.val);
                    int n2 = 0;
                    this.setBuf(token2);
                    this.buffer.val = "";
                    this.buffer.line = token.line;
                    while (matcher2.find()) {
                        String string2;
                        this.buffer.val = this.buffer.val + token2.val.substring(n2, matcher2.start());
                        int n3 = Integer.valueOf(matcher2.group(matcher2.groupCount()));
                        String string3 = string2 = n3 > 0 && n3 <= stringArray.length ? stringArray[n3 - 1] : null;
                        if (string2 == null && (matcher2.groupCount() < 2 || matcher2.group(1) == null || matcher2.group(1).length() < 1)) {
                            throw new BadSpecial(SqltoolRB.plvar_undefined.getString(matcher2.group(matcher2.groupCount())));
                        }
                        if (string2 != null) {
                            this.buffer.val = this.buffer.val + string2;
                        }
                        n2 = matcher2.end();
                    }
                    this.buffer.val = this.buffer.val + token2.val.substring(n2);
                    if (string != null) {
                        this.buffer.val = this.buffer.val + string;
                    }
                    return;
                }
                matcher = useMacroPattern.matcher(token.val);
                if (!matcher.matches()) {
                    throw new BadSpecial(SqltoolRB.macro_malformat.getString());
                }
                Token token3 = this.shared.macros.get(matcher.group(1));
                if (token3 == null) {
                    throw new BadSpecial(SqltoolRB.macro_undefined.getString(matcher.group(1)));
                }
                this.setBuf(token3);
                this.buffer.line = token.line;
                if (matcher.groupCount() > 1 && matcher.group(2) != null && matcher.group(2).length() > 0) {
                    this.buffer.val = this.buffer.val + matcher.group(2);
                }
                this.preempt = matcher.group(matcher.groupCount()).equals(";");
            }
        }
    }

    public static byte[] hexCharOctetsToBytes(String string) {
        int n = string.length();
        if (n != n / 2 * 2) {
            throw new NumberFormatException("Hex character lists contains an odd number of characters: " + n);
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'f') {
                n3 += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                n3 += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                n3 += c - 48;
            } else {
                throw new NumberFormatException("Non-hex character in input at offset " + i + ": " + c);
            }
            n3 <<= 4;
            c = string.charAt(++i);
            if (c >= 'a' && c <= 'f') {
                n3 += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                n3 += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                n3 += c - 48;
            } else {
                throw new NumberFormatException("Non-hex character in input at offset " + i + ": " + c);
            }
            byArray[n2++] = (byte)n3;
        }
        assert (byArray.length == n2) : "Internal accounting problem.  Expected to fill buffer of size " + byArray.length + ", but wrote only " + n2 + " bytes";
        return byArray;
    }

    public static byte[] bitCharsToBytes(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        throw new NumberFormatException("Sorry.  Bit exporting not supported yet");
    }

    private void requireConnection() throws SqlToolError {
        if (this.shared.jdbcConn == null) {
            throw new SqlToolError(SqltoolRB.no_required_conn.getString());
        }
    }

    public static String getBanner(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData == null ? null : SqltoolRB.jdbc_established.getString(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getUserName(), (connection.isReadOnly() ? "R/O " : "R/W ") + RCData.tiToString(connection.getTransactionIsolation()));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private void displayConnBanner() {
        String string = this.shared.jdbcConn == null ? SqltoolRB.disconnected_msg.getString() : SqlFile.getBanner(this.shared.jdbcConn);
        this.stdprintln(string == null ? SqltoolRB.connected_fallbackmsg.getString() : string);
    }

    private String dereferenceAt(String string) throws BadSpecial {
        if (string.indexOf(64) != 0) {
            return string;
        }
        if (this.baseDir == null) {
            throw new BadSpecial(SqltoolRB.illegal_at.getString());
        }
        return this.baseDir.getPath() + string.substring(1);
    }

    public static String escapeHtml(String string) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (char c : cArray = string.toCharArray()) {
            switch (c) {
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void writeHeader(PrintWriter printWriter, String string) throws BadSpecial, SqlToolError {
        String string2;
        char[] cArray = new char[1024];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            InputStream inputStream;
            InputStream inputStream2 = inputStream = this.topHtmlFile == null ? this.getClass().getResourceAsStream("sqltool/top-boilerplate.html") : new FileInputStream(this.topHtmlFile);
            if (inputStream == null) {
                throw new IOException("Missing resource: " + (this.topHtmlFile == null ? this.topHtmlFile : "sqltool/top-boilerplate"));
            }
            inputStreamReader = new InputStreamReader(inputStream);
            while ((n = inputStreamReader.read(cArray)) > -1) {
                stringWriter.write(cArray, 0, n);
            }
            cArray = null;
            string2 = stringWriter.toString();
            stringWriter.close();
        }
        catch (Exception exception) {
            throw new BadSpecial(SqltoolRB.file_writefail.getString(string), exception);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        printWriter.write(this.dereference(string2.replaceAll("\\r?\\n", LS), true));
    }

    private void writeFooter(PrintWriter printWriter, String string) throws SqlToolError {
        String string2;
        char[] cArray = new char[1024];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            InputStream inputStream;
            InputStream inputStream2 = inputStream = this.bottomHtmlFile == null ? this.getClass().getResourceAsStream("sqltool/bottom-boilerplate.html") : new FileInputStream(this.bottomHtmlFile);
            if (inputStream == null) {
                throw new IOException("Missing resource: " + (this.bottomHtmlFile == null ? this.bottomHtmlFile : "sqltool/bottom-boilerplate"));
            }
            inputStreamReader = new InputStreamReader(inputStream);
            while ((n = inputStreamReader.read(cArray)) > -1) {
                stringWriter.write(cArray, 0, n);
            }
            cArray = null;
            string2 = stringWriter.toString();
            stringWriter.close();
        }
        catch (Exception exception) {
            throw new SqlToolError(SqltoolRB.file_writefail.getString(string), exception);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        printWriter.write(this.dereference(string2.replaceAll("\\r?\\n", LS), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInlineBlock(Token token, String string, String string2) throws BadSpecial, IOException, SqlToolError {
        assert (token.nestedBlock == null) : "Inline-nest command has .nestBlock pre-populated";
        SqlFileScanner sqlFileScanner = this.scanner;
        try {
            this.scanner = new SqlFileScanner(new StringReader(string2 + '\n'));
            this.scanner.setStdPrintStream(this.shared.psStd);
            this.scanner.setRawLeadinPrompt("");
            this.scanner.setInteractive(this.interactive);
            token.nestedBlock = this.seekTokenSource(null);
        }
        finally {
            this.scanner = sqlFileScanner;
        }
        token.val = string;
    }

    static {
        LS = System.getProperty("line.separator");
        DEFAULT_FILE_ENCODING = System.getProperty("file.encoding");
        hiddenVars = new HashSet<String>(Arrays.asList("?", "*START_TIME", "*VERSION"));
        varPattern = Pattern.compile("\\*?[a-zA-Z]\\w*");
        wordAndDotPattern = Pattern.compile("[\\w.]+");
        specialPattern = Pattern.compile("(\\S+)(?:(\\s+.*\\S))?\\s*");
        plPattern = Pattern.compile("(.*\\S)?\\s*");
        mathAsgnPattern = Pattern.compile("\\(\\(\\s*([a-zA-Z]\\w*)\\s*([-+*/%][-+=])\\s*(.+?)?\\s*\\)\\)\\s*");
        mathPattern = Pattern.compile("\\(\\(\\s*([a-zA-Z]\\w*)\\s*=\\s*(.+?)?\\s*\\)\\)\\s*");
        foreachPattern = Pattern.compile("foreach\\s+(\\S+)\\s*\\(([^)]+)\\)\\s*");
        forrowsPattern = Pattern.compile("forrows((?:\\s+[a-zA-Z]\\w*)*)\\s*");
        forPattern = Pattern.compile("for\\s+(\\(\\(.+\\)\\))?\\s*(\\([^)]+\\))\\s*(\\(\\(.+\\)\\))\\s*");
        ifwhilePattern = Pattern.compile("\\S+\\s*\\(([^)]*)\\)\\s*");
        inlineifPattern = Pattern.compile("(if\\s*\\([^)]*\\))(.*\\S.*)");
        varsetPattern = Pattern.compile("(\\S+)\\s*([=_~:])(.*)?");
        substitutionPattern = Pattern.compile("(\\S)(.+?)\\1(.*?)\\1(.+?)?\\s*");
        slashHistoryPattern = Pattern.compile("\\s*/([^/]+)/\\s*(\\S.*)?");
        historyPattern = Pattern.compile("\\s*(-?\\d+)?\\s*(\\S.*)?");
        useMacroPattern = Pattern.compile("(\\w+)(\\s.*[^;])?(;?)");
        useFnPattern = Pattern.compile("(\\w+\\()\\s*([^;)]*?)\\s*\\)(.*)");
        legacyEditMacroPattern = Pattern.compile("(\\w+(?:\\(\\))?)\\s*:(.*)");
        editMacroPattern = Pattern.compile(":\\s(\\w+(?:\\(\\))?)(?:\\s(.*))?");
        spMacroPattern = Pattern.compile("(\\w+(?:\\(\\))?)\\s+([*\\\\])(.*\\S)");
        sqlMacroPattern = Pattern.compile("(\\w+(?:\\(\\))?)\\s+(.*\\S)");
        integerPattern = Pattern.compile("\\d+");
        nameValPairPattern = Pattern.compile("\\s*(\\w+)\\s*=(.*)");
        dotPattern = Pattern.compile("(\\w*)\\.(\\w*)");
        commitOccursPattern = Pattern.compile("(?is)(?:set\\s+autocommit.*)|(commit\\s*)");
        logPattern = Pattern.compile("(?i)(FINER|WARNING|SEVERE|INFO|FINEST)\\s+(.*\\S)");
        arrayPattern = Pattern.compile("ARRAY\\s*\\[\\s*(.*\\S)?\\s*\\]");
        fnParamPat = Pattern.compile("\\*\\{(:)?(\\d+)\\}");
        nestingPLCommands = new HashMap<String, Pattern>();
        inlineNestPLCommands = new HashMap<String, Pattern>();
        nestingPLCommands.put("if", ifwhilePattern);
        nestingPLCommands.put("while", ifwhilePattern);
        nestingPLCommands.put("foreach", foreachPattern);
        nestingPLCommands.put("forrows", forrowsPattern);
        nestingPLCommands.put("for", forPattern);
        inlineNestPLCommands.put("if", inlineifPattern);
        if (System.getProperty("os.name").startsWith("Windows")) {
            wincmdPattern = Pattern.compile("([^\"]+)?(\"[^\"]*\")?");
        }
        rawPrompt = SqltoolRB.rawmode_prompt.getString() + "> ";
        DSV_OPTIONS_TEXT = SqltoolRB.dsv_options.getString();
        D_OPTIONS_TEXT = SqltoolRB.d_options.getString();
        DSV_X_SYNTAX_MSG = SqltoolRB.dsv_x_syntax.getString();
        DSV_M_SYNTAX_MSG = SqltoolRB.dsv_m_syntax.getString();
        nobufferYetString = SqltoolRB.nobuffer_yet.getString();
        try {
            createArrayOfMethod = Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        revStringLength = revString.length();
        revnum = revStringLength - " $".length() > "$Revision: ".length() ? revString.substring("$Revision: ".length(), revStringLength - " $".length()) : "<UNTRACKED>";
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r', '\f'};
        DEFAULT_ROW_DELIM = LS;
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
    }

    private class RowError
    extends AppendableException {
        static final long serialVersionUID = 754346434606022750L;

        RowError(String string) {
            super(string);
        }

        RowError(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private class BadSubst
    extends Exception {
        static final long serialVersionUID = 7325933736897253269L;

        BadSubst(String string) {
            super(string);
        }
    }

    private class ContinueException
    extends SqlToolError {
        static final long serialVersionUID = 5064604160827106014L;

        public ContinueException() {
        }

        public ContinueException(String string) {
            super(string);
        }
    }

    private class BreakException
    extends SqlToolError {
        static final long serialVersionUID = 351150072817675994L;

        public BreakException() {
        }

        public BreakException(String string) {
            super(string);
        }
    }

    private class QuitNow
    extends SqlToolError {
        static final long serialVersionUID = 1811094258670900488L;

        public QuitNow(String string) {
            super(string);
        }

        public QuitNow() {
        }
    }

    private static class BadSpecial
    extends AppendableException {
        static final long serialVersionUID = 7162440064026570590L;

        BadSpecial(String string) {
            super(string);
            assert (string != null) : "Must construct BadSpecials with non-null message";
        }

        BadSpecial(String string, Throwable throwable) {
            super(string, throwable);
            assert (string != null) : "Must construct BadSpecials with non-null message";
        }
    }

    private static class SharedFields {
        boolean possiblyUncommitteds;
        Connection jdbcConn;
        Map<String, String> userVars = new HashMap<String, String>();
        Map<String, Token> macros = new HashMap<String, Token>();
        PrintStream psStd;
        String encoding;

        SharedFields(PrintStream printStream) {
            this.psStd = printStream;
        }
    }

    private static enum Recursion {
        FILE,
        IF,
        WHILE,
        FOREACH,
        FOR,
        FORROWS;

    }
}

