/*
 * Decompiled with CFR 0.152.
 */
package math.jwave.transforms.wavelets;

import math.jwave.transforms.wavelets.WaveletInterface;

public abstract class Wavelet
implements WaveletInterface {
    protected int _waveLength = 0;
    protected double[] _coeffs = null;
    protected double[] _scales = null;

    @Override
    public double[] forward(double[] arrTime) {
        double[] arrHilb = new double[arrTime.length];
        int k = 0;
        int h = arrTime.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._waveLength; ++j) {
                for (k = (i << 1) + j; k >= arrTime.length; k -= arrTime.length) {
                }
                int n = i;
                arrHilb[n] = arrHilb[n] + arrTime[k] * this._scales[j];
                int n2 = i + h;
                arrHilb[n2] = arrHilb[n2] + arrTime[k] * this._coeffs[j];
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb) {
        double[] arrTime = new double[arrHilb.length];
        int k = 0;
        int h = arrHilb.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._waveLength; ++j) {
                for (k = (i << 1) + j; k >= arrHilb.length; k -= arrHilb.length) {
                }
                int n = k;
                arrTime[n] = arrTime[n] + (arrHilb[i] * this._scales[j] + arrHilb[i + h] * this._coeffs[j]);
            }
        }
        return arrTime;
    }

    @Override
    public int getWaveLength() {
        return this._waveLength;
    }

    public int getLength() {
        return this._coeffs.length;
    }

    @Override
    public double[] getCoeffs() {
        double[] coeffs = new double[this._coeffs.length];
        for (int c = 0; c < this._coeffs.length; ++c) {
            coeffs[c] = this._coeffs[c];
        }
        return coeffs;
    }

    @Override
    public double[] getScales() {
        double[] scales = new double[this._scales.length];
        for (int s = 0; s < this._scales.length; ++s) {
            scales[s] = this._scales[s];
        }
        return scales;
    }
}

