/*
 * Decompiled with CFR 0.152.
 */
package math.jwave;

import math.jwave.Transform;
import math.jwave.transforms.BasicTransform;
import math.jwave.transforms.DiscreteFourierTransform;
import math.jwave.transforms.FastWaveletTransform;
import math.jwave.transforms.WaveletPacketTransform;
import math.jwave.transforms.wavelets.Coif06;
import math.jwave.transforms.wavelets.Daub02;
import math.jwave.transforms.wavelets.Daub03;
import math.jwave.transforms.wavelets.Daub04;
import math.jwave.transforms.wavelets.Haar02;
import math.jwave.transforms.wavelets.Lege02;
import math.jwave.transforms.wavelets.Lege04;
import math.jwave.transforms.wavelets.Lege06;
import math.jwave.transforms.wavelets.Wavelet;

public class JWave {
    public static void main(String[] args) {
        Transform t;
        String waveletTypeList = "Haar02, Daub02, Daub04, Lege02";
        if (args.length < 2 || args.length > 3) {
            System.err.println("usage: JWave [transformType] {waveletType} {noOfSteps}");
            System.err.println("");
            System.err.println("transformType: DFT, FWT, WPT, DWT");
            System.err.println("waveletType : " + waveletTypeList);
            System.err.println("noOfSteps : no of steps forward and reverse; optional");
            return;
        }
        String wType = args[1];
        Wavelet wavelet = null;
        if (wType.equalsIgnoreCase("haar02")) {
            wavelet = new Haar02();
        } else if (wType.equalsIgnoreCase("lege02")) {
            wavelet = new Lege02();
        } else if (wType.equalsIgnoreCase("daub02")) {
            wavelet = new Daub02();
        } else if (wType.equalsIgnoreCase("daub03")) {
            wavelet = new Daub03();
        } else if (wType.equalsIgnoreCase("daub04")) {
            wavelet = new Daub04();
        } else if (wType.equalsIgnoreCase("lege04")) {
            wavelet = new Lege04();
        } else if (wType.equalsIgnoreCase("lege06")) {
            wavelet = new Lege06();
        } else if (wType.equalsIgnoreCase("coif06")) {
            wavelet = new Coif06();
        } else {
            System.err.println("usage: JWave [transformType] {waveletType}");
            System.err.println("");
            System.err.println("available wavelets are " + waveletTypeList);
            return;
        }
        String tType = args[0];
        BasicTransform bWave = null;
        if (tType.equalsIgnoreCase("dft")) {
            bWave = new DiscreteFourierTransform();
        } else if (tType.equalsIgnoreCase("fwt")) {
            bWave = new FastWaveletTransform(wavelet);
        } else if (tType.equalsIgnoreCase("wpt")) {
            bWave = new WaveletPacketTransform(wavelet);
        } else {
            System.err.println("usage: JWave [transformType] {waveletType}");
            System.err.println("");
            System.err.println("available transforms are DFT, FWT, WPT");
            return;
        }
        if (args.length > 2) {
            String argNoOfSteps = args[2];
            int noOfSteps = Integer.parseInt(argNoOfSteps);
            t = new Transform(bWave, noOfSteps);
        } else {
            t = new Transform(bWave);
        }
        double[] arrTime = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        System.out.println("");
        System.out.println("time domain:");
        for (int p = 0; p < arrTime.length; ++p) {
            System.out.printf("%9.6f", arrTime[p]);
        }
        System.out.println("");
        double[] arrFreqOrHilb = t.forward(arrTime);
        if (bWave instanceof DiscreteFourierTransform) {
            System.out.println("frequency domain:");
        } else {
            System.out.println("Hilbert domain:");
        }
        for (int p = 0; p < arrTime.length; ++p) {
            System.out.printf("%9.6f", arrFreqOrHilb[p]);
        }
        System.out.println("");
        double[] arrReco = t.reverse(arrFreqOrHilb);
        System.out.println("reconstruction:");
        for (int p = 0; p < arrTime.length; ++p) {
            System.out.printf("%9.6f", arrReco[p]);
        }
        System.out.println("");
    }
}

