/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.tool;

import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbString;

public class ConsoleLogger
implements ILogger {
    private int i;
    private IStorageEngine engine;

    public ConsoleLogger(IStorageEngine engine) {
        this.engine = engine;
        this.i = 0;
    }

    public ConsoleLogger() {
        this.i = 0;
    }

    @Override
    public void debug(Object o) {
        System.out.println(o);
    }

    @Override
    public void error(Object o) {
        String header = "An internal error occured,please email the error stack trace displayed below to odb.support@neodatis.org";
        System.out.println(header);
        System.out.println(o);
    }

    @Override
    public void error(Object o, Throwable throwable) {
        String header = "An internal error occured,please email the error stack trace displayed below to odb.support@neodatis.org";
        System.out.println(header);
        System.out.println(o);
        System.out.println(OdbString.exceptionToString(throwable, false));
    }

    @Override
    public void info(Object o) {
        if (this.i % 20 == 0 && this.engine != null) {
            System.out.println(this.engine.getSession(true).getCache().toString());
        }
        System.out.println(o);
        ++this.i;
    }
}

