/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.main;

import java.util.List;
import org.neodatis.odb.ClassRepresentation;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.FullInstantiationHelper;
import org.neodatis.odb.core.layers.layer2.instance.InstantiationHelper;
import org.neodatis.odb.core.layers.layer2.instance.ParameterHelper;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoHelper;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;

public class DefaultClassRepresentation
implements ClassRepresentation {
    private IStorageEngine storageEngine;
    private ClassInfo classInfo;
    private IClassIntrospector classIntrospector;

    public DefaultClassRepresentation(IStorageEngine storageEngine, ClassInfo classInfo) {
        this.storageEngine = storageEngine;
        this.classInfo = classInfo;
        this.classIntrospector = OdbConfiguration.getCoreProvider().getClassIntrospector();
    }

    @Override
    public void addUniqueIndexOn(String name, String[] indexFields, boolean verbose) {
        this.storageEngine.addIndexOn(this.classInfo.getFullClassName(), name, indexFields, verbose, false);
    }

    @Override
    public void addIndexOn(String name, String[] indexFields, boolean verbose) {
        this.storageEngine.addIndexOn(this.classInfo.getFullClassName(), name, indexFields, verbose, true);
    }

    @Override
    public void addInstantiationHelper(InstantiationHelper instantiationHelper) {
        this.classIntrospector.addInstantiationHelper(this.classInfo.getFullClassName(), instantiationHelper);
    }

    @Override
    public void addFullInstantiationHelper(FullInstantiationHelper instantiationHelper) {
        this.classIntrospector.addFullInstantiationHelper(this.classInfo.getFullClassName(), instantiationHelper);
    }

    @Override
    public void addParameterHelper(ParameterHelper parameterHelper) {
        this.classIntrospector.addParameterHelper(this.classInfo.getFullClassName(), parameterHelper);
    }

    @Override
    public void removeInstantiationHelper() {
        this.classIntrospector.removeInstantiationHelper(this.classInfo.getFullClassName());
    }

    @Override
    public void removeFullInstantiationHelper() {
        this.classIntrospector.removeInstantiationHelper(this.classInfo.getFullClassName());
    }

    @Override
    public void removeParameterHelper() {
        this.classIntrospector.removeParameterHelper(this.classInfo.getFullClassName());
    }

    @Override
    public boolean existIndex(String indexName) {
        return this.classInfo.hasIndex(indexName);
    }

    @Override
    public void rebuildIndex(String indexName, boolean verbose) {
        this.storageEngine.rebuildIndex(this.classInfo.getFullClassName(), indexName, verbose);
    }

    @Override
    public void deleteIndex(String indexName, boolean verbose) {
        this.storageEngine.deleteIndex(this.classInfo.getFullClassName(), indexName, verbose);
    }

    @Override
    public List<String> getIndexDescriptions() {
        return ClassInfoHelper.getIndexDescriptions(this.classInfo);
    }

    @Override
    public void doNotPersistAttribute(String attributeName) {
        this.classIntrospector.persistFieldOfClass(this.classInfo.getFullClassName(), attributeName, false);
    }

    @Override
    public void persistAttribute(String attributeName) {
        this.classIntrospector.persistFieldOfClass(this.classInfo.getFullClassName(), attributeName, true);
    }
}

